/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerLoginStatusImpl.java $
  $Revision: 8 $
  $Modtime: 1/28/00 12:44p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import javax.naming.*;
import javax.naming.directory.*;
import com.novell.java.lang.*;
import com.novell.service.jncp.*;
import com.novell.service.session.xplat.*;
import com.novell.service.session.*;
import com.novell.service.rfc1960.SearchStringComponent;

/**
* Provides the attribute value of a ServerDirContext.
*
* @see ServerLoginStatus
*/
public class ServerLoginStatusImpl implements
com.novell.utility.naming.directory.StaticAttributeValue,
com.novell.service.server.ServerLoginStatus
{
   private boolean status;
   private boolean empty = true;
   private Session session;

   /**
   * Constructs a ServerLoginStatusImpl attribute value. This
   * constructor is used to manually create attributes for methods
   * such as search().
   */
   public ServerLoginStatusImpl()
   {
   }

   /** @internal
   * Constructs this attribute value and stores the session to the server.
   * This constructor is for use by ServerDirContext
   * @param session The session to the server this attribute is for.
   */
   protected ServerLoginStatusImpl(
         Session session)
   {
      this.session = session;
   }

   /**
    * Determines if the server is allowing logins.
    *
    * @return A boolean set to TRUE if the server is allowing logins; 
    *         otherwise set to FALSE.
    *
    * @exception NSIException When an error occurs retrieving the 
    *                         information.
    */
   public boolean getStatus() throws NSIException
   {
      if(empty)
         getFileServerLoginStatus();
      return status;
   }

   /**
    * Sets the state of the login status.
    *
    * @param value The desired login state as a boolean; TRUE if
    *              the server is to allowing logins; otherwise
    *              set to FALSE.
    */
   public void setStatus(
         boolean value)
      throws NSIException
   {
      if(empty)
         getFileServerLoginStatus();
      status = value;
   }

   /**
   * Get service from the session and fill in the instance values
   */
   private void getFileServerLoginStatus() throws NSIException
   {
      empty = false;
      //only call if valid session. This allows users to new()
      // instances of this class for search()
      if(session == null)
         return;
      BooleanBuffer buf = new BooleanBuffer(true); //initial value is unused
      try
      {
         ((CallsService)session.getService(
            CallsService.KEY)).getFileServerLoginStatus(buf);
      }
      catch(Exception e)
      {
         throw NSIExceptionBuilder.build(e);
      }
      status = buf.booleanValue();
   }

   /** @internal
   */   
   public Attribute buildAttribute() throws NamingException
   {
      return new BasicAttribute(ATTR_ID, this);
   }

   /** @internal
   */   
   public String getID()
   {
      return ATTR_ID;
   }

   /** @internal
   */   
   public boolean compare(
         SearchStringComponent ssc)
      throws NamingException
   {
      int opType = ssc.getOperationType();
      if(opType == SearchStringComponent.PRESENT)
         return true;
      if(opType == SearchStringComponent.EQUALS)
         return equals(ssc.getReplacementObject());
      return false;
   }

   /** @internal
   */   
   public boolean equals(
         Object compObject)
   {
      if(compObject== null || !(compObject instanceof ServerLoginStatusImpl) )
         return false;
      ServerLoginStatusImpl obj = (ServerLoginStatusImpl)compObject;
      if(obj == this)
         return true;
      try
      {
         if(empty)
            getFileServerLoginStatus();
         if(status == obj.getStatus() )
         {
            return true;
         }
         return false;
      }
      catch(NSIException e)
      {
         return false;
      }
   }

   // Server does not support modifying attributes
   // so all of the following methods are not supported.
   /** @internal
   */   
   public void addAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void deleteAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public void modifyAttribute(
         Attribute attr)
   throws NamingException
   {
      throw new javax.naming.directory.AttributeModificationException();
   }

   /** @internal
   */   
   public boolean hasMoreElements()
   {
      return false;
   }

   /** @internal
   */   
   public Object nextElement()
   {
      throw new java.util.NoSuchElementException();
   }

   /** @internal
   */   
   public Object getStaticInterface()
   {
      return this;
   }
}
