/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/server/ServerObjectFactory.java $
  $Revision: 9 $
  $Modtime: 1/09/02 6:08p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.server;

import com.novell.service.session.*;
import com.novell.service.session.xplat.*;
import com.novell.utility.naming.Environment;
import javax.naming.*;
import javax.naming.spi.*;
import java.util.*;

/** @internal
* Creates a ServerDirContext.
*/
public class ServerObjectFactory implements ObjectFactory
{
   /**
   * @param obj                  Should be a reference containing a
   *                             StringRefAddr with Context.PROVIDER_URL
   *                             as the addrType that specifies the server name
   * @param h                    Properties for the context. Will be cloned
   * @return                     The object created.
   * @exception                  if problem
   */
   public Object getObjectInstance(
         Object obj,
         Name name,  //NOTE: name needs to be implemented
         Context nameCtx, //NOTE: name needs to be implemented
         Hashtable h)
      throws Exception
   {
      if(h == null)
         h = new Hashtable();
      String host = (String) ((StringRefAddr)((Reference)obj).
         get(Context.PROVIDER_URL)).getContent();
      Hashtable hash = (Hashtable)h.clone();

      //put in last so it overides any previous entry
      hash.put(Context.PROVIDER_URL, host);

      SessionManager sm = (SessionManager)hash.get(
         com.novell.utility.naming.Environment.SESSION_MANAGER_OBJECT);
      if(sm == null)
      {
         SessionEnv env = new SessionEnv();
         env.put(SessionEnv.INITIAL_SESSION_FACTORY,
            "com.novell.service.session.nds.NDSInitialSessionFactory:" +
            "com.novell.service.session.bindery.BinderyInitialSessionFactory");
         sm = SessionManagerFactory.getSessionManager(env);
         hash.put(com.novell.utility.naming.Environment.SESSION_MANAGER_OBJECT, sm);
      }
      Session session = sm.getSessionTop(host);
      String type = (String)session.getAttributes(new String[] {Session.SESSION_TYPE_ATTR_ID}).
         getValue(Session.SESSION_TYPE_ATTR_ID);
      if(type.equalsIgnoreCase(Xplat.TREE_SESSION_TYPE)) //If passed in a tree name instead of a server
         throw new javax.naming.InvalidNameException(host + " = " + Xplat.TREE_SESSION_TYPE);
      
      hash.put(com.novell.utility.naming.Environment.SESSION_OBJECT, session);
      return new ServerDirContext(hash);
   }
}
