/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/CallsServiceWrapper.java $
  $Revision: 3 $
  $Modtime: 1/18/01 5:22p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.RemoteException;
import com.novell.service.session.*;
import com.novell.service.session.util.Debug;
import com.novell.service.jncp.*;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.file.nw.*;
import com.novell.service.server.*;
import com.novell.service.ncpext.*;
import com.novell.service.file.nw.calls.*;
import com.novell.service.qms.*;
import com.novell.service.session.xplat.CallsServiceRemote.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWCALLS
 * native services (via CalJNI).
 */
public class CallsServiceWrapper
implements CallsService, java.io.Serializable
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   CallsServiceRemote remote;

   public CallsServiceWrapper(CallsServiceRemote obj)
   throws SessionException
   {
      remote = obj;
   }

   public boolean areSLPCallsAvailable()
   throws NSIException, RemoteException
   {
      return remote.areSLPCallsAvailable();
   }

   public void getObjectNamesBeginA
   (
      int type,
      IntegerBuffer handle
   )
   throws NSIException, RemoteException
   {
      handle.setValue(remote.getObjectNamesBeginA(type));
   }

   public void getObjectNamesNextA
   (
      IntegerBuffer handle,
      IntegerBuffer bufLen,
      StringBuffer buf
   )
   throws NSIException, RemoteException
   {
      NextObjectName x = null;
      x = remote.getObjectNamesNextA(
         handle.intValue(),
         bufLen.intValue());
      buf.setLength(0);
      buf.append(x.name);
      //bufLen.setValue(x.length.intValue());
   }

   public void getObjectNamesEndA
   (
      IntegerBuffer handle
   )
   throws NSIException, RemoteException
   {
      remote.getObjectNamesEndA(handle.intValue());
   }

   public String getObjectName
   (
      int objectId,
      IntegerBuffer type
   )
   throws SessionException
   {
      try
      {
         ObjectNameAndType x = remote.getObjectName(objectId);
         type.setValue(x.type.intValue());
         return x.name.toString();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void freePtr(int mallocedPtr)
   throws SessionException
   {
      try
      {
         remote.freePtr(mallocedPtr);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public int allocEAHandle()
   throws SessionException
   {
      try
      {
         return remote.allocEAHandle();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public int allocEAFFStruct()
   throws SessionException
   {
      try
      {
         return remote.allocEAFFStruct();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void addObjectToSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException
   {
      try
      {
         remote.addObjectToSet(
            objName,
            objType,
            propertyName,
            memberName,
            memberType);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void changeObjectSecurity
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int newObjSecurity
   )
   throws SessionException
   {
      try
      {
         remote.changeObjectSecurity(
            objName,
            objType,
            newObjSecurity);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void changePropertySecurity
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      newPropertySecurity
   )
   throws SessionException
   {
      try
      {
         remote.changePropertySecurity(
            objName,
            objType,
            propertyName,
            newPropertySecurity);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void closeBindery ()
   throws SessionException
   {
      try
      {
         remote.closeBindery();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void createObject
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   int objFlags,
      /*in*/   int objSecurity
   )
   throws SessionException
   {
      try
      {
         remote.createObject(
            objName,
            objType,
            objFlags,
            objSecurity);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void createProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      propertyFlags,
      /*in*/   int      propertySecurity
   )
   throws SessionException
   {
      try
      {
         remote.createProperty(
            objName,
            objType,
            propertyName,
            propertyFlags,
            propertySecurity);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }
   public void deleteObject
   (
      /*in */  String objName,
      /*in*/   int objType
   )
   throws SessionException
   {
      try
      {
         remote.deleteObject(
            objName,
            objType);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void deleteObjectFromSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException
   {
      try
      {
         remote.deleteObjectFromSet(
            objName,
            objType,
            propertyName,
            memberName,
            memberType);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void deleteProperty
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName
   )
   throws SessionException
   {
      try
      {
         remote.deleteProperty(
            objName,
            objType,
            propertyName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void disallowObjectPassword
   (
      /*in */  String objName,
      /*in*/   int objType,
      /*in*/   String disallowedPassword
   )

   throws SessionException
   {
      try
      {
         remote.disallowObjectPassword(
            objName,
            objType,
            disallowedPassword);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getBinderyAccessLevel
   (
      /*out*/  IntegerBuffer accessLevel,
      /*out*/  IntegerBuffer objID
   )
   throws SessionException
   {
      try
      {
         BinderyAccessLevel x = remote.getBinderyAccessLevel();
         accessLevel.setValue(
            x.accessLevel.intValue());
         objID.setValue(
            x.objID.intValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getObjectDiskSpaceLeft
   (
      /*in*/   int   objID,
      /*out*/  IntegerBuffer systemElapsedTime,
      /*out*/  IntegerBuffer unusedDiskBlocks,
      /*out*/  IntegerBuffer restrictionEnforced
   )
   throws SessionException
   {
      try
      {
         ObjectDiskSpaceLeft x = remote.getObjectDiskSpaceLeft(objID);
         systemElapsedTime = x.systemElapsedTime;
         unusedDiskBlocks = x.unusedDiskBlocks;
         restrictionEnforced = x.restrictionEnforced;
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getObjectID
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*out*/  IntegerBuffer  objID
   )
   throws SessionException
   {
      try
      {
         objID.setValue(
            remote.getObjectID(objName, objType));
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void isObjectInSet
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   String   memberName,
      /*in*/   int      memberType
   )
   throws SessionException
   {
      try
      {
         remote.isObjectInSet(
            objName,
            objType,
            propertyName,
            memberName,
            memberType);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void openBindery()
   throws SessionException
   {
      try
      {
         remote.openBindery();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void readPropertyValue
   (
      /*in */  String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*out*/  byte[]  segmentData,
      /*out*/  IntegerBuffer   moreSegments,
      /*out*/  IntegerBuffer      flags
   )
   throws SessionException
   {
      try
      {
         PropertyValue x = remote.readPropertyValue(
            objName,
            objType,
            propertyName,
            segmentNum);
         for (int i = 0; i < 128; i++)
            segmentData[i] = x.segmentData[i];
         moreSegments.setValue(
            x.moreSegments.intValue());
         flags.setValue(
            x.flags.intValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void renameObject
   (
      /*in */  String oldObjName,
      /*in*/   String newObjName,
      /*in*/   int objType
   )
   throws SessionException
   {
      try
      {
         remote.renameObject(
            oldObjName,
            newObjName,
            objType);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanObject
   (
      /*in*/      String searchName,
      /*in*/      int searchType,
      /*in/out*/  IntegerBuffer objID,              // optional
      /*out*/     StringBuffer objName,             // optional
      /*out*/     IntegerBuffer objType,            // optional
      /*out*/     IntegerBuffer hasPropertiesFlag,  // optional
      /*out*/     IntegerBuffer objFlags,           // optional
      /*out*/     IntegerBuffer objSecurity         // optional
   )
   throws SessionException
   {
      try
      {
         BinderyObject x = remote.scanObject(
            searchName,
            searchType,
            objID.intValue());
         if(objID != null)
            objID.setValue(x.objID);
         if(objName != null)
         {
            objName.setLength(0);
            objName.append(x.objName);
         }
         if(objType != null)
            objType.setValue(x.objType);
         if(hasPropertiesFlag != null)
            hasPropertiesFlag.setValue(x.hasPropertiesFlag);
         if(objFlags != null)
            objFlags.setValue(x.objFlags);
         if(objSecurity != null)
            objSecurity.setValue(x.objSecurity);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanProperty
   (
      /*in*/      String         objName,
      /*in*/      int            objType,
      /*in*/      String         searchPropertyName,
      /*in/out*/  IntegerBuffer  iterHandle,
      /*out*/     StringBuffer   propertyName,
      /*out*/     IntegerBuffer  propertyFlags,
      /*out*/     IntegerBuffer  propertySecurity,
      /*out*/     IntegerBuffer  valueAvailable,
      /*out*/     IntegerBuffer  moreFlag
   )
   throws SessionException, RemoteException
   {
      try
      {
         BinderyObjectProperty x = remote.scanProperty(
            objName,
            objType,
            searchPropertyName,
            iterHandle.intValue());
         iterHandle.setValue(
             x.iterHandle.intValue());
         propertyName.setLength(0);
         propertyName.append(
             x.propertyName.toString());
         propertyFlags.setValue(
             x.propertyFlags.intValue());
         propertySecurity.setValue(
             x.propertySecurity.intValue());
         valueAvailable.setValue(
             x.valueAvailable.intValue());
         moreFlag.setValue(
             x.moreFlag.intValue());
      }
      catch(NSIException e)
      {
         //Hack to get around problem that moreFlag must be changed even though an
         //exception is thrown. When running remote x.moreFlag is a copy
         //See BinderyObjectDirContext for an explanation
         if(e.getCCode() == ServerErrors.NWE_BIND_NO_SUCH_PROP && e.getRootCause() != null 
            && e.getRootCause().getMessage() != null && e.getRootCause().getMessage().equals("HACK for scanProperty"))
            moreFlag.setValue(0);
         throw e;
      }
   }

   public void writePropertyValue
   (
      /*in*/   String   objName,
      /*in*/   int      objType,
      /*in*/   String   propertyName,
      /*in*/   int      segmentNum,
      /*in*/   byte[]  segmentData, //128 byte buffer.
      /*in*/   boolean  moreSegments
   )
   throws SessionException
   {
      try
      {
         remote.writePropertyValue(
            objName,
            objType,
            propertyName,
            segmentNum,
            segmentData, //128 byte bu
            moreSegments);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getNSEntryInfo
   (
      int dirHandle,    // in
      String path,      // in
      int srcNamSpc,    // in
      int dstNamSpc,    // in
      int attributes,   // in
      int retInfoMask,  // in
      DirectoryEntryInfoImpl entryInfo // out
   )
   throws SessionException
   {
      try
      {
         DirectoryEntryInformation  dei = remote.getNSEntryInfo(
            dirHandle,
            path,
            srcNamSpc,
            dstNamSpc,
            attributes,
            retInfoMask);
         entryInfo.copy(dei);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanNSEntryInfo
   (
      int dirHandle,                         // in
      int nameSpace,                         // in
      int attr,                              // in
      int[] volNumber,                       // inout
      int[] dirNumber,                       // inout
      int[] searchDirNumber,                 // inout
      String pattern,                        // in
      int retInfoMask,                       // in
      DirectoryEntryInfoImpl entryInfo
   )
   throws SessionException
   {
      try
      {
         DirectoryEntryInformationPlus  deip = remote.scanNSEntryInfo(
            dirHandle,
            nameSpace,
            attr,
            volNumber,
            dirNumber,
            searchDirNumber,
            pattern,
            retInfoMask);
         entryInfo.copy(deip.dei);
         volNumber[0] = deip.volNumber[0];
         dirNumber[0] = deip.dirNumber[0];
         searchDirNumber[0] = deip.searchDirNumber[0];
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getVolumeName
   (
      int volNumber,
      String[] volName  // return a new string in first element
   )
   throws SessionException
   {
      try
      {
         volName[0] = remote.getVolumeName(
            volNumber);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getVolumeNumber
   (
      String volName,
      int[] volNumber   // return vol number in first element
   )
   throws SessionException
   {
      try
      {
         volNumber[0] = remote.getVolumeNumber(
            volName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getNSLoadedList
   (
      int volNumber,
      int[][] NSLoadedList // return new int array in first element
   )
   throws SessionException
   {
      try
      {
         NSLoadedList[0] = remote.getNSLoadedList(
            volNumber);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void openCreateNSEntry
   (
      int dirHandle,
      String path,
      int nameSpace,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle           // out
   )
   throws SessionException
   {
      try
      {
         fileHandle[0] = remote.openCreateNSEntry(
            dirHandle,
            path,
            nameSpace,
            openCreateMode,
            searchSessionAttrSet,
            createSessionAttrSet,
            accessRights);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void openNSEntry
   (
      int dirHandle,
      int nameSpace,
      int dataStream,
      String path,
      int openCreateMode,
      int searchSessionAttrSet,
      int createSessionAttrSet,
      int accessRights,
      int[] fileHandle
   )
   throws SessionException
   {
      try
      {
         fileHandle[0] = remote.openNSEntry(
            dirHandle,
            nameSpace,
            dataStream,
            path,
            openCreateMode,
            searchSessionAttrSet,
            createSessionAttrSet,
            accessRights);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void deleteNSEntry
   (
      int dirHandle,
      String filePath,
      int nameSpace,
      int searchAttr
   )
   throws SessionException
   {
      try
      {
         remote.deleteNSEntry(
            dirHandle,
            filePath,
            nameSpace,
            searchAttr);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void NSRename
   (
      int dirHandle,
      int nameSpace,
      String oldName,
      boolean isFile,
      String newName,
      boolean renameInAllNS
   )

   throws SessionException
   {
      try
      {
         remote.NSRename(
            dirHandle,
            nameSpace,
            oldName,
            isFile,
            newName,
            renameInAllNS);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void openEA
   (
      int dirHandle,
      String path,
      String EAName,
      int nameSpace,
      int EAHandle
   )

   throws SessionException
   {
      try
      {
         remote.openEA(
            dirHandle,
            path,
            EAName,
            nameSpace,
            EAHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void closeEA
   (
      int EAHandle
   )
   throws SessionException
   {
      try
      {
         remote.closeEA(
            EAHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void readEA
   (
      int EAHandle,
      byte[] buf,          // out
      int off,
      int len,
      int[] totalEASize,   // out
      int[] bytesRead      // out
   )
   throws SessionException
   {
      try
      {
         ReadEA x = remote.readEA(
            EAHandle,
            off,
            len);
         totalEASize[0] = x.totalEASize[0];
         bytesRead[0] = x.bytesRead[0];
         for (int i = 0; i < x.bytesRead[0]; i++)
            buf[off + i] = x.buf[off + i];
         if(x.ccode == 1) //Special case where the information in "x" must be returned
            throw NSIExceptionBuilder.build(x.ccode);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void writeEA
   (
      int EAHandle,
      int totalWriteSize,
      byte[] buf,
      int off,
      int len,
      int[] bytesWritten
   )
   throws SessionException, RemoteException
   {
      try
      {
         bytesWritten[0] = remote.writeEA(
            EAHandle,
            totalWriteSize,
            buf,
            off,
            len);
      }
      catch(NSIException e)
      {
         if(e.getCCode() == 1) //Special case where bytesWritten must be returned even though there is a non-zero ccode
         {
            bytesWritten[0] = ((NSIException)e.getRootCause()).getCCode();
         }
         throw e;
      }
   }

   public void findFirstEA
   (
      int dirHandle,
      String path,
      int dstNamSpc,
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName  // out
   )
   throws SessionException
   {
      try
      {
         EAName.setLength(0);
         EAName.append(
            remote.findFirstEA(dirHandle, path, dstNamSpc, EAFFStruct, EAHandle));
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void findNextEA
   (
      int EAFFStruct,
      int EAHandle,
      StringBuffer EAName
   )
   throws SessionException
   {
      try
      {
         EAName.setLength(0);
         EAName.append(
            remote.findNextEA(EAFFStruct, EAHandle));
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   // assumes that there are already 20 elements allocated in the
   //   'trusteeList' member of 'tEnum'
   public void scanForTrustees
   (
      int dirHandle,
      String path,
      int nameSpace,
      TrusteeEnumeratorImpl tEnum
   )
   throws SessionException
   {
      try
      {
         TrusteeEnumeratorStruct x = remote.scanForTrustees(
            dirHandle,
            path,
            nameSpace,
            tEnum.out());
         tEnum.in(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getDirSpaceLimitList
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] maxAvailable,
      int[] currentUse
   )
   throws SessionException
   {
      try
      {
         DirSpaceLimit x = remote.getDirSpaceLimitList(
            dirHandle,
            path,
            nameSpace);
         maxAvailable = x.maxAvailable;
         currentUse = x.currentUse;
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void setDirSpaceLimit
   (
      int dirHandle,
      String path,
      int nameSpace,
      int limit
   )
   throws SessionException
   {
      try
      {
         remote.setDirSpaceLimit(
            dirHandle,
            path,
            nameSpace,
            limit);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void setCompressedFileSize
   (
      int OSFileHandle,
      int desiredSize,
      int[] actualSize
   )
   throws SessionException
   {
      try
      {
         actualSize[0] = remote.setCompressedFileSize(
            OSFileHandle,
            desiredSize);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void addTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID,
      int rightsMask
   )
   throws SessionException
   {
      try
      {
         remote.addTrustee(
            dirHandle,
            path,
            nameSpace,
            objID,
            rightsMask);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void deleteTrustee
   (
      int dirHandle,
      String path,
      int nameSpace,
      int objID
   )
   throws SessionException
   {
      try
      {
         remote.deleteTrustee(
            dirHandle,
            path,
            nameSpace,
            objID);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getNSInfo
   (
      int volume,
      int nameSpace
//      NSInformation info
   )
   throws SessionException
   {
/*
      int ccode = CalJNI.NWGetNSInfo(
                                    this.connection,
                                    volume,
                                    nameSpace,
                                    info);
      if (0!= ccode)
*/
      throw new SessionRuntimeException("Not implemented");
   }

   // the 'data' array must be 512 bytes long
   public void readNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data          // out
   )
   // the 'data' array must be 512 bytes long
   throws SessionException
   {
      try
      {
         byte[] x = remote.readNSInfo(
            dirHandle,
            path,
            nameSpace,
            dstNameSpace,
            NSInfoBitMask);
         for (int i = 0; i < 512; i++)
            data[i] = x[i];
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void writeNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int NSInfoBitMask,
      byte[] data       // input parameter
   )
   throws SessionException
   {
      try
      {
         remote.writeNSInfo(
            dirHandle,
            path,
            nameSpace,
            dstNameSpace,
            NSInfoBitMask,
            data);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   // the 'hugeData' array must be big enough to hold any huge data that the
   //   server may choose to send -- it's not doc'd in the NCP doc how big
   // the 'hugeStateInfo' is a 16-byte iter handle
   public void readExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // output parameter
      byte[] hugeData         // output parameter
   )
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWReadExtendedNSInfo(
                                             this.connection,
                                             dirHandle,
                                             path,
                                             nameSpace,
                                             dstNameSpace,
                                             extendedBitMask,
                                             hugeStateInfo,
                                             hugeDataLength,   // output paramete
                                             hugeData );        // output paramete


      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   // the 'hugeStateInfo' is a 16-byte iter handle
   // when this function returns, 'hugeDataLength' will contain an int
   //   that is returned from the server specifying how much of the huge
   //   data was consumed by the name space module
   public void writeExtendedNSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int dstNameSpace,
      int extendedBitMask,
      byte[] hugeStateInfo,
      int[] hugeDataLength,   // input/output parameter
      byte[] hugeData,        // input parameter
      int offset
   )
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWWriteExtendedNSInfo(
                                              this.connection,
                                              dirHandle,
                                              path,
                                              nameSpace,
                                              dstNameSpace,
                                              extendedBitMask,
                                              hugeStateInfo,
                                              hugeDataLength,
                                              hugeData,
                                              offset);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   // the C code underneath really uses the MODIFY_DOS_INFO struct
   //   we're just passing in a DirectoryEntryInformation , because it has
   //   all the information in it that we need.
   // the modifyMask that we pass in here is passed straight to the lib,
   //   and does NOT correspond with the IM_... constants.
   public void setNSEntryDOSInfo
   (
      int dirHandle,
      String path,
      int nameSpace,
      int searchAttr,
      int modifyMask,
      DirectoryEntryInformation info
   )
   throws SessionException
   {
      try
      {
         remote.setNSEntryDOSInfo(
            dirHandle,
            path,
            nameSpace,
            searchAttr,
            modifyMask,
            info);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getVolumeInfoWithNumber
   (
      int volNumber,
      VolumeInformation info  // out
   )
   throws SessionException
   {
      try
      {
         VolumeInformationBase x = remote.getVolumeInfoWithNumber(
            volNumber);
         info.copyBase(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getExtendedVolumeInfo
   (
      int volNumber,
      VolumeInformation info
   )
   throws SessionException
   {
      try
      {
         VolumeInformationExtended x = remote.getExtendedVolumeInfo(
            volNumber);
         info.copyExtended(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getDirSpaceInfo
   (
      int volNumber,
      String path,
      int nameSpace,
      DirectorySpaceInformation info
   )
   throws SessionException
   {
      try
      {
         DirectorySpaceInformation x = remote.getDirSpaceInfo(
            volNumber,
            path,
            nameSpace);
         info.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getDiskUtilization
   (
      int objID,
      int volNum,
      VolumeUtilization data
   )
   throws SessionException
   {
      try
      {
         VolumeUtilization x = remote.getDiskUtilization(
            objID,
            volNum);
         data.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getObjDiskRestrictions
   (
      int volNumber,
      int objectId,
      VolumeRestriction data
   )
   throws SessionException
   {
      try
      {
         VolumeRestriction  x = remote.getObjDiskRestrictions(
            volNumber,
            objectId);
         data.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanVolDiskRestrictions2
   (
      int volNumber,
      VolumeRestrictionEnumeratorImpl data
   )
   throws SessionException
   {
      try
      {
         VolumeRestrictionEnumeratorStruct x =
            remote.scanVolDiskRestrictions2(volNumber, data.out());
         data.in(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void removeObjectDiskRestrictions
   (
      int volNumber,
      int objectId
   )
   throws SessionException
   {
      try
      {
         remote.removeObjectDiskRestrictions(
            volNumber,
            objectId);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void setObjectVolSpaceLimit
   (
      int volNumber,
      int objectId,
      int restriction
   )
   throws SessionException
   {
      try
      {
         remote.setObjectVolSpaceLimit(
            volNumber,
            objectId,
            restriction);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void smMountVolume
   (
      String volName,
      int[] volNumber
   )
   throws SessionException
   {
      try
      {
         remote.smMountVolume(
            volName,
            volNumber);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void smDismountVolumeByName
   (
      String volName
   )
   throws SessionException
   {
      try
      {
         remote.smDismountVolumeByName(
            volName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanMountedVolumes
   (
      int startVolNumber,
      int[][] numbers,
      String[][] names,    // return new array of vol names in first elem.
      int[] nextVolNumber  // return next vol number in first element
   )
   throws SessionException
   {
      try
      {
         MountedVolumes x = remote.scanMountedVolumes(
            startVolNumber);
         numbers[0] = new int[x.numbers[0].length];
         for (int i = 0; i < x.numbers[0].length; i++)
            numbers[0][i] = x.numbers[0][i];
         names[0] = new String[x.names[0].length];
         for (int i = 0; i < x.names[0].length; i++)
            names[0][i] = x.names[0][i];
         nextVolNumber[0] = x.nextVolNumber[0];
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void allocTempNSDirHandle
   (
      int dirHandle,
      String path,
      int srcNameSpace,
      int dstNameSpace,
      int[] newDirHandle
   )
   throws SessionException
   {
      try
      {
         newDirHandle[0] = remote.allocTempNSDirHandle(
            dirHandle,
            path,
            srcNameSpace,
            dstNameSpace);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void deallocateDirectoryHandle
   (
      int dirHandle
   )
   throws SessionException
   {
      try
      {
         remote.deallocateDirectoryHandle(
            dirHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanForDeletedFiles
   (
      int dirHandle,
      int[] iterHandle,
      int[] volNum,
      int[] dirBase,
      DeletedFileInfoImpl info
   )
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWScanForDeletedFiles(
            this.connection,
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            info);

      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   public void purgeDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName
   )
   throws SessionException
   {
      try
      {
         remote.purgeDeletedFile(
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   //
   // does not support the 2.x variant of NWRecoverDeletedFile
   //

   public void recoverDeletedFile
   (
      int dirHandle,
      int iterHandle,
      int volNum,
      int dirBase,
      String delFileName,
      String newFileName
   )
   throws SessionException
   {
      try
      {
         remote.recoverDeletedFile(
            dirHandle,
            iterHandle,
            volNum,
            dirBase,
            delFileName,
            newFileName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getEffectiveRights
   (
      int dirHandle,
      String path,
      int nameSpace,
      int[] effectiveRights
   )
   throws SessionException
   {
      try
      {
         effectiveRights[0] = remote.getEffectiveRights(
            dirHandle,
            path,
            nameSpace);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getObjectEffectiveRights
   (
      int objID,
      int dirHandle,
      String path,
      int nameSpace,
      int[] rights
   )
   throws SessionException
   {
      try
      {
         rights[0] = remote.getObjectEffectiveRights(
            objID,
            dirHandle,
            path,
            nameSpace);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void scanObjectTrusteePaths
   (
      int objID,
      int volNumber,
      int nameSpace,
      int[] iterHandle,
      int[] rights,
      String[] path
   )
   throws SessionException
   {
      try
      {
         TrusteePath x = remote.scanObjectTrusteePaths(
            objID,
            volNumber,
            nameSpace,
            iterHandle[0]);
         iterHandle[0] = x.iterHandle[0];
         rights[0] = x.rights[0];
         path[0] = x.path[0];
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }

      String s = path[0].replace(':', '/');
      s = s.replace('\\', '/');

      path[0] = s;
   }

/* *************************************************************************
* NCP extension natives
****************************************************************************/

   public void getNCPExtensionInfoByName
   (
      /*out*/  NCPExtensionInfoImpl   extension
   )
   throws SessionException
   {
      try
      {
         NCPExtensionInfoImpl x = remote.getNCPExtensionInfo(
            extension.getExtensionName());
         extension.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void ncpExtensionRequest
   (
      /*in*/   int      extensionID,
      /*in*/   byte[]   request,
      /*in*/   short    maxReplyLength,
      /*out*/  Object[] replyHolder   //replyHolder is a one element array
   )
   throws SessionException
   {
      try
      {
         replyHolder[0] = remote.ncpExtensionRequest(
            extensionID,
            request,
            maxReplyLength);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   synchronized public NCPExtensionInfoImpl scanNCPExtensions
   (
      NCPExtensionInfoImpl   extension
   )
   throws SessionException
   {
      try
      {
         NCPExtensionInfoImpl x = remote.scanNCPExtensions(
            extension.getExtensionID());
         extension.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
      return(extension);
   }

   public void createQueueFile2
   (
      int            queueID,
      NWQueueJob     job,
      IntegerBuffer  fileHandle
   )

   throws SessionException
   {
      try
      {
         NWQueueJob x = remote.createQueueFile2(
            queueID,
            job);
         job.copy(x);
         fileHandle.setValue(
            job.getLocalFileHandle());
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void closeFileAndAbortQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException
   {
      try
      {
         remote.closeFileAndAbortQueueJob2(
            queueID,
            jobNumber,
            fileHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void closeFileAndStartQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )

   throws SessionException
   {
      try
      {
         remote.closeFileAndStartQueueJob2(
            queueID,
            jobNumber,
            fileHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void abortServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException
   {
      try
      {
         remote.abortServicingQueueJob2(
            queueID,
            jobNumber,
            fileHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void attachQueueServerToQueue
   (
      int   queueID
   )
   throws SessionException
   {
      try
      {
         remote.attachQueueServerToQueue(
            queueID);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void changeQueueJobEntry2
   (
      int queueID,
      NWQueueJob   job
   )

   throws SessionException
   {
      try
      {
         NWQueueJob x = remote.changeQueueJobEntry2(
            queueID,
            job);
         job.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void changeQueueJobPosition2
   (
      int queueID,
      int jobNumber,
      int newJobPos
   )

   throws SessionException
   {
      try
      {
         remote.changeQueueJobPosition2(
            queueID,
            jobNumber,
            newJobPos);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void changeToClientRights2
   (
      int   queueID,
      int   jobNumber
   )
   throws SessionException
   {
      try
      {
         remote.changeToClientRights2(
            queueID,
            jobNumber);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getQueueJobList2
   (
      int               queueID,
      int               queueStartPos,
      QueueJobListReply job
   )
   throws SessionException
   {
      try
      {
         QueueJobListReply x = remote.getQueueJobList2(
            queueID,
            queueStartPos,
            job);
         job.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

/*
   public void readQueueCurrentSessionAttrSet2
   (
      int queueID,
      IntegerBuffer queueSessionAttrSet,
      IntegerBuffer numberOfJobs,
      IntegerBuffer numberOfServers,
      int[] serverIDlist,
      int[] serverConnList
   )
   throws SessionException
   {
      int ccode = CalJNI.NWReadQueueCurrentSessionAttrSet2(
                                                  this.connection,
                                                  queueID,
                                                  queueSessionAttrSet,
                                                  numberOfJobs,
                                                  numberOfServers,
                                                  serverIDlist,
                                                  serverConnList);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   public void readQueueCurrentStatus2 (
         /*in*/   int   queueID,
         /*out*/  IntegerBuffer queueStatus,
         /*out*/  IntegerBuffer numberOfJobs,
         /*out*/  IntegerBuffer numberOfServers,
         /*out*/  int[] serverIDlist,
         /*out*/  int[] serverConnList)
      throws SessionException
   {
      try
      {
         QueueCurrentStatus x = remote.readQueueCurrentStatus2(
            queueID);
         queueStatus.setValue(
            x.queueStatus.intValue());
         numberOfJobs.setValue(
            x.numberOfJobs.intValue());
         numberOfServers.setValue(
            x.numberOfServers.intValue());
         for (int i = 0; i < x.serverIDlist.length; i++)
            serverIDlist[i] = x.serverIDlist[i];
         for (int i = 0; i < x.serverConnList.length; i++)
            serverConnList[i] = x.serverConnList[i];

      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public void readQueueJobEntry2
   (
      int               queueID,
      int               jobNumber,
      NWQueueJob        job
   )
   throws SessionException
   {
      try
      {
         NWQueueJob x = remote.readQueueJobEntry2(
            queueID,
            jobNumber,
            job);
         job.copy(x);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void removeJobFromQueue2
   (
      int queueID,
      int jobNumber
   )
   throws SessionException
   {
      try
      {
         remote.removeJobFromQueue2(
            queueID,
            jobNumber);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void serviceQueueJob2
   (
      int   queueID,
      int   targetJobType,
      NWQueueJob job,
      IntegerBuffer fileHandle
   )
   throws SessionException
   {
      try
      {
         NWQueueJob x = remote.serviceQueueJob2(
            queueID,
            targetJobType,
            job);
         job.copy(x);
         fileHandle.setValue(
            job.getLocalFileHandle());
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

/*
   public void setQueueCurrentSessionAttrSet2
   (
      int queueID,
      int queueSessionAttrSet
   )
   throws SessionException
   {
      int ccode = CalJNI.NWSetQueueCurrentSessionAttrSet2(
                                                 this.connection,
                                                 queueID,
                                                 queueSessionAttrSet);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/

   public void setQueueCurrentStatus2 (
         /*in*/   int queueID,
         /*in*/   int queueStatus)
      throws SessionException
   {
      try
      {
         remote.setQueueCurrentStatus2(
            queueID,
            queueStatus);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void createQueue
   (
      String   queueName,
      int      queueType,
      int      dirPath,
      String   path,
      IntegerBuffer queueID
   )
   throws SessionException
   {
      try
      {
         queueID.setValue(
            remote.createQueue(
               queueName,
               queueType,
               dirPath,
               path));
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void destroyQueue
   (
      int queueID
   )
   throws SessionException
   {
      try
      {
         remote.destroyQueue(
            queueID);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void detachQueueServerFromQueue
   (
      int   queueID
   )
   throws SessionException
   {
      try
      {
         remote.detachQueueServerFromQueue(
            queueID);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void finishServicingQueueJob2
   (
      int   queueID,
      int   jobNumber,
      int   fileHandle
   )
   throws SessionException
   {
      try
      {
         remote.finishServicingQueueJob2(
            queueID,
            jobNumber,
            fileHandle);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getQueueJobFileSize2
   (
      int queueID,
      int jobNumber,
      IntegerBuffer fileSize
   )
   throws SessionException
   {
      try
      {
         fileSize.setValue(
            remote.getQueueJobFileSize2(
               queueID,
               jobNumber));
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

/* *************************************************************************
* Server natives
****************************************************************************/
   public void getFileServerVersionInfo
   (
      CVersionInfo info
   )
   throws SessionException
   {
      try
      {
         info = remote.getFileServerVersionInfo();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getFileServerInfo
   (
      CNWFSEFileServerInfo info
   )
   throws SessionException
   {
      try
      {
         info = remote.getFileServerInfo();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getFileServerLoginStatus
   (
      BooleanBuffer info
   )
   throws SessionException
   {
      try
      {
         info.setValue(
            remote.getFileServerLoginStatus());
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void loadNLM(String loadCommand)
   throws SessionException
   {
      try
      {
         remote.loadNLM(loadCommand);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void unloadNLM(String NLMName)
   throws SessionException
   {
      try
      {
         remote.unloadNLM(NLMName);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getFileServerDescription
   (
      StringBuffer companyName,
      StringBuffer revision,
      StringBuffer revisionDate,
      StringBuffer copyrightNotice
   )
   throws SessionException
   {
      try
      {
         FileServerDescription x = remote.getFileServerDescription();
         companyName.setLength(0);
         companyName.append(x.companyName);
         revision.setLength(0);
         revision.append(x.revision);
         revisionDate.setLength(0);
         revisionDate.append(x.revisionDate);
         copyrightNotice.setLength(0);
         copyrightNotice.append(x.copyrightNotice);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void getFileServerDateAndTime
   (
      Object[] holder //holder is a one element array
   )
   throws SessionException
   {
      try
      {
         holder[0] = remote.getFileServerDateAndTime();
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void setFileServerDateAndTime
   (
      int year,
      int month,
      int day,
      int hour,
      int minute,
      int second
   )
   throws SessionException
   {
      try
      {
         remote.setFileServerDateAndTime(
            year,
            month,
            day,
            hour,
            minute,
            second);
      }
      catch (java.rmi.RemoteException e)
      {
         if(e.detail instanceof NSIException)
            throw (NSIException)e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void openSemaphore(
      String semaphoreName,
      int resourceAccessCount,
      int[] semaphoreHandle,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWOpenSemaphore(
                     connection,
                     semaphoreName,
                     resourceAccessCount,
                     semaphoreHandle,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   public void examineSemaphore(
      int semaphoreHandle,
      int[] semaphoreValue,
      int[] semaphoreOpenCount)
      throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWExamineSemaphore(
                     connection,
                     semaphoreHandle,
                     semaphoreValue,
                     semaphoreOpenCount);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   public void waitOnSemaphore(int semaphoreHandle, int timeOutValue)
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWWaitOnSemaphore(
         connection,
         semaphoreHandle,
         timeOutValue);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   public void signalSemaphore(int semaphoreHandle)
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWSignalSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }

   public void closeSemaphore(int semaphoreHandle)
   throws SessionException
   {
      throw new SessionRuntimeException("Not implemented");
/*
      int ccode = CalJNI.NWCloseSemaphore(connection, semaphoreHandle);
      if (0!= ccode)
         throw NSIExceptionBuilder.build(ccode);
*/
   }
}



