
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/directory/SearchFilterFactory.java $
  $Revision: 1 $
  $Modtime: 4/21/98 9:58a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.directory;


import java.util.*;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.*;


/** @internal
 * Creates a SearchFilter using a specified Attributes
 *
 * <p>This will create a SearchFilter similar to
 * (&(attrA={0})(attrA={1})(attrB={2})) where the attribute attrA contains two
 * values and attrB contains only one.  The actual values are set in the
 * SearchFilter args array
 *
 * <p>Now named "__Factory" to avoid conflict with Sun's new SearchFilter
 * class in the toolkit.
 * </p>
 */
public class SearchFilterFactory
{
   private Vector attrVals;
   private StringBuffer filterString;

   /**
    * Creates a SearchFilter using a specified Attributes
    *
    * <p>This will create a SearchFilter similar to
    * (&(attrA={0})(attrA={1})(attrB={2})) where the attribute attrA contains two
    * values and attrB contains only one.  The actual values are set in the
    * SearchFilter args array
    * </p>
    *
    * @param as      Attributes containing attribute values to be
    *                added to the search filter.
    */
   public SearchFilterFactory (
         Attributes as)
      throws NamingException
   {
      attrVals = new Vector ();
      int valCount = 0;

      // Build SearchFilter string
      filterString = new StringBuffer ();
      NamingEnumeration ae = as.getAll ();
      while (ae.hasMoreElements ())
      {
         Attribute curAttr = (Attribute)ae.next ();
         Enumeration ve = curAttr.getAll ();
         while (ve.hasMoreElements ())
         {
            filterString.append ("(");
            filterString.append (curAttr.getID ());
            filterString.append ("={");
            filterString.append (valCount++);
            filterString.append ("})");

            // Also add this value to vector for later retrieval
            attrVals.addElement (ve.nextElement ());
         }
      }

      // Wrap with & if multi attrs or a multi value attr
      if ((valCount = attrVals.size ()) > 1)
      {
         filterString.insert (0, "(&");
         filterString.append (")");
      }
   }

   /**
    * Returns the filter expression
    */
   public String getExpression ()
      throws NamingException
   {
      return filterString.toString ();
   }

   /**
    * Returns the filter arguments
    */
   public Object [] getArgs ()
      throws NamingException
   {
      Object [] args = new Object [attrVals.size ()];
      attrVals.copyInto (args);

      return args;
   }
}
