
/* **************************************************************************

  $Archive: /njcl/src/com/novell/utility/naming/spi/ReferenceFactory.java $
  $Revision: 1 $
  $Modtime: 4/21/98 4:05p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.spi;


import java.util.Hashtable;

import javax.naming.Reference;
import javax.naming.NamingException;


/** @internal
 * Reference Factory interface.
 * To be used when a namespcae needs to provide References to contexts.
 *
 * Implementations of this should be called ReferenceFactoryImpl
 */
public interface ReferenceFactory
{
   /**
    * Builds and returns a Reference to a context in this namespace.
    * The Reference returned is determined by the Properties passed.
    */
   public Reference createReference (
         Hashtable hashtable) 
      throws NamingException;

} /* ReferenceFactory */


