/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/java/io/NFile.java $
  $Revision: 7 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.io;

/**
 * Instances of this class represent the name of a file or directory on
 * the host file system. The NFile class is intended to provide an
 * abstraction that deals with most of the machine-dependent complexities
 * of files and pathnames in a machine-independent fashion.
 *
 * <p>The NFile interface is the replacement for the java.io.File class.
 * It is defined in terms of File, in that all methods from File that 
 * could be implemented here have the same signature.
 *
 * <p>The com.novell.service.file.nw.NetwareFile interface extends the
 * NFile interface. The NetwareFile interface provides methods for
 * obtaining attribute values associated with a file object.<p/>
 *
 */
public interface NFile extends java.io.Serializable 
{

 /**
  * Returns the time the file represented by this NFile object was
  * last modified. 
  * 
  * <p>The return value is system dependent. It should not be 
  * interpreted as an absolute time and should be used only to 
  * compare with other values returned by lastModified(). 
  *
  * @return  The time the file specified by this object 
  *          was last modified.
  */
   public long lastModified();

   /**
    * Returns the length of the file represented by this 
    * NFile object. 
    *
    * @return  The length of the file specified by this object.
    */
    public long length();


  /* *
   * Returns the atomic name of the file represented by this object.
   *
   * @return  The atomic name of the file represented by 
   *          this NFile object.
   *
   * @deprecated  Use javax.naming.Bindery.getName.
   */
//   public String getName();

   /* *
    * Tests if this NFile object exists. 
    *
    * @return  Will always return true. To obtain an object that 
    *          is an NFile gaurentees that the file exists.
    *
    * @deprecated  Use javax.naming.Context.lookup. If you have
    *              obtained an object from lookup that is an NFile,
    *              the file exists.
    */
//   public boolean exists();

   /* *
    * Tests if the application can write to this file. 
    *
    * @return  TRUE if the application is allowed to write to a
    *          file whose name is specified by this object; otherwise
    *          FALSE.
    *
    * @deprecated  Use com.novell.java.io.NOutputStreamor
    *              com.novell.java.io.RandomAccess constructors.  
    */
//   public boolean canWrite();

   /* *
    * Tests if the application can read from the specified file. 
    *
    * @return  TRUE if the file specified by this object exists and
    *          the application can read the file; otherwise FALSE.
    *
    * @deprecated  Use com.novell.java.io.NInputStream or
    *              com.novell.java.io.RandomAccess constructors.  
    */
//   public boolean canRead();

   /* *
    * Tests if the file represented by this NFile oject is a
    * normal file. 
    *
    * A file is normal if it is not a directory and satisfies
    * other system-dependent criteria. 
    *
    * @return  TRUE if the file specified by this is a normal
    *          file; otherwise FALSE.
    *
    * @deprecated  Use type narrowing on objects returned from
    *              javax.naming.Context.lookup.
    */
//   public boolean isFile();

   /* *
    * Tests if the file represented by this NFile object is a
    * directory. 
    *
    * @return  TRUE if this NFile object is a directory; otherwise
    * FALSE.
    *
    * @deprecated  Use type narrowing on objects returned from
    *              javax.naming.Context.lookup.
    */
//   public boolean isDirectory();

   /* *
    * Returns a list of names of bindings bound to this NFile
    * object. 
    *
    * @return  An array of binding names bound to this object.
    *
    * @deprecated  Use javax.naming.Context.list.
    */
//   public String[] list();

   /* *
    * Returns a list of names of bindings bound to this NFile
    * object that satisfy the specified filter.
    *
    * @param filter  A filename filter.
    * @return  An array of binding names bound to this 
    *          object that match the filter.
    *
    * @deprecated  Use javax.naming.Context.list.
    *
   public String[] list(java.io.FilenameFilter filter);

FilenameFilter has the following method:
   public boolean accept(java.io.File, String)
   can't do it!

*/

}
