
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/java/lang/HasRootCauses.java $
  $Revision: 5 $
  $Modtime: 1/14/00 4:42p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.lang;


import java.util.Enumeration;


/**
 * Provides an interface that can be implemented by classes having
 * root cause exceptions. HasRootCauses is typically implemented by
 * throwable classes wanting to report the exceptions into which a
 * new exceptiona are wrapped.
 *
 * @see HasRootCause
 */
public interface HasRootCauses
{
  /**
   * Returns an Enumeration object contaning the stored root cause
   * objects.
   *
   * @return The enumeration of root causes; NULL if none exists.
   */
   public Enumeration getRootCauses ();

} /* HasRootCauses */


