/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/NetwareDirectory.java $
  $Revision: 7 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import com.novell.service.jncp.NSIException;

/** 
 * Provides an interface for getting the Directory object attribute
 * values. 
 *
 * <p>The associated Directory object attribute values include
 * Directory Space Information.</p>
 */
public interface NetwareDirectory extends NetwareFile
{
   /**
    * Returns the DirectorySpaceInformation object associated with
    * this file.
    *
    * @exception NSIException when there is an error in getting the
    *                         DirectorySpaceInformation object.
    * 
    * @return  The DirectorySpaceInformation object.
    */
   public DirectorySpaceInformation getDirectorySpaceInformation() 
      throws NSIException;

   /**
    * Modifies the back end DirectorySpaceInformation object associated
    * with this directory.
    *
    * @param  dsi     The DirectorySpaceInformation modify value.
    * @param  mod_op  The modification to preform if the attribute
    *                 is part of the set; valid values are
    *                 DirContext.REPLACE_ATTRIBUTE.
    *
    * @exception NSIException when there is an error in setting the
    *                         DirectorySpaceInformation object.
    */
   public void setDirectorySpaceInformation(
      DirectorySpaceInformation dsi,
      int mod_op) 
      throws NSIException;
}
