/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/file/nw/VolumeRestrictionEnumerator.java $
  $Revision: 6 $
  $Modtime: 12/13/99 3:38p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.file.nw;

import java.util.Enumeration;

/** 
 * Provides an enumeration of VolumeRestrictions from a given volume.
 *
 * <p>VolumeRestrictionEnumerator declares an enumeration interface
 * for obtaining restrictions from a given volume with multiple
 * restrictions.</p>
 *
 * @see VolumeRestriction
 */

public interface VolumeRestrictionEnumerator extends Enumeration
{
/* *************************************************************************
* constants
***************************************************************************/

   /**
    * Attribute ID of VolumeRestrictionEnumerator.
    *
    * <p>(ATTRIBUTE_ID = com.novell.service.file.nw.VolumeRestriction.ATTRIBUTE_ID)
    * </p>
    * @see VolumeRestriction
    */

   public static final String ATTRIBUTE_ID =
      com.novell.service.file.nw.VolumeRestriction.ATTRIBUTE_ID;

   /**
    * Schema Name of VolumeRestrictionEnumerator.
    *
    * <p>(SCHEMA_BINDING_NAME =
    *       com.novell.service.file.nw.VolumeRestriction.SCHEMA_BINDING_NAME)
    * </p>
    * @see VolumeRestriction
    */

   public static final String SCHEMA_BINDING_NAME =
      com.novell.service.file.nw.VolumeRestriction.SCHEMA_BINDING_NAME;

   /**
    * Schema Syntax of VolumeRestrictionEnumerator.
    *
    * <p>(COMPARE_SYNTAX_STRING =
    *       com.novell.service.file.nw.VolumeRestriction.COMPARE_SYNTAX_STRING)
    * </p>
    * @see VolumeRestriction
    */

   public static final String COMPARE_SYNTAX_STRING =
      com.novell.service.file.nw.VolumeRestriction.COMPARE_SYNTAX_STRING;

/* *************************************************************************
* public abstract methods
***************************************************************************/

   /**
    * Returns the typed VolumeRestriction value.
    *
    * @return The next VolumeRestriction in the enumeration.
    *
    * @exception NoSuchElementException if there is no next element
    *            in the enumeration.
    *
    * @see VolumeRestriction
    */

   public VolumeRestriction next();

   /**
    * Returns a boolean indicating if more elements are available in the
    * enumeration.
    *
    * @return A boolean set to TRUE if there are more elements to be
    *         returned; otherwise FALSE is returned.
    */

   public boolean hasMore();

   /**
    * Sets the specific user for which to get volume restrictions.
    *
    * <p>If this method is called, subsequent calls to hasMore() and next()
    * will return only the volume restriction object (user) that you
    * specify here.</p>
    *
    * @param user The user for which to get volume restrictions.
    */

   public void setUser(String user);
}
