/* **************************************************************************

  %name: ncpextJNI.c %
  %version: 7 %
  %date_modified: Thu Feb 12 13:50:22 1998 %
 
  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
#include <sys_api.h>
#include <jni.h>
#include "com_novell_service_jncpv2r_cal_CalJNI.h"
#include "com_novell_service_ncpext_NCPExtensionInfoImpl.h"
#include <nwncpext.h>

#include "JNIString.h"
#include "jncp.h"

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWGetNCPExtensionInfoByName
(
   JNIEnv  *env,
   jclass  obj,
   jint    conn,
   jobject extension
)
{
   NWCCODE cCode;
   nuint32  extensionID;
   nstr8    extensionName[33];
   nuint8   majorVersion, minorVersion, revision;
   jbyteArray arr;
   nuint8   queryData[32];
   jstring  jExtensionName;
   punicode uniExtensionName;
   jclass   cls;
   jmethodID mid;

   cls = (*env)->GetObjectClass(env, extension);
   mid = (*env)->GetMethodID(env, cls, "getExtensionName", "()Ljava/lang/String;");
   jExtensionName = (*env)->CallObjectMethod(env, extension, mid);

   uniExtensionName = (punicode) (*env)->GetStringChars(env, jExtensionName, NULL);

   cCode = __UnicodeToLocalStr (
               extensionName,
               sizeof(extensionName),
               uniExtensionName,
               (*env)->GetStringLength(env,jExtensionName));
   if(cCode != 0)
      goto EXIT;

   cCode = NWGetNCPExtensionInfoByName((NWCONN_HANDLE) conn, extensionName,
      &extensionID, &majorVersion, &minorVersion, &revision, queryData);

   if(cCode == 0)
   {
      mid = (*env)->GetMethodID(env, cls, "setExtensionID", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, (jint) extensionID);

      mid = (*env)->GetMethodID(env, cls, "setMajorVersion", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, (jint) majorVersion);
      mid = (*env)->GetMethodID(env, cls, "setMinorVersion", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, (jint) minorVersion);
      mid = (*env)->GetMethodID(env, cls, "setRevision", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, (jint) revision);

      arr = (*env)->NewByteArray(env, 32);
      if (arr == NULL)  // out of memory
      {
         cCode = (NWCCODE)-1;
         goto EXIT;
      }
      (*env)->SetByteArrayRegion(env, arr, 0, 32, (jbyte *) queryData);
      mid = (*env)->GetMethodID(env, cls, "setQueryData", "([B)V");
      (*env)->CallVoidMethod(env, extension, mid, arr);
   }

EXIT:

   (*env)->ReleaseStringChars(env, jExtensionName, uniExtensionName);
   return (jint) cCode;
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWNCPExtensionRequest
(
   JNIEnv  *env,
   jclass  obj,
   jint    conn,
   jint    extensionID,
   jbyteArray request,
   jshort  maxReplyLength,
   jobjectArray reply
)
{
   NWCCODE  cCode;
   jbyteArray arr;
   nptr requestData, replyData, lockedReplyData;
   nuint16 requestDataLen;
   nuint16 replyLen = maxReplyLength; //must convert to unsigned

   requestData = (*env)->GetByteArrayElements(env, request, NULL);
   requestDataLen = (nuint16) (*env)->GetArrayLength(env, request);
   if(NULL == (replyData = sysMalloc(replyLen)))
   {
      cCode = 0xFFFF;
      goto EXIT;
   }
   #ifdef N_PLAT_NLM
   if(_usingAliasFunctions)
      lockedReplyData = (*_aliasFunctions[0])(replyData, replyLen);
   else
   #endif
      lockedReplyData = replyData;
      
   cCode = NWNCPExtensionRequest((NWCONN_HANDLE) conn, extensionID,
      requestData, requestDataLen, lockedReplyData, &replyLen);
   if(cCode == 0)
   {
      arr = (*env)->NewByteArray(env, replyLen);
      (*env)->SetByteArrayRegion(env, arr, 0, (jsize) replyLen, lockedReplyData);
      (*env)->SetObjectArrayElement(env, reply, 0, arr);
   }

   #ifdef N_PLAT_NLM
   if(_usingAliasFunctions)
   {
      replyLen = maxReplyLength; //reset replyLen to original
      (*_aliasFunctions[1])(lockedReplyData, replyLen);
   }
   #endif

   if(replyData)
      sysFree(replyData);
   EXIT:
   (*env)->ReleaseByteArrayElements(env, request, requestData, 0);
   return (jint) cCode;
}

JNIEXPORT jint JNICALL
Java_com_novell_service_jncpv2r_cal_CalJNI_NWScanNCPExtensions
(
   JNIEnv  *env,
   jclass  obj,
   jint    conn,
   jobject extension
)
{
   NWCCODE  cCode;
   nstr8    cExtensionName[33];
   nuint32  extensionID;
   nuint8   majorVersion, minorVersion, revision;
   nuint8   queryData[32];
   jbyteArray arr;
   jclass cls;
   jmethodID mid;

   cls = (*env)->GetObjectClass(env, extension);
   mid = (*env)->GetMethodID(env, cls, "getExtensionID", "()I");
   extensionID = (*env)->CallIntMethod(env, extension, mid);

   cCode = NWScanNCPExtensions((NWCONN_HANDLE)conn, &extensionID,
      cExtensionName, &majorVersion, &minorVersion, &revision, queryData);

   if(cCode == 0)
   {
      jstring jExtensionName;
      unicode uniBuf[sizeof(cExtensionName)];

      mid = (*env)->GetMethodID(env, cls, "setExtensionID", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, extensionID);

      cCode = __LocalToJavaStr (
                  env,
                  &jExtensionName,
                  uniBuf,
                  cExtensionName);
      if (cCode != 0)
         return (jint) cCode;
      mid = (*env)->GetMethodID(env, cls, "setExtensionName", "(Ljava/lang/String;)V");
      (*env)->CallVoidMethod(env, extension, mid, jExtensionName);

      mid = (*env)->GetMethodID(env, cls, "setMajorVersion", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, majorVersion);
      mid = (*env)->GetMethodID(env, cls, "setMinorVersion", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, minorVersion);
      mid = (*env)->GetMethodID(env, cls, "setRevision", "(I)V");
      (*env)->CallVoidMethod(env, extension, mid, revision);

      arr = (*env)->NewByteArray(env, 32);
      if (arr == NULL)  // out of memory
         return (-1);
      (*env)->SetByteArrayRegion(env, arr, 0, 32, (jbyte *) queryData);
      mid = (*env)->GetMethodID(env, cls, "setQueryData", "([B)V");
      (*env)->CallVoidMethod(env, extension, mid, arr);
   }
   return (jint) cCode;
}
