/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetCaseIgnoreStringJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetCaseIgnoreString
 *    extends NdsCaseIgnoreString
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetCaseIgnoreString)
NetCaseIgnoreStringCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetCaseIgnoreString;
   jclass clsNetCaseIgnoreStringLR;
   //NJCL variables
   pNetCaseIgnoreString sNetCaseIgnoreString;

   clsNetCaseIgnoreStringLR = (*env)->FindClass (env, NETSYNTAXPKG "NetCaseIgnoreString");
   clsNetCaseIgnoreString = (*env)->NewGlobalRef (env, clsNetCaseIgnoreStringLR);
   (*env)->DeleteLocalRef (env, clsNetCaseIgnoreStringLR);

   sNetCaseIgnoreString = (pNetCaseIgnoreString) sysMalloc (sizeof (NetCaseIgnoreString));

   if (NULL != sNetCaseIgnoreString)
   {
      // assign jclass variables
      sNetCaseIgnoreString->cls = clsNetCaseIgnoreString;

      // assign jfieldID variables
      sNetCaseIgnoreString->ID.value = (*env)->GetFieldID (env, clsNetCaseIgnoreString, "value", "Ljava/lang/String;");
   }
   return (sNetCaseIgnoreString);

} /* NetCaseIgnoreStringCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetCaseIgnoreStringCreate
(
   JNIEnv *env,
   pNetCaseIgnoreString sNetCaseIgnoreString,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netCaseIgnoreString = (*env)->AllocObject (env, sNetCaseIgnoreString->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netCaseIgnoreString,
                                 sNetCaseIgnoreString->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netCaseIgnoreString);

} /* NetCaseIgnoreStringCreate () */


#ifdef __cplusplus
}
#endif


