/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetReplicaPointerJNI.h"
#include "NetNetAddressJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetReplicaPointer
 *    extends NdsReplicaPointer
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetReplicaPointer)
NetReplicaPointerCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetReplicaPointer;
   //NJCL variables
   pNetReplicaPointer sNetReplicaPointer;

   {
      jclass clsNetReplicaPointerLR;

      clsNetReplicaPointerLR = (*env)->FindClass (env, NETSYNTAXPKG "NetReplicaPointer");
      clsNetReplicaPointer = (*env)->NewGlobalRef (env, clsNetReplicaPointerLR);
      (*env)->DeleteLocalRef (env, clsNetReplicaPointerLR);
   }

   sNetReplicaPointer = (pNetReplicaPointer) sysMalloc (sizeof (NetReplicaPointer));

   if (NULL != sNetReplicaPointer)
   {
      // assign jclass variables
      sNetReplicaPointer->cls = clsNetReplicaPointer;

      sNetReplicaPointer->sNetNetAddress = NetNetAddressCreateStruct (env);

      // assign jfieldID variables
      sNetReplicaPointer->ID.serverName = (*env)->GetFieldID (env, clsNetReplicaPointer, "serverName", "Ljava/lang/String;");
      sNetReplicaPointer->ID.replicaType = (*env)->GetFieldID (env, clsNetReplicaPointer, "replicaType", "I");
      sNetReplicaPointer->ID.replicaNumber = (*env)->GetFieldID (env, clsNetReplicaPointer, "replicaNumber", "I");
   //   sNetReplicaPointer->ID.replicaAddressHint = (*env)->GetFieldID (env, clsNetReplicaPointer, "replicaAddressHint", "[L" NETSYNTAXPKG "NetNetAddress;");
      sNetReplicaPointer->ID.replicaAddressHint = (*env)->GetFieldID (env, clsNetReplicaPointer, "replicaAddressHint", "[Lcom/novell/service/nds/NdsNetAddress;");
   }
   return (sNetReplicaPointer);

} /* NetReplicaPointerCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetReplicaPointerCreate
(
   JNIEnv *env,
   pNetReplicaPointer sNetReplicaPointer,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netReplicaPointer = (*env)->AllocObject (env, sNetReplicaPointer->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      jstring serverName;

      (*env)->SetObjectField (
                                 env,
                                 netReplicaPointer,
                                 sNetReplicaPointer->ID.serverName,
                        (jobject)(serverName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, serverName);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netReplicaPointer,
                              sNetReplicaPointer->ID.replicaType,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      (*env)->SetIntField (
                              env,
                              netReplicaPointer,
                              sNetReplicaPointer->ID.replicaNumber,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jobjectArray replicaAddressHint;
      // NWNet variables
      nuint32 i, count;
	  pNetNetAddress sNetNetAddress = sNetReplicaPointer->sNetNetAddress;

      count = jncpGetInt32 (env, curPos, limit);

      replicaAddressHint = (*env)->NewObjectArray (env, count, sNetReplicaPointer->sNetNetAddress->cls, NULL);

      for (i = 0; i < count; i++)
      {
         jobject netNetAddress;

         NAlign32 (curPos);
         netNetAddress = (*env)->AllocObject (env, sNetNetAddress->cls);

		 {
            (*env)->SetIntField (
                                    env,
                                    netNetAddress,
                                    sNetNetAddress->ID.type,
                             (jint) jncpGetInt32 (env, curPos, limit));
		 }

		 {
            jbyteArray address;
            pnstr8 cAddress;
            nuint32 length;

            cAddress = jncpGetData (env, curPos, limit, &length);
            address = (*env)->NewByteArray (env, length); 
            (*env)->SetByteArrayRegion (env, address, 0, length, (jbyte *) cAddress); 
            (*env)->SetObjectField (
                                       env,
                                       netNetAddress,
                                       sNetNetAddress->ID.address,
                             (jobject) address);
            (*env)->DeleteLocalRef (env, address);
		 }

         (*env)->SetObjectArrayElement (env, replicaAddressHint, (jsize) i, netNetAddress);
         (*env)->DeleteLocalRef (env, netNetAddress);
      }

      (*env)->SetObjectField (
                                 env,
                                 netReplicaPointer,
                                 sNetReplicaPointer->ID.replicaAddressHint,
                       (jobject) replicaAddressHint);
      (*env)->DeleteLocalRef (env, replicaAddressHint);
   }

   return (netReplicaPointer);

} /* NetReplicaPointerCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    pnchar           serverName;
 *    NWREPLICA_TYPE   replicaType;
 *    NWREPLICA_NUM    replicaNumber;
 *    NWCOUNT          count;
 *    Net_Address_T    replicaAddressHint[?];
 * } Replica_Pointer_T;
 *
 * java array:
 *  | serverName | type | number | count | [hints]*
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetReplicaPointer_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pReplica_Pointer_T replicaPointer;
   NWCOUNT i;
   nuint8 *replicaPointerPtr, *ptr;

   // NdsMemory.handle - ReplicaPointer C struct
   replicaPointer = (pReplica_Pointer_T) cValue;

   // malloc temporary buffer
   replicaPointerPtr = (nuint8 *) sysMalloc (cLength);
   ptr = replicaPointerPtr;

   // build the temporary buffer
   unicpy ((unicode *) ptr, (unicode *) replicaPointer->serverName);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   *(NWREPLICA_TYPE *)(ptr) = replicaPointer->replicaType;
   ptr += sizeof (NWREPLICA_TYPE);

   *(NWREPLICA_NUM *)(ptr) = replicaPointer->replicaNumber;
   ptr += sizeof (NWREPLICA_NUM);

   *(NWCOUNT *)(ptr) = replicaPointer->count;
   ptr += sizeof (NWCOUNT);

   for (i = 0; i < replicaPointer->count; i++)
   {
      Net_Address_T netAddress = replicaPointer->replicaAddressHint[i];

      *(NWNET_ADDR_TYPE *) (ptr) = netAddress.addressType;
      ptr += sizeof (NWNET_ADDR_TYPE);

      *(NWNET_ADDR_LEN *)(ptr) = netAddress.addressLength;
      ptr += sizeof (NWNET_ADDR_LEN);

      memcpy (ptr, netAddress.address, netAddress.addressLength);
      ptr += netAddress.addressLength;
   }

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) replicaPointerPtr);

   // free temporary buffer
   sysFree (replicaPointerPtr);

   return (byteArray);

} /* toByteArray () */


N_GLOBAL_FUNC_C (nptr) 
NetReplicaPointer_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pReplica_Pointer_T replicaPointer;
   nuint8 *dataPtr;
   pnstr8 serverName;
   nuint32 byteCount, i;

   // get byte[]
   byteArray = ptr = (*env)->GetByteArrayElements (env, values, 0);

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Replica_Pointer_T);

   // malloc NetMemory buffer
   replicaPointer = (pReplica_Pointer_T) sysMalloc (length);

   // build the buffer
   serverName = (pnstr8) ptr;
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   replicaPointer->replicaType = *(NWREPLICA_TYPE *) ptr;
   ptr += sizeof(NWREPLICA_TYPE);

   replicaPointer->replicaNumber = *(NWREPLICA_NUM *) ptr;
   ptr += sizeof(NWREPLICA_NUM);

   replicaPointer->count = *(NWCOUNT *) ptr;
   ptr += sizeof(NWCOUNT);

   length += byteCount = (replicaPointer->count - 1) * sizeof(Net_Address_T);
   replicaPointer = (pReplica_Pointer_T) sysRealloc (replicaPointer, length);
   dataPtr = (nuint8 *)(replicaPointer) + sizeof(Replica_Pointer_T) + byteCount;

   for (i = 0; i < replicaPointer->count; i++)
   {
      NWNET_ADDR_LEN addressLength;

      replicaPointer->replicaAddressHint[i].addressType = *(NWNET_ADDR_TYPE *) ptr;
      ptr += sizeof(NWNET_ADDR_TYPE);

      replicaPointer->replicaAddressHint[i].addressLength = addressLength = *(NWNET_ADDR_LEN *) ptr;
      ptr += sizeof(NWNET_ADDR_LEN);

      replicaPointer->replicaAddressHint[i].address = (pnchar) dataPtr;
      memcpy (replicaPointer->replicaAddressHint[i].address, ptr, addressLength);
      ptr += addressLength;
      dataPtr += addressLength;
   }

   replicaPointer->serverName = (pnchar) dataPtr;
   unicpy ((unicode *) replicaPointer->serverName, (unicode *) serverName);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) replicaPointer);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


