/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include <unicode.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetTypedNameJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetTypedName
 *    extends NdsTypedName
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetTypedName)
NetTypedNameCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetTypedName;
   jclass clsNetTypedNameLR;
   //NJCL variables
   pNetTypedName sNetTypedName;

   clsNetTypedNameLR = (*env)->FindClass (env, NETSYNTAXPKG "NetTypedName");
   clsNetTypedName = (*env)->NewGlobalRef (env, clsNetTypedNameLR);
   (*env)->DeleteLocalRef (env, clsNetTypedNameLR);

   sNetTypedName = (pNetTypedName) sysMalloc (sizeof (NetTypedName));

   if (NULL != sNetTypedName)
   {
      // assign jclass variables
      sNetTypedName->cls = clsNetTypedName;

      // assign jfieldID variables
      sNetTypedName->ID.objectName = (*env)->GetFieldID (env, clsNetTypedName, "objectName", "Ljava/lang/String;");
      sNetTypedName->ID.level = (*env)->GetFieldID (env, clsNetTypedName, "level", "I");
      sNetTypedName->ID.interval = (*env)->GetFieldID (env, clsNetTypedName, "interval", "I");
   }
   return (sNetTypedName);

} /* NetTypedNameCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetTypedNameCreate
(
   JNIEnv *env,
   pNetTypedName sNetTypedName,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netTypedName = (*env)->AllocObject (env, sNetTypedName->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      NAlign32 (curPos);
      (*env)->SetIntField (
                              env,
                              netTypedName,
                              sNetTypedName->ID.level,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      (*env)->SetIntField (
                              env,
                              netTypedName,
                              sNetTypedName->ID.interval,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jstring objectName;

      (*env)->SetObjectField (
                                 env,
                                 netTypedName,
                                 sNetTypedName->ID.objectName,
                        (jobject)(objectName = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, objectName);
   }

   return (netTypedName);

} /* NetTypedNameCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    pnchar            objectName;
 *    NWDS_TYPE_LEVEL   level;
 *    NWDS_INTERVAL     interval;
 * } Typed_Name_T;
 *
 * JAVA BYTE ARRAY
 * | objectName | level | interval |
 *
 * C ARRAY
 * | objectNamePtr | level | interval | objectName |
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetTypedName_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray = NULL;
   // NWNet variables
   nuint8 *typedNamePtr;

   // malloc temporary buffer
   if (NULL != (typedNamePtr = (nuint8 *) sysMalloc (cLength)))
   {
      // NWNet variables
      pTyped_Name_T typedName;
      nuint8 *ptr;

      // NdsMemory.handle - typedName C struct
      typedName = (pTyped_Name_T) cValue;

      ptr = typedNamePtr;

      // build the temporary buffer
      unicpy ((unicode *) ptr, (unicode *) typedName->objectName);
      ptr += (unilen ((unicode *) ptr) + 1) * sizeof(unicode);

      *(NWDS_TYPE_LEVEL *) ptr = typedName->level;
      ptr += sizeof(NWDS_TYPE_LEVEL);

      *(NWDS_INTERVAL *) ptr = typedName->interval;

      // allocate return byte[]
      byteArray = (*env)->NewByteArray (env, cLength);
      // copy temporary buffer to byte[]
      (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) typedNamePtr);

      // free temporary buffer
      sysFree (typedNamePtr);
   }

   return (byteArray);

} /* fromCStruct () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetTypedName_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pTyped_Name_T typedName;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(pTyped_Name_T);

   // malloc NetMemory buffer
   typedName = (pTyped_Name_T) sysMalloc (length);
   dataPtr = (nuint8 *)(typedName) + sizeof(Typed_Name_T);

   // build the buffer
   typedName->objectName = (pnchar) dataPtr;
   unicpy ((unicode *) typedName->objectName, (unicode *) ptr);
   ptr += (unilen ((unicode *) ptr) + 1) * sizeof (unicode);

   typedName->level = *(NWDS_TYPE_LEVEL *) ptr;
   ptr += sizeof(NWDS_TYPE_LEVEL);

   typedName->interval = *(NWDS_INTERVAL *) ptr;

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) typedName);

} // toCStruct


#ifdef __cplusplus
}
#endif


