
/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <jni.h>

#include <ntypes.h>

#include <nwdsbuft.h>

#include "NetAttrRecordJNI.h"

#include "jncpWire.h"
#include "jdsAttrRecordList.h"


#define NETPKG         "com/novell/service/jncpv2r/net/"
#define JNCPPKG        "com/novell/service/jncp/"


N_EXTERN_FUNC (jobjectArray)
NetAttrRecordListGetRecords
(
   JDSList list
);

N_EXTERN_FUNC (jobjectArray)
NetAttrRecordListGetEmptyRecords
(
   JDSList list
);

N_EXTERN_FUNC (void)
NetAttrRecordListAddRecords
(
   JDSList list,
   pBuf_T buf
);

N_EXTERN_FUNC (void)
NetAttrRecordListDestroy
(
   JDSList N_FAR *list
);


JDSListInterface NetAttrRecordListInterface = 
{
   NULL,
   NetAttrRecordListGetRecords,
   NetAttrRecordListGetEmptyRecords,
   NetAttrRecordListAddRecords,
   NetAttrRecordListDestroy
};


typedef struct tagBufferNode
{
   nuint32 count;
   pBuf_T buf;

   struct tagBufferNode N_FAR *next;

} BufferNode, N_FAR *pBufferNode;

typedef struct tagAttrRecordList
{
   nuint32 count;

   pBufferNode node;

   nuint32 infoType;

   JNIEnv *env;

   pNetAttrRecord sNetAttrRecord;

} AttrRecordList, N_FAR *pAttrRecordList;


/**
 *
 */
N_GLOBAL_FUNC (JDSList)
jdsAttrRecordListCreate
(
   JNIEnv *env,
   pNetAttrRecord sNetAttrRecord,
   nuint32 infoType
)
{
   // JNCP variables
   pJDSListInterface list;
   pAttrRecordList records;

   list = (pJDSListInterface) sysMalloc (sizeof (JDSListInterface));
   records = (pAttrRecordList) sysMalloc (sizeof (AttrRecordList));

   *list = NetAttrRecordListInterface;
   list->data = records;

   records->count = 0;
   records->node = NULL;
   records->infoType = infoType;
   records->env = env;
   records->sNetAttrRecord = sNetAttrRecord;

   return (list);

} /* NetAttrRecordListCreate () */

/**
 *
 */
N_GLOBAL_FUNC (jobjectArray)
NetAttrRecordListGetEmptyRecords
(
   JDSList list
)
{
   // JNCP variables
   pAttrRecordList recordList = (pAttrRecordList) list->data;
   pNetAttrRecord sNetAttrRecord = recordList->sNetAttrRecord;
   // JNI variables
   JNIEnv *env = recordList->env;

   return ((*env)->NewObjectArray (env, 0, sNetAttrRecord->cls, NULL));
}

/**
 *
 */
N_GLOBAL_FUNC (jobjectArray)
NetAttrRecordListGetRecords
(
   JDSList list
)
{
   // JNCP variables
   pAttrRecordList recordList = (pAttrRecordList) list->data;
   pNetAttrRecord sNetAttrRecord = recordList->sNetAttrRecord;
   pBufferNode node;
   // JNI variables
   JNIEnv *env = recordList->env;
   jobjectArray records = NULL;
   // NWNet variables
   nuint32 infoType = recordList->infoType;
   nuint32 tcount = 0;

   records = (*env)->NewObjectArray (env, recordList->count, sNetAttrRecord->cls, NULL);

   for (node = recordList->node; NULL != node; node = node->next)
   {
      nuint32 position, i, count = node->count;
      pBuf_T buf = node->buf;

      position = count-1 + tcount;

      for (i = 0; i < count; i++)
      {
         jobject attrRecord;

         attrRecord = NetAttrRecordCreate (env, sNetAttrRecord, infoType, buf);
         (*env)->SetObjectArrayElement (env, records, (jsize) position--, attrRecord);
         (*env)->DeleteLocalRef (env, attrRecord);
      }
      tcount += count;
   }
   return (records);

}

/**
 *
 */
N_GLOBAL_FUNC (void)
NetAttrRecordListAddRecords
(
   JDSList list,
   pBuf_T buf
)
{
   // JNCP variables
   pAttrRecordList recordList = (pAttrRecordList) list->data;
   pBufferNode node;
   // JNI variables
   JNIEnv *env = recordList->env;

   node = (pBufferNode) sysMalloc (sizeof (BufferNode));

   if (buf->curLen)
   {
      nuint32 count = jncpGetInt32 (env, &buf->curPos, buf->data + buf->curLen);

      recordList->count += node->count = count;
   }
   else
   {
      node->count = 0;
   }

   node->buf = buf;

   node->next = recordList->node;
   recordList->node = node;

}

/**
 *
 */
N_GLOBAL_FUNC (void)
NetAttrRecordListDestroy
(
   JDSList N_FAR *list
)
{
   // JNCP variables
   pAttrRecordList recordList = (pAttrRecordList) (*list)->data;

   while (recordList->node)
   {
      pBufferNode node = recordList->node;

      recordList->node = node->next;
      NWDSFreeBuf (node->buf);
      sysFree (node);
   }
   sysFree (recordList);
   sysFree ((JDSListInterface *) *list);
   *list = NULL;

}


