/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/BasicNetService.java $
  $Revision: 52 $
  $Modtime: 11/12/03 4:50p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;

import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2r.clx.ClxJNI;
import com.novell.service.jncpv2r.net.NetServiceRemote.*;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;

import com.novell.service.session.SessionException;
import com.novell.service.session.spi.RMISocketFactories;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.NDSContextInfo;
import com.novell.service.session.xplat.NativeContext;
import com.novell.service.session.xplat.Natives;

/** @internal
 * Remote Object that wraps all NWNET native services (via NetJNI).
 */
public class BasicNetService extends UnicastRemoteObject
implements NetServiceRemote
{
   /**
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
// Please leave OLD versions here but commented out for the purpose of
// tracking unique identifiers.
//   public static final String KEY =
//"com.novell.service.jncpv2r.net.NetService.1039844522";
   public static final String KEY =
"com.novell.service.jncpv2r.net.BasicNetService.1039844522";


   /**
    * Optimization data for listEntries() and readEntry()
    */
   private static int sNetEntryInfo;

   /**
    * Optimization data for readAttributes()
    */
   private static int sNetAttrRecord;


   static
   {
      /*
       * A bug in the JDK 1.1 VM causes it to garbage collect classes much 
       * too aggressively. (This bug has been fixed in the 1.2x VM 
       * implementations) 
       */
      Thread t = new Thread ("BasicNetService")
         {
            private Class cls = BasicNetService.class;

            public synchronized void run ()
            {
               try
               {
                  wait ();
               }
               catch (InterruptedException e)
               {
               }
            }
         };

      t.setDaemon (true);
      t.start ();

      sNetEntryInfo = NetJNI.JDSGetEntryInfoStruct ();
      sNetAttrRecord = NetJNI.JDSGetAttrRecordStruct ();
   }


   protected NDSContext context;
   protected int threadGroup;
   protected int hdlContext;
   NativeContext nativeContext;
//   protected Connection connection;
//   protected int hdlConnection;

   /**
    *
    */
   public BasicNetService(NDSContext context, RMISocketFactories x)
   throws SessionException, java.rmi.RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
      initialize(context);
   }

   public BasicNetService(NDSContext context)
   throws SessionException, java.rmi.RemoteException
   {
      initialize(context);
   }

   private void initialize
   (
      NDSContext context
   )
   throws SessionException, RemoteException
   {
      this.context = context;
      nativeContext = context.getNativeHandle();
      threadGroup = nativeContext.threadGroup;
      hdlContext = context.getHandle();
//      this.connection = context.getConnection ();
//      hdlConnection = connection.getHandle ();
   }


   // ******************** Context Interface ********************

   /**
    *
    */
   public void setConfidence (
         int level)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      // set DCK_CONFIDENCE
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_CONFIDENCE,
                        new Integer (level));
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }

   public void setNameCacheDepth (
         int depth)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      // set DCK_CONFIDENCE
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_NAME_CACHE_DEPTH,
                        new Integer (depth));
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }

   /**
    *
    */
   public void setTypelessNames (
         boolean flag)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      Integer flags;
      NDSContextInfo info = new NDSContextInfo ();

      // Get flags on the context handle.
      ccode = ClxJNI.NWDSGetContext (
                                       threadGroup,
                                       hdlContext,
                                       ClxJNI.DCK_FLAGS,
                                       info);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      flags = (Integer) info.getValue ();
      if (flag)
      {
         // turn DCV_TYPELESS_NAMES on
         flags = new Integer (
                        flags.intValue () | ClxJNI.DCV_TYPELESS_NAMES);
      }
      else
      {
         // turn DCV_TYPELESS_NAMES off
         flags = new Integer (
                        flags.intValue () & ~ClxJNI.DCV_TYPELESS_NAMES);
      }

      // set DCK_FLAGS
      ccode = ClxJNI.NWDSSetContext (
                        threadGroup,
                        hdlContext,
                        ClxJNI.DCK_FLAGS,
                        flags);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* setTypelessNames () */


   public final String canonicalizeName
   (
      String objectName
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer canonName = new StringBuffer();
      int ccode = NetJNI.NWDSCanonicalizeName(
            threadGroup,
            this.hdlContext,
            objectName,
            canonName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return canonName.toString();
   }


   /**
    *
    */
   public final String getServerDN ()
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      StringBuffer serverDN = new StringBuffer ();
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      ccode = NetJNI.NWDSGetServerDN (
                        threadGroup,
                        this.hdlContext,
                        hdlConnection,
                        serverDN);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (new String (serverDN));

   } /* getServerDN () */


   public final void addFilterToken
   (
      int cur,
      int tok,
      int val,
      int syntaxID
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSAddFilterToken(
         cur,
         tok,
         val,
         syntaxID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

   }

   /**
    *
    */
   public final void addFilterToken (
         /*in*/   int                  cur,
         /*in*/   int                  tok,
         /*in*/   byte[]               val,
         /*in*/   int                  syntaxID)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.JDSAddFilterToken (cur, tok, val, syntaxID);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }
   }


   /**
    *
    */
   public final void addObject (
      String objectName,
      NetIterationHandle iterationHandle,
      boolean more,
      int buf)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.NWDSAddObject (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        iterationHandle,
                        more,
                        buf);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* addObject () */

   /**
    *
    */
   public final int allocBuf (
         int size)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      NWInteger handle = new NWInteger ();

      if ((ccode = NetJNI.NWDSAllocBuf (size, handle)) != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }
      return (handle.getValue ());

   } /* allocBuf () */

   /**
    *
    */
   public final int allocFilter (
         int cur)
      throws SessionException, java.rmi.RemoteException
   {
      NWInteger x = new NWInteger(cur);
      int ccode = NetJNI.NWDSAllocFilter (x);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
      return (x.getValue());

   }
/*
   public final NetIterationHandle dsBackupObject (
         String objectName,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.NWDSBackupObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }
      return iterationHandle;

   } // dsBackupObject ()
*/
   public final void beginClassItem
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSBeginClassItem (
         threadGroup,
         this.hdlContext,
         buf);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public final void compare
   (
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched
    )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSCompare(
         threadGroup,
         this.hdlContext,
         object,
         buf,
         matched);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode );
   }

   /**
    *
    */
   public final void closeIteration (
         int iterationHandle,
         int operation)
      throws SessionException, java.rmi.RemoteException
   {
      if (operation != NetJNI.DSV_ITERATOR)
      {
         int ccode;

         ccode = NetJNI.NWDSCloseIteration (
                        threadGroup,
                        this.hdlContext,
                        iterationHandle,
                        operation);

         if (ccode != 0)
         {
            throw NSIExceptionBuilder.build (ccode);
         }
      }

   } /* closeIteration () */

   public final void freeBuf
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSFreeBuf(buf);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final int getAttrCount (
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      IntegerBuffer attrCount = new IntegerBuffer ();

      ccode = NetJNI.NWDSGetAttrCount (
         threadGroup,
         hdlContext,
         buf,
         attrCount);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
      return (attrCount.intValue ());

   } /* getAttrCount () */

   public final int getClassDefCount
   (
         /*in*/   int         buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer classDefCount = new IntegerBuffer();
      int ccode = NetJNI.NWDSGetClassDefCount(
         threadGroup,
         this.hdlContext,
         buf,
         classDefCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return classDefCount.intValue();
   }

   /**
    *
    */
   public final AttrDef getAttrDef (
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      AttrDef x = new AttrDef();
      int ccode;

      ccode = NetJNI.NWDSGetAttrDef(
         threadGroup,
         this.hdlContext,
         buf,
         x.attrName,
         x.attrInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;
   } /* getAttrDef () */

   /**
    *
    */
   public final ClassDef getClassDef (
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      ClassDef x = new ClassDef();
      int ccode;

      ccode = NetJNI.NWDSGetClassDef(
         threadGroup,
         this.hdlContext,
         buf,
         x.className,
         x.classInfo);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;
   } /* getClassDef () */

   public final int getClassItemCount
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      IntegerBuffer  itemCount = new IntegerBuffer();
      int ccode = NetJNI.NWDSGetClassItemCount(
         threadGroup,
         this.hdlContext,
         buf,
         itemCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      return itemCount.intValue();
   }



   public final String getClassItem
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer   itemName = new StringBuffer();

      int ccode = NetJNI.NWDSGetClassItem(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return itemName.toString();
   }


   public final int getObjectCount
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      NWInteger objectCount = new NWInteger();
      int ccode = NetJNI.NWDSGetObjectCount(
         threadGroup,
         this.hdlContext,
         buf,
         objectCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return objectCount.getValue();
   }

   /**
    *
    */
   public final ObjectName getObjectName (
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      ObjectName x = new ObjectName();
      int ccode;

      ccode = NetJNI.NWDSGetObjectName(
         threadGroup,
         this.hdlContext,
         buf,
         x.objectName,
         x.attrCount,
         x.objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;

   } /* getObjectName () */


   public final int getSyntaxCount
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException
   {
      NWInteger      syntaxCount = new NWInteger();
      int ccode = NetJNI.NWDSGetSyntaxCount(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxCount);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return syntaxCount.getValue();
   }


   public final SyntaxDef getSyntaxDef (
         int            buf)
      throws SessionException, java.rmi.RemoteException
   {
      SyntaxDef x = new SyntaxDef();
      int ccode;

      ccode = NetJNI.NWDSGetSyntaxDef(
         threadGroup,
         this.hdlContext,
         buf,
         x.syntaxName,
         x.syntaxDef);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;

   } /* getSyntaxDef () */

   /**
    *
    */
   public final void initBuf (
         int operation,
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      if ((ccode = NetJNI.NWDSInitBuf (threadGroup, hdlContext,
            operation, buf)) != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* initBuf () */

   /**
    *
    */
   public final ListStruct list (
         String objectName,
         NetIterationHandle iterationHandle)
      throws SessionException, java.rmi.RemoteException
   {
      ListStruct x = new ListStruct(iterationHandle);
      int ccode;

      ccode = NetJNI.NWDSList (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        x.iterationHandle,
                        x.subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;

   } /* list () */

   /**
    *
    */
   public final ListStruct listContainers (
         String objectName,
         NetIterationHandle iterationHandle)
      throws SessionException, java.rmi.RemoteException
   {
      ListStruct x = new ListStruct(iterationHandle);
      int ccode;

      ccode = NetJNI.NWDSListContainers (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        x.iterationHandle,
                        x.subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;
   } /* listByClassAndName () */

   /**
    *
    */
   public final ListStruct listByClassAndName (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle)  //out
      throws SessionException, java.rmi.RemoteException
   {
      ListStruct x = new ListStruct(iterationHandle);
      int ccode = NetJNI.NWDSListByClassAndName(
         threadGroup,
         this.hdlContext,
         objectName,
         className,
         subordinateName,
         x.iterationHandle,
         x.subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;
   } /* listByClassAndName () */


   /**
    *
    */
   public final NetEntryInfo[] listEntries (
         String objectName,
         int bufferSize)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      NetEntryInfo[][] entries = new NetEntryInfo[1][];

      ccode = NetJNI.JDSListObjectEntries (
                                             threadGroup,
                                             this.hdlContext,
                                             BasicNetService.sNetEntryInfo,
                                             objectName,
                                             bufferSize,
                                             entries);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (entries[0]);

   } /* listEntries () */


   public final void putChange
   (
         /*in*/   int            buf,
         /*in*/   int            changeType,
         /*in*/   String         attrName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutChange(
         threadGroup,
         this.hdlContext,
         buf,
         changeType,
         attrName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void putClassItem
   (
         /*in*/   int         buf,
         /*in*/   String      itemName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutClassItem(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutFilter(
         threadGroup,
         this.hdlContext,
         buf,
         cur,
         freeVal);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public final void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.JDSPutFilter(
         threadGroup,
         this.hdlContext,
         buf,
         cur);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final ObjectInfo readObjectInfo (
         String         objectName)
      throws SessionException, java.rmi.RemoteException
   {
      ObjectInfo x = new ObjectInfo();
      int ccode = NetJNI.NWDSReadObjectInfo(
         threadGroup,
         this.hdlContext,
         objectName,
         x.distinguishedName,
         x.objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return x;
   } /* readObjectInfo () */

   public final String mapIDToName
   (
         /*in*/   int            objectID
   )
   throws SessionException, java.rmi.RemoteException
   {
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();
      StringBuffer   object = new StringBuffer();
      int ccode = NetJNI.NWDSMapIDToName(
         threadGroup,
         this.hdlContext,
         hdlConnection,
         objectID,
         object);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return object.toString();
   }


   public final int mapNameToID
   (
         /*in*/   String         object
   )
   throws SessionException, java.rmi.RemoteException
   {
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();
      IntegerBuffer  objectID = new IntegerBuffer();
      int ccode = NetJNI.NWDSMapNameToID(
         threadGroup,
         this.hdlContext,
         hdlConnection,
         object,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return objectID.intValue();
   }

   /**
    *
    */
   public final NetIterationHandle modifyObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int changes)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSModifyObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         more,
         changes);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return iterationHandle;
   } /* modifyObject () */


 public final void modifyDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSModifyDN(
         threadGroup,
         this.hdlContext,
         objectName,
         newDN,
         deleteOldRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void modifyRDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSModifyRDN(
         threadGroup,
         this.hdlContext,
         objectName,
         newDN,
         deleteOldRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void moveObject
 (
      String     objectName,
      String     destParentDN,
      String     destRDN

)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSMoveObject(
         threadGroup,
         this.hdlContext,
         objectName,
         destParentDN,
         destRDN);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final int openStream
 (
      String      objectName,
      String      attrName,
      int         flags
)
   throws SessionException, java.rmi.RemoteException
   {
      NWInteger   fileHandle = new NWInteger();
      int ccode = NetJNI.NWDSOpenStream(
         threadGroup,
         this.hdlContext,
         objectName,
         attrName,
         flags,
         fileHandle);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return fileHandle.getValue();
   }

   /**
    *
    */
   public final NetIterationHandle read (
         String object,
         int infoType,
         boolean allAttrs,
         int attrNames,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRead(
         threadGroup,
         this.hdlContext,
         object,
         infoType,
         allAttrs,
         attrNames,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return iterationHandle;

   } /* read () */


   /**
    *
    */
   public NetAttrRecord[] readAttributes (
         /*in*/   String   objectName,
         /*in*/   int      infoType,
         /*in*/   int      attrNames,
         /*in*/   int      bufferSize)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      NetAttrRecord[][] records = new NetAttrRecord[1][];

      ccode = NetJNI.JDSReadObjectAttributes (
                                                threadGroup,
                                                this.hdlContext,
                                                BasicNetService.sNetAttrRecord,
                                                objectName,
                                                infoType,
                                                attrNames,
                                                bufferSize,
                                                records);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (records[0]);

   } /* readAttributes () */


   /**
    *
    */
   public final ReadAttrDefStruct readAttrDef (
         int                     infoType,
         boolean                 allAttrs,
         int                     attrNames,
         NetIterationHandle      iterationHandle,
         NetReadAttrDefBuffer    attrDefs)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.NWDSReadAttrDef(
                        threadGroup,
                        this.hdlContext,
                        infoType,
                        allAttrs,
                        attrNames,
                        iterationHandle,
                        attrDefs.getBuffer ());

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      ReadAttrDefStruct struct = new ReadAttrDefStruct();
      struct.handle = iterationHandle;
      struct.buffer = attrDefs;
      return struct;
   } /* readAttrDef () */


 public final void removeObject
 (
      String     object

)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRemoveObject(
         threadGroup,
         this.hdlContext,
         object);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final ResolveNameStruct resolveName
   (
         /*in*/   String      objectName
   )
   throws SessionException, java.rmi.RemoteException
   {
      ResolveNameStruct x = new ResolveNameStruct();
      NWInteger conn = new NWInteger();
      NWInteger objectID = new NWInteger();
      int ccode = NetJNI.NWDSResolveName(
         threadGroup,
         this.hdlContext,
         objectName,
         conn,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      x.conn = conn.getValue();
      x.objectID = objectID.getValue();
      return x;
   }

/*
   public final void restoreObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int size,
         int objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRestoreObject(
         threadGroup,
         this.hdlContext,
         objectName,
         iterationHandle,
         more,
         size,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } // restoreObject ()
*/

   public final SearchInfo search (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    // a filter buffer.
         int         infoType,
         boolean     allAttrs,
         int         attrNames, // a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         int         objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      SearchInfo x = new SearchInfo(iterationHandle);
      int ccode = NetJNI.NWDSSearch(
         threadGroup,
         this.hdlContext,
         baseObjectName,
         scope,
         searchAliases,
         filter,    // a filter buf
         infoType,
         allAttrs,
         attrNames, // a buffer wit
         x.iterationHandle,
         countObjectsToSearch,
         x.countObjectsSearched,
         objectInfo); // buffer to re

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return x;
   } /* search () */



 public final ResolveNameStruct auditGetObjectID
 (
      String         objectName

)
   throws SessionException, java.rmi.RemoteException
   {
      ResolveNameStruct x = new ResolveNameStruct();
      NWInteger      conn = new NWInteger();
      NWInteger      objectID = new NWInteger();
      int ccode = NetJNI.NWDSAuditGetObjectID(
         threadGroup,
         this.hdlContext,
         objectName,
         conn,
         objectID);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
      x.conn = conn.getValue();
      x.objectID = objectID.getValue();
      return x;
   }

   /**
    *
    */
   public final int getEffectiveRights (
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName)
      throws SessionException, java.rmi.RemoteException
   {
      NWInteger   privileges = new NWInteger();
      int ccode;

      ccode = NetJNI.NWDSGetEffectiveRights(
                        threadGroup,
                        this.hdlContext,
                        subjectName,
                        objectName,
                        attrName,
                        privileges);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return privileges.getValue();
   } /* getEffectiveRights () */


   /**
    *
    */
   public NetIterationHandle listAttrsEffectiveRights (
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.NWDSListAttrsEffectiveRights (
                        threadGroup,
                        this.hdlContext,
                        objectName,
                        subjectName,
                        allAttrs,
                        attrNames,
                        iterationHandle,
                        privilegeInfo);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return iterationHandle;
   } /*  */

   /**
    *
    */
   public final int computeAttrValSize (
         int buf,
         int syntaxID)
      throws SessionException, java.rmi.RemoteException
   {
      NWInteger attrValSize = new NWInteger();

      int ccode;

      ccode = NetJNI.NWDSComputeAttrValSize(
                        threadGroup,
                        this.hdlContext,
                        buf,
                        syntaxID,
                        attrValSize);
      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return attrValSize.getValue();
   } /* computeAttrValSize () */


   public final String abbreviateName
   (
         /*in*/   String         inName
   )
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer   abbreviatedName = new StringBuffer();
      int ccode = NetJNI.NWDSAbbreviateName(
         threadGroup,
         this.hdlContext,
         inName,
         abbreviatedName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return abbreviatedName.toString();
   }

   /**
    *
    */
   public final String removeAllTypes (
         String         name)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      StringBuffer typelessName = new StringBuffer (NetService.MAX_DN_CHARS);

      ccode = NetJNI.NWDSRemoveAllTypes (
         threadGroup,
         this.hdlContext,
         name,
         typelessName);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }
      return (new String (typelessName));

   } /* removeAllTypes () */


   public final boolean cIStringsMatch
   (
         /*in*/   String      string1,
         /*in*/   String      string2
   )
   throws SessionException, java.rmi.RemoteException
   {
      NWBoolean   matches = new NWBoolean(false);
      int ccode = NetJNI.NWDSCIStringsMatch(
         threadGroup,
         this.hdlContext,
         string1,
         string2,
         matches);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return matches.getValue();
   }

   /**
    *
    */
   public final AttrName getAttrName (
         int buf)
      throws SessionException, java.rmi.RemoteException
   {
      AttrName x = new AttrName();
      int ccode = NetJNI.NWDSGetAttrName (
                              threadGroup,
                              this.hdlContext,
                              buf,
                              x.attrName,
                              x.attrValCount,
                              x.syntaxID);
      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return x;
   } /* getAttrName () */

   /**
    *    @deprecated    use getAttributeValue() instead
    */
   public final NetMemory getAttrVal (
         int         buf,
         int         syntaxID)
      throws SessionException, java.rmi.RemoteException
   {
      NetMemory   attrVal = new NetMemory(0); // NOTE: invalid size
      int ccode = NetJNI.NWDSGetAttrVal(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxID,
         attrVal);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return attrVal;
   } /* getAttrVal () */

   /**
    *
    */
   public final byte[] getAttributeValue (
         int         buf,
         int         syntaxID)
   throws SessionException, java.rmi.RemoteException
   {
      byte[][] attributeValue = new byte[1][];

      int ccode = NetJNI.JDSGetAttributeValue (
                                                   threadGroup,
                                                   this.hdlContext,
                                                   buf,
                                                   syntaxID,
                                                   attributeValue);
      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return (attributeValue[0]);

   } /* getAttributeValue () */


 public final void putAttrName
 (
      int         buf,
      String      attrName

)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutAttrName(
         threadGroup,
         this.hdlContext,
         buf,
         attrName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 /**
  *    @deprecated    use getAttributeValue() instead
  */
   public final void putAttrVal(
      int         buf,
      int         syntaxID,
      int         attrVal)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutAttrVal(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxID,
         attrVal);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final void putAttributeValue (
         int                              buf,
         int                              syntaxID,
         byte[]                           attributeValue)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.JDSPutAttributeValue (
                                                   threadGroup,
                                                   this.hdlContext,
                                                   buf,
                                                   syntaxID,
                                                   attributeValue);
      if (0 != ccode)
      {
         throw ( NSIExceptionBuilder.build(ccode));
      }

   } /* putAttributeValue () */


   public final int getSyntaxID(
      String      attrName)
   throws SessionException, java.rmi.RemoteException
   {
      int[] x= new int[1];
      int ccode = NetJNI.NWDSGetSyntaxID(
         threadGroup,
         this.hdlContext,
         attrName,
         x);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return x[0];
   }


 public final String replaceAttrNameAbbrev
 (
      String         inStr

)
   throws SessionException, java.rmi.RemoteException
   {
    StringBuffer   outStr = new StringBuffer();
      int ccode = NetJNI.NWDSReplaceAttrNameAbbrev(
         threadGroup,
         this.hdlContext,
         inStr,
         outStr);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return outStr.toString();
   }
/*
   public final void extSyncList (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle,
         int                  timeStamp,
         boolean              onlyContainers,
         NetListBuffer        subordinates)  //out
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSExtSyncList(
         threadGroup,
         this.hdlContext,
         objectName,
         className,
         subordinateName,
         iterationHandle,
         timeStamp,
         onlyContainers,
         subordinates.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } // extSyncList ()

   public final void extSyncRead (
         String      objectName,
         int         infoType,
         boolean     allAttrs,
         int         attrNames,        //in, the request buffer
         NetIterationHandle  iterationHandle,   //in-out
         NetBuffer  objectInfo)         //out, the request buffer
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSExtSyncRead(
         threadGroup,
         this.hdlContext,
         objectName,
         infoType,
         allAttrs,
         attrNames,
         iterationHandle,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } // extSyncRead ()

   public final void extSyncSearch (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    //a filter buffer.
//         NDSTimeStamp timeStamp,
         int         infoType,
         boolean     allAttrs,
         int         attrNames, //a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         NetBuffer   objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSExtSyncSearch(
         threadGroup,
         this.hdlContext,
         baseObjectName,
         scope,
         searchAliases,
         filter,    //a filter buffe
         infoType,
         allAttrs,
         attrNames, //a buffer with
         iterationHandle,
         countObjectsToSearch,
         countObjectsSearched,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } // extSyncSearch ()
*/

   /**
    *
    */
   public final ReadClassDefStruct readClassDef (
         int                     infoType,
         boolean                 allClasses,
         int                     classNames,
         NetIterationHandle      iterationHandle,
         NetReadClassDefBuffer   classDefs)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;

      ccode = NetJNI.NWDSReadClassDef (
                        threadGroup,
                        this.hdlContext,
                        infoType,
                        allClasses,
                        classNames,
                        iterationHandle,
                        classDefs.getBuffer ());

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }
      
      ReadClassDefStruct struct = new ReadClassDefStruct();
      struct.handle = iterationHandle;
      struct.buffer = classDefs;
      return struct;

   } /* readClassDef () */


   /**
    *
    */
   public final void defineAttr (
         String            attrName,
         NetAttributeInfo  attrDef)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSDefineAttr(
         threadGroup,
         this.hdlContext,
         attrName,
         attrDef);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* defineAttr () */

   /**
    *
    */
   public final void defineClass (
         String         className,
         NetClassInfo   classInfo,
         int            classItems)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSDefineClass(
         threadGroup,
         this.hdlContext,
         className,
         classInfo,
         classItems);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* defineClass () */


 public final void removeClassDef
 (
         /*in*/   String         className
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRemoveClassDef(
         threadGroup,
         this.hdlContext,
         className);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

/* unused
 public final void ListContainableClasses
 (
         /*in* /      int                  hdlContext,
         /*in* /      String               parentObject,
         /*in/out* /  NetIterationHandle   iterationHandle,
         /*out* /     NetBufferHandle      containableClasses
   )
*/

 public final void modifyClassDef
 (
         /*in*/   String         className,
         /*in*/   int            optionalAttrs
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSModifyClassDef(
         threadGroup,
         this.hdlContext,
         className,
         optionalAttrs);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public final NetIterationHandle readSyntaxes (
         int infoType,
         boolean allSyntaxes,
         int syntaxNames,
         NetIterationHandle iterationHandle,
         int syntaxDefs)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSReadSyntaxes(
         threadGroup,
         this.hdlContext,
         infoType,
         allSyntaxes,
         syntaxNames,
         iterationHandle,
         syntaxDefs);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return iterationHandle;
   } /* readSyntaxes () */


 public final void removeAttrDef
 (
         /*in*/   String         attrName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRemoveAttrDef(
         threadGroup,
         this.hdlContext,
         attrName);
      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void putSyntaxName
 (
         /*in*/   int            buf,
         /*in*/   String         syntaxName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutSyntaxName(
         threadGroup,
         this.hdlContext,
         buf,
         syntaxName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


 public final void putClassName
 (
         /*in*/   int            buf,
         /*in*/   String         itemName
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPutClassName(
         threadGroup,
         this.hdlContext,
         buf,
         itemName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   /**
    *
    */
   public NetSyntaxInfo readSyntaxDef
   (
      int syntaxID
   )
   throws SessionException, java.rmi.RemoteException
   {
      NetSyntaxInfo syntaxDef = new NetSyntaxInfo();
      int ccode = NetJNI.NWDSReadSyntaxDef(
         threadGroup,
         this.hdlContext,
         syntaxID,
         syntaxDef);
      if (ccode != 0)
         throw NSIExceptionBuilder.build(ccode);
      return syntaxDef;
   } /* readSyntaxDef () */


   public final void syncSchema
   (
         /*in*/   String         server,
         /*in*/   int            seconds
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSSyncSchema(
         threadGroup,
         this.hdlContext,
         server,
         seconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   // ******************** Partition methods ********************

   public final void abortPartitionOperation
   (
      /*in*/   String         partitionRoot
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSAbortPartitionOperation(
         threadGroup,
         this.hdlContext,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final NetIterationHandle addPartition (
         String server,
         String partitionRoot,
         NetIterationHandle iterationHandle,
         boolean more,
         int objectInfo)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSAddPartition(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot,
         iterationHandle,
         more,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return iterationHandle;
   } /* addPartition () */



   public final void addReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot,
      /*in*/      int            replicaType
   )
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSAddReplica(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot,
         replicaType);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   public final void changeReplicaType
   (
      /*in*/      String         replicaName,
      /*in*/      String         server,
      /*in*/      int            newReplicaType
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSChangeReplicaType(
         threadGroup,
         this.hdlContext,
         replicaName,
         server,
         newReplicaType);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final PartitionExtStruct getPartitionExtInfo (
         int infoPtr,
         int limit,
         int infoFlag)
      throws SessionException, java.rmi.RemoteException
   {
      PartitionExtStruct x = new PartitionExtStruct();
      int ccode = NetJNI.NWDSGetPartitionExtInfo(
         threadGroup,
         this.hdlContext,
         infoPtr,
         limit,
         infoFlag,
         x.length,
         x.data);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return x;
   } /* getPartitionExtInfo () */

   public final PartitionExtPtrStruct getPartitionExtInfoPtr
   (
      /*in*/      int            buf
)   /* this is different than the C API */
   throws SessionException, java.rmi.RemoteException
   {
      PartitionExtPtrStruct x = new PartitionExtPtrStruct();
      int ccode = NetJNI.NWDSGetPartitionExtInfoPtr(
         threadGroup,
         this.hdlContext,
         buf,
         x.infoPtr,
         x.infoPtrEnd);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return x;
   }


   public final StrInt getPartitionInfo
   (
      /*in*/      int            buf
)
   throws SessionException, java.rmi.RemoteException
   {
      StrInt x = new StrInt();
      int ccode = NetJNI.NWDSGetPartitionInfo(
         threadGroup,
         this.hdlContext,
         buf,
         x.strValue,
         x.intValue);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return x;
   }



   public final String getPartitionRoot
   (
      /*in*/   String         objectName
)
   throws SessionException, java.rmi.RemoteException
   {
      StringBuffer   partitionRoot = new StringBuffer();
      int ccode = NetJNI.NWDSGetPartitionRoot(
         threadGroup,
         this.hdlContext,
         objectName,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return partitionRoot.toString();
   }



   public final StrInt getServerName
   (
      /*in*/      int            buf
)
   throws SessionException, java.rmi.RemoteException
   {
      StrInt x = new StrInt();
      int ccode = NetJNI.NWDSGetServerName(
         threadGroup,
         this.hdlContext,
         buf,
         x.strValue,
         x.intValue);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);

      return x;
   }



   public final void joinPartitions
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSJoinPartitions(
         threadGroup,
         this.hdlContext,
         subordinatePartition,
         flags);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }


   /**
    *
    */
   public final NetIterationHandle listPartitions (
         NetIterationHandle iterationHandle,
         String server,
         int partitions)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSListPartitions(
         threadGroup,
         this.hdlContext,
         iterationHandle,
         server,
         partitions);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return iterationHandle;
   } /* listPartitions () */

   /**
    *
    */
   public final NetIterationHandle listPartitionsExtInfo (
         NetIterationHandle iterationHandle,
         String server,
         int DSPFlags,
         int partitions)
      throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSListPartitionsExtInfo(
         threadGroup,
         this.hdlContext,
         iterationHandle,
         server,
         DSPFlags,
         partitions);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return iterationHandle;
   } /* listPartitionsExtInfo () */



   public final void partitionReceiveAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPartitionReceiveAllUpdates(
         threadGroup,
         this.hdlContext,
         partitionRoot,
         serverName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void partitionSendAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSPartitionSendAllUpdates(
         threadGroup,
         this.hdlContext,
         partitionRoot,
         serverName);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void removePartition
   (
      /*in*/      String         partitionRoot
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRemovePartition(
         threadGroup,
         this.hdlContext,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void removeReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSRemoveReplica(
         threadGroup,
         this.hdlContext,
         server,
         partitionRoot);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void splitPartition
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSSplitPartition(
         threadGroup,
         this.hdlContext,
         subordinatePartition,
         flags);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void syncPartition
   (
      /*in*/      String         server,
      /*in*/      String         partition,
      /*in*/      int            seconds
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSSyncPartition(
         threadGroup,
         this.hdlContext,
         server,
         partition,
         seconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }



   public final void syncReplicaToServer
   (
      /*in*/      String         serverName,
      /*in*/      String         partitionRootName,
      /*in*/      String         destServerName,
      /*in*/      int            actionFlags,
      /*in*/      int            delaySeconds
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSSyncReplicaToServer(
         threadGroup,
         this.hdlContext,
         serverName,
         partitionRootName,
         destServerName,
         actionFlags,
         delaySeconds);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }

   public void reloadDS(String serverName)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSReloadDS(threadGroup, hdlContext, serverName);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }
   }

    // ******************** Nds server methods ********************
/*
   public final void getServerAddresses
   (
      IntegerBuffer  countNetAddresses,   // out
      int            netAddresses         // out
)
   throws SessionException, java.rmi.RemoteException
   {
      int ccode = NetJNI.NWDSGetServerAddresses(
         threadGroup,
         this.hdlContext,
         this.hdlConnection,
         countNetAddresses,
         netAddresses);

      if (0 != ccode)
         throw NSIExceptionBuilder.build(ccode);
   }
*/


   // ******************** Object Info methods ********************

   /**
    *    @deprecated    use readEntry() instead
    */
   public final NetMemory readObjectDSIInfo (
         String object)
      throws SessionException, java.rmi.RemoteException
   {
      NetMemory objectInfo = new NetMemory(0);  // NOTE: invalid size
      int ccode = NetJNI.NWDSReadObjectDSIInfo(
         threadGroup,
         this.hdlContext,
         object,
         objectInfo);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return objectInfo;
   } /* ReadObjectDSIInfo () */

   /**
    *    @deprecated    use readEntry() instead
    */
   public final NetMemory getDSIInfo (
         NetMemory   buf,
         int         infoFlag)
      throws SessionException, java.rmi.RemoteException
   {
      NetMemory   data = new NetMemory(0);  // NOTE: invalid size
      int ccode = NetJNI.NWDSGetDSIInfo(
         threadGroup,
         this.hdlContext,
         buf,
         infoFlag,
         data);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return data;
   } /* getDSIInfo () */

   /**
    *
    */
   public final NetEntryInfo readEntry (
         /*in*/   String                  object,
         /*in*/   int                     bufferSize)
   throws SessionException, java.rmi.RemoteException
   {
//         /*in*/   int                     sNetEntryInfo,
      int ccode;
      NetEntryInfo[] entry = new NetEntryInfo[1];

      ccode = NetJNI.JDSReadObjectEntry (
                                             threadGroup,
                                             this.hdlContext,
                                             BasicNetService.sNetEntryInfo,
                                             object,
                                             bufferSize,
                                             entry);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return (entry[0]);

   } /* readObjectEntry () */


   public final VersionStruct getNWNetVersion()
      throws SessionException, java.rmi.RemoteException
   {
      VersionStruct x = new VersionStruct();
      NetJNI.NWGetNWNetVersion(
         x.majorVersion,
         x.minorVersion,
         x.revisionLevel,
         x.betaReleaseLevel);
      return x;
   }

   /**
    *
    */
   public final int getFileServerUTCTime ()
      throws SessionException, java.rmi.RemoteException
   {
      int ccode;
      IntegerBuffer  time = new IntegerBuffer ();
      Integer connection = (Integer)Natives.getContextInfo(
            nativeContext,
            Natives.DCK_LAST_CONNECTION);
      int hdlConnection = connection.intValue();

      ccode = NetJNI.NWGetFileServerUTCTime (hdlConnection, time);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build(ccode);
      }

      return (time.intValue ());

   } /* getFileServerUTCTime () */


   // ******************** nwitr.h ********************

   /**
    *
    */
   public int itrCreateSearch (
         /*in*/   String   baseObjectName,
         /*in*/   int      scope,
         /*in*/   boolean  searchAliases,
         /*in*/   int      filter,      // a filter buffer
         /*in*/   int      timeFilter,
         /*in*/   int      infoType,
         /*in*/   boolean  allAttrs,
         /*in*/   int      attrNames,   // a buffer with the attribute names
         /*in*/   String   indexSelect,
         /*in*/   String   sortKey,
         /*in*/   int      scalability,
         /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]    iterator = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrCreateSearch (
                                       threadGroup,
                                       this.hdlContext,
                                       baseObjectName,
                                       scope,
                                       searchAliases,
                                       filter,
                                       timeFilter,
                                       infoType,
                                       allAttrs,
                                       attrNames,
                                       indexSelect,
                                       sortKey,
                                       scalability,
                                       timeout,
                                       iterator);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return iterator[0];
   } /* itrCreateSearch () */

   /**
    *
    */
   public int itrCreateList (
         /*in*/   String   baseObjectName,
         /*in*/   String   className,
         /*in*/   String   subordinateName,
         /*in*/   int      scalability,
         /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]    iterator = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrCreateList (
                                       threadGroup,
                                       this.hdlContext,
                                       baseObjectName,
                                       className,
                                       subordinateName,
                                       scalability,
                                       timeout,
                                       iterator);
      if (0 != ccode)
      {
            throw (NSIExceptionBuilder.build (ccode));
      }

      return iterator[0];
   } /* itrCreateList () */

   /**
    *
    */
   public void itrDestroy (
         /*in*/   int iterator)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrDestroy (iterator);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrDestroy () */

   /**
    *
    */
   public int itrClone (
         /*in*/   int      iterator)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]    newIterator = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrClone (iterator, newIterator);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return newIterator[0];
   } /* itrClone () */


   /**
    *
    */
   public boolean itrAtFirst (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException
   {
      return (NetJNI.NWDSItrAtFirst (iterator));
   }

   /**
    *
    */
   public boolean itrAtEOF (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException
   {
      return (NetJNI.NWDSItrAtEOF (iterator));
   }

   /**
    *
    */
   public TwoBooleans itrGetInfo (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException
   {
      TwoBooleans x = new TwoBooleans();
      int ccode;

      ccode = NetJNI.NWDSItrGetInfo (
                                       iterator,
                                       x.one,
                                       x.two);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return x;
   } /* itrGetInfo () */


   /**
    *
    */
   public int itrGetPosition (
         /*in*/   int      iterator,
         /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]    position = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrGetPosition (
         iterator,
         position,
         timeout);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return position[0];
   } /* itrGetPosition () */

   /**
    *
    */
   public void itrSetPosition (
         /*in*/   int   iterator,
         /*in*/   int   position,
         /*in*/   int   timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrSetPosition (iterator, position, timeout);

      if (ccode != 0)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

   } /* itrSetPosition () */

   /**
    *
    */
   public void itrSetPositionFromIterator (
         /*in*/   int   iterator,
         /*in*/   int   srcIterator,
         /*in*/   int   timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrSetPositionFromIterator (
                                                         iterator,
                                                         srcIterator,
                                                         timeout);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrSetPositionFromIterator () */

   /**
    *
    */
   public void itrTypeDown (
         /*in*/   int      iterator,
         /*in*/   String   attribute,
         /*in*/   String   value,
         /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrTypeDown (
                                          iterator,
                                          attribute,
                                          value,
                                          timeout);
      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

   } /* itrTypeDown () */

   /**
    *
    */
   public int itrSkip (
         /*in*/   int      iterator,
         /*in*/   int      numToSkip,
         /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]    numSkipped = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrSkip (iterator, numToSkip, timeout, numSkipped);

      if (0 != ccode)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return numSkipped[0];
   } /* itrSkip () */

   /**
    *
    */
   public NetIterationHandle itrGetNext (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetNext (
                                       iterator,
                                       numEntries,
                                       timeout,
                                       iterationHandle,
                                       data);
      if (0 != ccode)
      {
		if((iterationHandle.getValue()==NetIterationHandle.NO_MORE_ITERATIONS)&&(ccode==NetJNI.ERR_EOF_HIT))
		{
			// doing nothing; See defect000331963
		}
		else 
		{         
			throw NSIExceptionBuilder.build (ccode);
		}
	  }
      return iterationHandle;
   } /*  */

   /**
    *
    */
   public NetIterationHandle itrGetPrev (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode;

      ccode = NetJNI.NWDSItrGetPrev (
                                       iterator,
                                       numEntries,
                                       timeout,
                                       iterationHandle,
                                       data);
      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return iterationHandle;
   } /* itrGetPrev () */

   /**
    *
    */
   public NetIterationHandle itrGetCurrent (
      /*in*/      int                  iterator,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/      int                  data)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int ccode = NetJNI.NWDSItrGetCurrent (
         iterator,
         iterationHandle,
         data);

      if (0 != ccode)
      {
         throw (NSIExceptionBuilder.build (ccode));
      }

      return iterationHandle;
   } /* itrGetCurrent () */

   /**
    *
    */
   public int itrCount (
         /*in*/   int         iterator,
         /*in*/   int         timeout,
         /*in*/   int         maxCount,
         /*in*/   boolean     updatePosition)
      throws SessionException, java.rmi.RemoteException, NSIException
   {
      int[]       count = new int[1];
      int ccode;

      ccode = NetJNI.NWDSItrCount (
                                       iterator,
                                       timeout,
                                       maxCount,
                                       updatePosition,
                                       count);

      if (ccode != 0)
      {
         throw NSIExceptionBuilder.build (ccode);
      }

      return count[0];
   } /* itrCount () */

} /* BasicNetService */
