/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetServiceRemote.java $
  $Revision: 3 $
  $Modtime: 1/23/01 3:51p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.jncpv2r.net;

import java.rmi.*;

import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;

import com.novell.service.session.SessionException;

import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;
import java.io.Serializable;

/** @internal
 * Interface needed since NetService has in/out parameters
 */
public interface NetServiceRemote extends Remote
{
   public void setConfidence (
         int level)
      throws SessionException, java.rmi.RemoteException;

   public void setNameCacheDepth (
         /*in*/   int depth)
      throws SessionException, RemoteException;

   public void setTypelessNames (
         boolean flag)
   throws SessionException, java.rmi.RemoteException;


   public String canonicalizeName
   (
      String objectName
   )
   throws SessionException, java.rmi.RemoteException;

   public void addFilterToken
   (
      int cur,
      int tok,
      int val,
      int syntaxID
   )
   throws SessionException, java.rmi.RemoteException;

   public void addFilterToken
   (
      int cur,
      int tok,
      byte[] val,
      int syntaxID
   )
   throws SessionException, java.rmi.RemoteException;

   public void addObject
   (
      String objectName,
      NetIterationHandle iterationHandle,
      boolean more,
      int buf
   )
   throws SessionException, java.rmi.RemoteException;

   public int allocBuf (
         int size)
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public int allocFilter (
         int cur)
      throws SessionException, java.rmi.RemoteException;

/*
   public NetIterationHandle dsBackupObject
   (
      String objectName,
      NetIterationHandle iterationHandle,
      int objectInfo
   )
   throws SessionException, java.rmi.RemoteException;
*/

   public void beginClassItem
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException;

   public void compare
   (
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched
 	)
   throws SessionException, java.rmi.RemoteException;

   public void closeIteration
   (
         /*in*/   int            handle,
         /*in*/   int            operation
   )
   throws SessionException, java.rmi.RemoteException;

   public void freeBuf
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException;

   public int getAttrCount (
         int  buf)
      throws SessionException, java.rmi.RemoteException;

   public int getClassDefCount
   (
         /*in*/   int         buf
   )
   throws SessionException, java.rmi.RemoteException;

   public AttrDef getAttrDef
   (
         /*in*/   int              buf
   )
   throws SessionException, java.rmi.RemoteException;

   public ClassDef getClassDef
   (
         /*in*/   int               buf
   )
   throws SessionException, java.rmi.RemoteException;

   public int getClassItemCount
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException;

   public String getClassItem
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException;

   public int getObjectCount
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException;

   public ObjectName getObjectName
   (
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException;

   public int getSyntaxCount
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException;

   public SyntaxDef getSyntaxDef
   (
         /*in*/   int            buf
   )
   throws SessionException, java.rmi.RemoteException;

   public void initBuf
   (
         /*in*/   int operation,
         /*in*/   int buf
   )
   throws SessionException, java.rmi.RemoteException;


   /**
    *
    */
   public ListStruct list (
         String objectName,
         NetIterationHandle iterationHandle)
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public ListStruct listContainers (
         String objectName,
         NetIterationHandle iterationHandle)
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public ListStruct listByClassAndName (
        String               objectName,
        String               className,
        String               subordinateName,
        NetIterationHandle   iterationHandle)  //out
     throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   NetEntryInfo[] listEntries (
         /*in*/   String   objectName,
         /*in*/   int      bufferSize)
      throws SessionException, java.rmi.RemoteException;


   public void putChange
   (
         /*in*/   int            buf,
         /*in*/   int            changeType,
         /*in*/   String         attrName
   )
   throws SessionException, java.rmi.RemoteException;

   public void putClassItem
   (
         /*in*/   int         buf,
         /*in*/   String      itemName
   )
   throws SessionException, java.rmi.RemoteException;

   public void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal
   )
   throws SessionException, java.rmi.RemoteException;

   public void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur
   )
   throws SessionException, java.rmi.RemoteException;

   public ObjectInfo readObjectInfo
   (
         /*in*/   String         objectName
   )
   throws SessionException, java.rmi.RemoteException;

   public String mapIDToName
   (
         /*in*/   int            objectID
   )
   throws SessionException, java.rmi.RemoteException;

   public int mapNameToID
   (
         /*in*/   String         object
   )
   throws SessionException, java.rmi.RemoteException;

   public NetIterationHandle modifyObject
   (
        /*in*/       String               objectName,
        /*in/out*/   NetIterationHandle   iterationHandle,
        /*in*/       boolean              more,
        /*in*/       int                  changes
   )
   throws SessionException, java.rmi.RemoteException;

   public void modifyDN
   (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN
   )
   throws SessionException, java.rmi.RemoteException;

   public void modifyRDN
   (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN
   )
   throws SessionException, java.rmi.RemoteException;

   public void moveObject
   (
      String     objectName,
      String     destParentDN,
      String     destRDN
   )
   throws SessionException, java.rmi.RemoteException;

   public int openStream
   (
      String      objectName,
      String      attrName,
      int         flags
   )
   throws SessionException, java.rmi.RemoteException;

   public NetIterationHandle read
   (
      String               object,
      int                  infoType,
      boolean              allAttrs,
      int                  attrNames,
      NetIterationHandle     iterationHandle,
      int                  objectInfo
   )
   throws SessionException, java.rmi.RemoteException;


   /**
    *
    */
   public NetAttrRecord[] readAttributes
   (
         /*in*/   String   objectName,
         /*in*/   int      infoType,
         /*in*/   int      attrNames,
         /*in*/   int      bufferSize)
      throws SessionException, java.rmi.RemoteException;


   /**
    *
    */
   public ReadAttrDefStruct readAttrDef (
         /*in*/      int                     infoType,
         /*in*/      boolean                 allAttrs,
         /*in*/      int                     attrNames,
         /*in/out*/  NetIterationHandle      iterationHandle,
         /*out*/     NetReadAttrDefBuffer    attrDefs)
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public String getServerDN ()
      throws SessionException, java.rmi.RemoteException;


   public void removeObject
   (
      String     object
   )
   throws SessionException, java.rmi.RemoteException;

   public ResolveNameStruct resolveName
   (
         /*in*/   String      objectName
   )
   throws SessionException, java.rmi.RemoteException;

/*
   public void restoreObject
   (
      String      objectName,
      NetIterationHandle    iterationHandle,
      boolean     more,
      int         size,
      int         objectInfo
   )
   throws SessionException, java.rmi.RemoteException;
*/

   public SearchInfo search
   (
      String      baseObjectName,
      int         scope,
      boolean     searchAliases,
      int         filter,    // a filter buffer.
      int         infoType,
      boolean     allAttrs,
      int         attrNames, // a buffer with the session attribute names.
      NetIterationHandle  iterationHandle,
      int         countObjectsToSearch,
      int         objectInfo
   )
   throws SessionException, java.rmi.RemoteException;

   public ResolveNameStruct auditGetObjectID
   (
      String         objectName
   )
   throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public int getEffectiveRights (
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName)
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public NetIterationHandle listAttrsEffectiveRights (
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo)
      throws SessionException, java.rmi.RemoteException;

   public int computeAttrValSize
   (
      /*in*/   int         buf,
      /*in*/   int        syntaxID

)
   throws SessionException, java.rmi.RemoteException;

   public String abbreviateName
   (
         /*in*/   String         inName
   )
   throws SessionException, java.rmi.RemoteException;

   public String removeAllTypes
   (
         /*in*/   String         name
   )
   throws SessionException, java.rmi.RemoteException;


   public boolean cIStringsMatch
   (
         /*in*/   String      string1,
         /*in*/   String      string2
   )
   throws SessionException, java.rmi.RemoteException;

   public AttrName getAttrName(
      /*in*/   int         buf)
   throws SessionException, java.rmi.RemoteException;

 public NetMemory getAttrVal
 (
      int         buf,
      int         syntaxID
   )
   throws SessionException, java.rmi.RemoteException;

 public byte[] getAttributeValue (
       int         buf,
       int         syntaxID)
 throws SessionException, java.rmi.RemoteException;

 public void putAttrName
 (
      int         buf,
      String      attrName

)
   throws SessionException, java.rmi.RemoteException;

 public void putAttrVal
 (
      int         buf,
      int         syntaxID,
      int         attrVal

)
   throws SessionException, java.rmi.RemoteException;

 public void putAttributeValue (
       int                              buf,
       int                              syntaxID,
       byte[]                           attributeValue)
 throws SessionException, java.rmi.RemoteException;

 public int getSyntaxID
 (
      String      attrName

)
   throws SessionException, java.rmi.RemoteException;

 public String replaceAttrNameAbbrev
 (
      String         inStr

)
   throws SessionException, java.rmi.RemoteException;

/*
 public void extSyncList
 (
      String               objectName,
      String               className,
      String               subordinateName,
      NetIterationHandle   iterationHandle,
      int                  timeStamp,
      boolean              onlyContainers,
      NetListBuffer        subordinates  //out

)
   throws SessionException, java.rmi.RemoteException;

 public void extSyncRead
 (
      String      objectName,
      int         infoType,
      boolean     allAttrs,
      int         attrNames,        //in, the request buffer
      NetIterationHandle  iterationHandle,   //in-out
      NetBuffer  objectInfo         //out, the request buffer

)
   throws SessionException, java.rmi.RemoteException;

 public void extSyncSearch
 (
      String      baseObjectName,
      int         scope,
      boolean     searchAliases,
      int         filter,    //a filter buffer.
//    NDSTimeStamp timeStamp,
      int         infoType,
      boolean     allAttrs,
      int         attrNames, //a buffer with the session attribute names.
      NetIterationHandle  iterationHandle,
      int         countObjectsToSearch,
      NWInteger   countObjectsSearched,
      NetBuffer   objectInfo
)
   throws SessionException, java.rmi.RemoteException;
*/

   /**
    *
    */
   public ReadClassDefStruct readClassDef (
         /*in*/      int                     infoType,
         /*in*/      boolean                 allClasses,
         /*in*/      int                     classNames,
         /*in/out*/  NetIterationHandle      iterationHandle,
         /*out*/     NetReadClassDefBuffer   classDefs)
      throws SessionException, java.rmi.RemoteException;


 public void defineAttr
 (
         /*in*/   String            attrName,
         /*in*/   NetAttributeInfo  attrDef
   )
   throws SessionException, java.rmi.RemoteException;

 public void defineClass
 (
         /*in*/   String         className,
         /*in*/   NetClassInfo   classInfo,
         /*in*/   int            classItems
   )
   throws SessionException, java.rmi.RemoteException;

 public void removeClassDef
 (
         /*in*/   String         className
   )
   throws SessionException, java.rmi.RemoteException;

 public void modifyClassDef
 (
         /*in*/   String         className,
         /*in*/   int            optionalAttrs
   )
   throws SessionException, java.rmi.RemoteException;

 public NetIterationHandle readSyntaxes
 (
         /*in*/      int                  infoType,
         /*in*/      boolean              allSyntaxes,
         /*in*/      int                  syntaxNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  syntaxDefs
   )
   throws SessionException, java.rmi.RemoteException;

 public void removeAttrDef
 (
         /*in*/   String         attrName
   )
   throws SessionException, java.rmi.RemoteException;

 public void putSyntaxName
 (
         /*in*/   int            buf,
         /*in*/   String         syntaxName
   )
   throws SessionException, java.rmi.RemoteException;

 public void putClassName
 (
         /*in*/   int            buf,
         /*in*/   String         itemName
   )
   throws SessionException, java.rmi.RemoteException;

   public NetSyntaxInfo readSyntaxDef
   (
      /*in*/   int   syntaxID
   )
   throws SessionException, java.rmi.RemoteException;

   public void syncSchema
   (
         /*in*/   String         server,
         /*in*/   int            seconds
   )
   throws SessionException, java.rmi.RemoteException;

   // ******************** Partition methods ********************

   public void abortPartitionOperation
   (
      /*in*/   String         partitionRoot
   )
   throws SessionException, java.rmi.RemoteException;

   public NetIterationHandle addPartition
   (
      /*in*/      String               server,
      /*in*/      String               partitionRoot,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      boolean              more,
      /*in*/      int                  objectInfo
)
   throws SessionException, java.rmi.RemoteException;

   public void addReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot,
      /*in*/      int            replicaType
   )
   throws SessionException, java.rmi.RemoteException;

   public void changeReplicaType
   (
      /*in*/      String         replicaName,
      /*in*/      String         server,
      /*in*/      int            newReplicaType
)
   throws SessionException, java.rmi.RemoteException;

   public PartitionExtStruct getPartitionExtInfo
   (
      /*in*/      int                 infoPtr,
      /*in*/      int                 limit,
      /*in*/      int                 infoFlag
)    /* this is different than the C API */
   throws SessionException, java.rmi.RemoteException;

   public PartitionExtPtrStruct getPartitionExtInfoPtr
   (
      /*in*/      int            buf
)   /* this is different than the C API */
   throws SessionException, java.rmi.RemoteException;

   public StrInt getPartitionInfo
   (
      /*in*/      int            buf
)
   throws SessionException, java.rmi.RemoteException;

   public String getPartitionRoot
   (
      /*in*/   String         objectName
)
   throws SessionException, java.rmi.RemoteException;

   public StrInt getServerName
   (
      /*in*/      int            buf
)
   throws SessionException, java.rmi.RemoteException;

   public void joinPartitions
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException, java.rmi.RemoteException;

   public NetIterationHandle listPartitions
   (
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      String               server,
      /*int*/      int                  partitions
)
   throws SessionException, java.rmi.RemoteException;

   public NetIterationHandle listPartitionsExtInfo
   (
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*in*/      String               server,
      /*in*/      int                  DSPFlags,
      /*in*/      int                  partitions
)
   throws SessionException, java.rmi.RemoteException;

   public void partitionReceiveAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException, java.rmi.RemoteException;

   public void partitionSendAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException, java.rmi.RemoteException;

   public void removePartition
   (
      /*in*/      String         partitionRoot
)
   throws SessionException, java.rmi.RemoteException;

   public void removeReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot
)
   throws SessionException, java.rmi.RemoteException;

   public void splitPartition
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException, java.rmi.RemoteException;

   public void syncPartition
   (
      /*in*/      String         server,
      /*in*/      String         partition,
      /*in*/      int            seconds
)
   throws SessionException, java.rmi.RemoteException;

   public void syncReplicaToServer
   (
      /*in*/      String         serverName,
      /*in*/      String         partitionRootName,
      /*in*/      String         destServerName,
      /*in*/      int            actionFlags,
      /*in*/      int            delaySeconds
)
   throws SessionException, java.rmi.RemoteException;

   public void reloadDS (
         /*in*/      String serverName)
      throws SessionException, java.rmi.RemoteException;

    // ******************** Nds server methods ********************
/*
   public void getServerAddresses
   (
      IntegerBuffer  countNetAddresses,   // out
      int            netAddresses         // out
)
   throws SessionException, java.rmi.RemoteException;
*/

   // ******************** Object Info methods ********************

   /**
    *
    */
   public NetMemory readObjectDSIInfo (
         String      object)
      throws SessionException, java.rmi.RemoteException;

   public NetMemory getDSIInfo
   (
      /*in*/   NetMemory   buf,
      /*in*/   int         infoFlag
)
   throws SessionException, java.rmi.RemoteException;

   public NetEntryInfo readEntry (
         /*in*/   String                  object,
         /*in*/   int                     bufferSize)
   throws SessionException, java.rmi.RemoteException;

   public VersionStruct getNWNetVersion()
      throws SessionException, java.rmi.RemoteException;

   /**
    *
    */
   public int getFileServerUTCTime ()
      throws SessionException, java.rmi.RemoteException;


   // ******************** SKADS methods ********************

   public int itrCreateSearch (
		/*in*/	String	baseObjectName,
		/*in*/	int		scope,
		/*in*/	boolean	searchAliases,
		/*in*/	int		filter,		// a filter buffer
		/*in*/	int		timeFilter,	// a time filter
		/*in*/	int		infoType,
		/*in*/	boolean	allAttrs,
		/*in*/	int		attrNames,	// a buffer with the attribute names
		/*in*/	String	indexSelect,
		/*in*/	String	sortKey,
		/*in*/	int		scalability,
		/*in*/	int		timeout)
		throws SessionException, java.rmi.RemoteException;

   public int itrCreateList (
      /*in*/   String   baseObjectName,
      /*in*/   String   className,
      /*in*/   String   subordinateName,
      /*in*/   int      scalability,
      /*in*/   int      timeout)
      throws SessionException, java.rmi.RemoteException;

   public void itrDestroy (
		/*in*/	int	iterator)
		throws SessionException, java.rmi.RemoteException;

	public int itrClone (
		/*in*/	int	iterator)
		throws SessionException, java.rmi.RemoteException;


   public boolean itrAtFirst (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException;

   public boolean itrAtEOF (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException;

   public TwoBooleans itrGetInfo (
         /*in*/   int   iterator)
      throws SessionException, java.rmi.RemoteException;


	public int itrGetPosition (
		/*in*/	int	iterator,
		/*in*/	int	timeout)
		throws SessionException, java.rmi.RemoteException;

	public void itrSetPosition (
		/*in*/	int	iterator,
		/*in*/	int	position,
		/*in*/	int	timeout)
		throws SessionException, java.rmi.RemoteException;
	
	public void itrSetPositionFromIterator (
		/*in*/	int	iterator,
		/*in*/	int	srcIterator,
		/*in*/	int	timeout)
		throws SessionException, java.rmi.RemoteException;

	public void itrTypeDown (
		/*in*/	int		iterator,
		/*in*/	String	attribute,
		/*in*/	String	value,
		/*in*/	int	timeout)
		throws SessionException, java.rmi.RemoteException;

	public int itrSkip (
		/*in*/	int  	iterator,
		/*in*/	int  	numToSkip,
		/*in*/	int  	timeout)
		throws SessionException, java.rmi.RemoteException;

	public NetIterationHandle itrGetNext (
		/*in*/		int						iterator,
		/*in*/		int						numEntries,
		/*in*/		int						timeout,
      /*in/out*/  NetIterationHandle	iterationHandle,
		/*out*/		int						data)
		throws SessionException, java.rmi.RemoteException;

	public NetIterationHandle itrGetPrev (
		/*in*/		int						iterator,
		/*in*/		int						numEntries,
		/*in*/		int						timeout,
      /*in/out*/  NetIterationHandle	iterationHandle,
		/*out*/		int						data)
		throws SessionException, java.rmi.RemoteException;

	public NetIterationHandle itrGetCurrent (
		/*in*/		int						iterator,
      /*in/out*/  NetIterationHandle	iterationHandle,
		/*out*/		int						data)
		throws SessionException, java.rmi.RemoteException;

	public int itrCount (
		/*in*/	int		iterator,
		/*in*/	int		timeout,
		/*in*/	int		maxCount,
		/*in*/	boolean	updatePosition)
		throws SessionException, java.rmi.RemoteException;

   public class AttrDef implements Serializable
   {
      public StringBuffer attrName;
      public NetAttributeInfo attrInfo;

      public AttrDef()
      {
         attrName = new StringBuffer();
         attrInfo = new NetAttributeInfo();
      }
   }

   public class ReadAttrDefStruct implements Serializable
   {
      NetIterationHandle handle;
      NetReadAttrDefBuffer buffer;
   }
   
   public class ReadClassDefStruct implements Serializable
   {
      NetIterationHandle handle;
      NetReadClassDefBuffer buffer;
   }
   
   public class ClassDef implements Serializable
   {
      public StringBuffer className;
      public NetClassInfo classInfo;

      public ClassDef()
      {
         className = new StringBuffer();
         classInfo = new NetClassInfo();
      }
   }

   public class ObjectName implements Serializable
   {
      StringBuffer objectName;
      NWInteger attrCount;
      NetObjectInfo objectInfo;

      public ObjectName()
      {
         objectName = new StringBuffer();
         attrCount = new NWInteger();
         objectInfo = new NetObjectInfo();
      }
   }

   public class SyntaxDef implements Serializable
   {
      StringBuffer   syntaxName;
      NetSyntaxInfo  syntaxDef;

      public SyntaxDef()
      {
         syntaxName = new StringBuffer();
         syntaxDef = new NetSyntaxInfo();
      }
   }

   public class ListStruct implements Serializable
   {
      NetIterationHandle iterationHandle;
      NetListBuffer subordinates;

      public ListStruct(NetIterationHandle x)
      {
         iterationHandle = x;
         subordinates = new NetListBuffer();
      }
   }

   public class ObjectInfo implements Serializable
   {
      StringBuffer   distinguishedName;
      NetObjectInfo  objectInfo;

      public ObjectInfo()
      {
         distinguishedName = new StringBuffer();
         objectInfo = new NetObjectInfo();
      }
   }

   public class SearchInfo implements Serializable
   {
      NetIterationHandle   iterationHandle;
      NWInteger            countObjectsSearched;

      public SearchInfo(NetIterationHandle x)
      {
         iterationHandle = x;
         countObjectsSearched = new NWInteger();
      }
   }


   public class AttrName implements Serializable
   {
      StringBuffer attrName;
      NWInteger   attrValCount;
      NWInteger   syntaxID;

      public AttrName()
      {
         attrName = new StringBuffer();
         attrValCount = new NWInteger();
         syntaxID = new NWInteger();
      }
   }

   public class ResolveNameStruct implements Serializable
   {
      int   conn;
      int objectID;
   }

   public class PartitionExtStruct implements Serializable
   {
      IntegerBuffer length;
      NetPartitionExtInfo data;

      public PartitionExtStruct()
      {
         length = new IntegerBuffer();
         data = new NetPartitionExtInfo();
      }
   }

   public class PartitionExtPtrStruct implements Serializable
   {
      IntegerBuffer  infoPtr;
      IntegerBuffer  infoPtrEnd;

      public PartitionExtPtrStruct()
      {
         infoPtr = new IntegerBuffer  ();
         infoPtrEnd = new IntegerBuffer  ();
      }
   }

   public class StrInt implements Serializable
   {
      StringBuffer   strValue;
      IntegerBuffer  intValue;

      public StrInt()
      {
         strValue = new StringBuffer();
         intValue = new IntegerBuffer();
      }
   }

   public class VersionStruct implements Serializable
   {
      IntegerBuffer   majorVersion;
      IntegerBuffer   minorVersion;
      IntegerBuffer   revisionLevel;
      IntegerBuffer   betaReleaseLevel;

      public VersionStruct()
      {
         majorVersion = new IntegerBuffer();
         minorVersion = new IntegerBuffer();
         revisionLevel = new IntegerBuffer();
         betaReleaseLevel = new IntegerBuffer();
      }
   }

   public class TwoBooleans implements Serializable
   {
      boolean[] one;
      boolean[] two;

      public TwoBooleans()
      {
         one = new boolean[1];
         two = new boolean[1];
      }
   }

/*
   public class x implements Serializable
   {
      public x()
      {
      }
   }
*/
} /* NetServiceRemote */

