/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/jncpv2r/net/NetServiceWrapper.java $
  $Revision: 1 $
  $Modtime: 8/24/01 10:24a $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.jncpv2r.net;

import java.rmi.RemoteException;
import com.novell.java.lang.IntegerBuffer;
import com.novell.java.lang.BooleanBuffer;
import com.novell.service.toolkit.jcl.NWInteger;
import com.novell.service.toolkit.jcl.NWBoolean;

import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.jncp.NSIException;
import com.novell.service.session.SessionException;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.NDSContext;
import com.novell.service.session.xplat.NDSContextInfo;
import com.novell.service.jncpv2r.net.NetServiceRemote.*;

/** @internal
 * Object returned by Session.getService() that wraps all NWNET
 * native services (via NetJNI).
 */
public class NetServiceWrapper implements NetService, java.io.Serializable
{
   NetServiceRemote remote;

   public NetServiceWrapper(NetServiceRemote rem)
   throws SessionException, RemoteException
   {
      remote = rem;
   }


   // ******************** Context Interface ********************

   /**
    *
    */
   public void setConfidence (
         int level)
      throws SessionException
   {
      try
      {
         remote.setConfidence(level);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public void setNameCacheDepth (
         int depth)
      throws SessionException
   {
      try
      {
         remote.setNameCacheDepth(depth);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public void setTypelessNames (
         boolean flag)
      throws SessionException
   {
      try
      {
         remote.setTypelessNames(flag);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* setTypelessNames () */


   public final String canonicalizeName
   (
      String objectName
   )
   throws SessionException
   {
      try
      {
         return remote.canonicalizeName(objectName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   /**
    *
    */
   public final String getServerDN ()
      throws SessionException
   {
      try
      {
         return remote.getServerDN();
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getServerDN () */


   public final void addFilterToken
   (
      int cur,
      int tok,
      int val,
      int syntaxID
   )
   throws SessionException
   {
      try
      {
         remote.addFilterToken(
            cur,
            tok,
            val,
            syntaxID);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void addFilterToken (
         /*in*/   int                  cur,
         /*in*/   int                  tok,
         /*in*/   byte[]               val,
         /*in*/   int                  syntaxID)
      throws SessionException
   {
      try
      {
         remote.addFilterToken(
            cur,
            tok,
            val,
            syntaxID);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   /**
    *
    */
   public final void addObject (
      String objectName,
      NetIterationHandle iterationHandle,
      boolean more,
      int buf)
   throws SessionException
   {
      try
      {
         remote.addObject(
            objectName,
            iterationHandle,
            more,
            buf);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* addObject () */

   /**
    *
    */
   public final int allocBuf (
         int size)
      throws SessionException
   {
      try
      {
         return remote.allocBuf(size);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* allocBuf () */

   /**
    *
    */
   public final NWInteger allocFilter (
         NWInteger cur)
      throws SessionException
   {
      try
      {
         cur.setValue(
            remote.allocFilter(cur.getValue()));
         return cur;
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void dsBackupObject (
         String objectName,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         iterationHandle = remote.dsBackupObject(
            objectName,
            iterationHandle.getValue(),
            objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   } /* dsBackupObject () */

   public final void beginClassItem
   (
         /*in*/   int buf
   )
   throws SessionException
   {
      try
      {
         remote.beginClassItem(buf);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public final void compare
   (
         /*in*/   String         object,
         /*in*/   int            buf,
         /*in*/   BooleanBuffer  matched
    )
   throws SessionException
   {
      try
      {
         remote.compare(
            object,
            buf,
            matched);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void closeIteration (
         int iterationHandle,
         int operation)
      throws SessionException
   {
      try
      {
         remote.closeIteration(
            iterationHandle,
            operation);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* closeIteration () */

   public final void freeBuf
   (
         /*in*/   int buf
   )
   throws SessionException
   {
      try
      {
         remote.freeBuf(buf);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final int getAttrCount (
         int buf)
      throws SessionException
   {
      try
      {
         return remote.getAttrCount(buf);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getAttrCount () */

   public final void getClassDefCount
   (
         /*in*/   int         buf,
         /*out*/  IntegerBuffer   classDefCount
   )
   throws SessionException
   {
      try
      {
         classDefCount.setValue(
            remote.getClassDefCount(
               buf));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void getAttrDef (
         int buf,
         StringBuffer attrName,
         NetAttributeInfo attrInfo)
      throws SessionException
   {
      try
      {
         AttrDef x = remote.getAttrDef(
            buf);
         attrName.setLength(0);
         attrName.append(x.attrName.toString());
         attrInfo.copy(x.attrInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getAttrDef () */

   /**
    *
    */
   public final void getClassDef (
         int buf,
         StringBuffer className,
         NetClassInfo classInfo)
      throws SessionException
   {
      try
      {
         ClassDef x = remote.getClassDef(
            buf);
         className.setLength(0);
         className.append(x.className.toString());
         classInfo.copy(x.classInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getClassDef () */

   public final void getClassItemCount
   (
         /*in*/   int            buf,
         /*out*/  IntegerBuffer  itemCount
   )
   throws SessionException
   {
      try
      {
         itemCount.setValue(
            remote.getClassItemCount(
               buf));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void getClassItem
   (
         /*in*/   int            buf,
         /*out*/  StringBuffer   itemName
   )
   throws SessionException
   {
      try
      {
         String x = remote.getClassItem(
            buf);
         itemName.setLength(0);
         itemName.append(x.toString());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void getObjectCount
   (
         /*in*/   int buf,
         /*out*/  NWInteger objectCount
   )
   throws SessionException
   {
      try
      {
         objectCount.setValue(
            remote.getObjectCount(
            buf));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void getObjectName (
         int buf,
         StringBuffer objectName,
         NWInteger attrCount,
         NetObjectInfo objectInfo)
      throws SessionException
   {
      try
      {
         ObjectName x = remote.getObjectName(
            buf);
         objectName.setLength(0);
         objectName.append(
            x.objectName.toString());
         attrCount.setValue(
            x.attrCount.getValue());
         objectInfo.copy(x.objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getObjectName () */


   public final void getSyntaxCount
   (
         /*in*/   int            buf,
         /*out*/  NWInteger      syntaxCount
   )
   throws SessionException
   {
      try
      {
         syntaxCount.setValue(
            remote.getSyntaxCount(
               buf));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void getSyntaxDef (
         int            buf,
         StringBuffer   syntaxName,
         NetSyntaxInfo  syntaxDef)
      throws SessionException
   {
      try
      {
         SyntaxDef x = remote.getSyntaxDef(
            buf);
         syntaxName.setLength(0);
         syntaxName.append(
            x.syntaxName.toString());
         syntaxDef.copy(x.syntaxDef);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getSyntaxDef () */

   /**
    *
    */
   public final void initBuf (
         int operation,
         int buf)
      throws SessionException
   {
      try
      {
         remote.initBuf(
            operation,
            buf);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* initBuf () */

   /**
    *
    */
   public final void list (
         String objectName,
         NetIterationHandle iterationHandle,
         NetListBuffer subordinates)
      throws SessionException
   {
      try
      {
         ListStruct x = remote.list(
            objectName,
            iterationHandle);
         iterationHandle.setValue(
            x.iterationHandle.getValue());
         subordinates.copy(x.subordinates);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* list () */

   /**
    *
    */
   public final void listContainers (
         String objectName,
         NetIterationHandle iterationHandle,
         NetListBuffer subordinates)
      throws SessionException
   {
      try
      {
         ListStruct x = remote.listContainers(
            objectName,
            iterationHandle);
         iterationHandle.setValue(
            x.iterationHandle.getValue());
         subordinates.copy(x.subordinates);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* listByClassAndName () */

   /**
    *
    */
   public final void listByClassAndName (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle,
         NetListBuffer        subordinates)  //out
      throws SessionException
   {
      try
      {
         ListStruct x = remote.listByClassAndName(
            objectName,
            className,
            subordinateName,
            iterationHandle);
         iterationHandle.setValue(
            x.iterationHandle.getValue());
         subordinates.copy(x.subordinates);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* listByClassAndName () */


   /**
    *
    */
   public final NetEntryInfo[] listEntries (
         String objectName,
         int bufferSize)
      throws SessionException
   {
      try
      {
         return remote.listEntries(
            objectName,
            bufferSize);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* listEntries () */


   public final void putChange
   (
         /*in*/   int            buf,
         /*in*/   int            changeType,
         /*in*/   String         attrName
   )
   throws SessionException
   {
      try
      {
         remote.putChange(
            buf,
            changeType,
            attrName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void putClassItem
   (
         /*in*/   int         buf,
         /*in*/   String      itemName
   )
   throws SessionException
   {
      try
      {
         remote.putClassItem(
            buf,
            itemName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public final void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur
   )
   throws SessionException
   {
      try
      {
         remote.putFilter(buf, cur);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public final void putFilter
   (
         /*in*/   int buf,
         /*in*/   int cur, // filter cursor
         /*in*/   int freeVal
   )
   throws SessionException
   {
      try
      {
         remote.putFilter(
            buf,
            cur,
            freeVal);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void readObjectInfo (
         String         objectName,
         StringBuffer   distinguishedName,   // optional
         NetObjectInfo  objectInfo)         // optional
      throws SessionException
   {
      try
      {
         ObjectInfo x = remote.readObjectInfo(
            objectName);
         distinguishedName.setLength(0);
         distinguishedName.append(x.distinguishedName.toString());
         objectInfo.copy(x.objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readObjectInfo () */

   public final void mapIDToName
   (
         /*in*/   int            objectID,
         /*out*/  StringBuffer   object
   )
   throws SessionException
   {
      try
      {
         object.setLength(0);
         object.append(
            remote.mapIDToName(
               objectID));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void mapNameToID
   (
         /*in*/   String         object,
         /*out*/  IntegerBuffer  objectID
   )
   throws SessionException
   {
      try
      {
         objectID.setValue(
            remote.mapNameToID(
               object));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void modifyObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int changes)
      throws SessionException
   {
      try
      {
         NetIterationHandle x =
            remote.modifyObject(
               objectName,
               iterationHandle,
               more,
               changes);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* modifyObject () */


 public final void modifyDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException
   {
    try
    {
       remote.modifyDN(
          objectName,
          newDN,
          deleteOldRDN);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void modifyRDN
 (
      String     objectName,
      String     newDN,
      boolean    deleteOldRDN

)
   throws SessionException
   {
    try
    {
       remote.modifyRDN(
          objectName,
          newDN,
          deleteOldRDN);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void moveObject
 (
      String     objectName,
      String     destParentDN,
      String     destRDN

)
   throws SessionException
   {
    try
    {
       remote.moveObject(
          objectName,
          destParentDN,
          destRDN);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void openStream
 (
      String      objectName,
      String      attrName,
      int         flags,
      NWInteger   fileHandle
)
   throws SessionException
   {
    try
    {
       fileHandle.setValue(
          remote.openStream(
             objectName,
             attrName,
             flags));
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   /**
    *
    */
   public final void read (
         String object,
         int infoType,
         boolean allAttrs,
         int attrNames,
         NetIterationHandle iterationHandle,
         int objectInfo)
      throws SessionException
   {
      try
      {
         NetIterationHandle x =
            remote.read(
               object,
               infoType,
               allAttrs,
               attrNames,
               iterationHandle,
               objectInfo);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* read () */


   /**
    *
    */
   public NetAttrRecord[] readAttributes (
         /*in*/   String   objectName,
         /*in*/   int      infoType,
         /*in*/   int      attrNames,
         /*in*/   int      bufferSize)
      throws SessionException
   {
      try
      {
         return remote.readAttributes(
            objectName,
            infoType,
            attrNames,
            bufferSize);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readAttributes () */


   /**
    *
    */
   public final void readAttrDef (
         int                     infoType,
         boolean                 allAttrs,
         int                     attrNames,
         NetIterationHandle      iterationHandle,
         NetReadAttrDefBuffer    attrDefs)
      throws SessionException
   {
      try
      {
         ReadAttrDefStruct st = remote.readAttrDef(infoType, allAttrs,
            attrNames, iterationHandle, attrDefs);
         iterationHandle.setValue(st.handle.getValue());
         attrDefs.setBuffer(st.buffer.getBuffer());
         attrDefs.setType(st.buffer.getType());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readAttrDef () */


 public final void removeObject
 (
      String     object

)
   throws SessionException
   {
    try
    {
       remote.removeObject(
          object);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   public final void resolveName
   (
      String objectName,
      NWInteger conn,
      NWInteger objectID
   )
   throws SessionException
   {
      try
      {
         ResolveNameStruct x = remote.resolveName(objectName);
         conn.setValue(x.conn);
         objectID.setValue(x.objectID);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void restoreObject (
         String objectName,
         NetIterationHandle iterationHandle,
         boolean more,
         int size,
         int objectInfo)
      throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         remote.restoreObject(
            objectName,
            iterationHandle,
            more,
            size,
            objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   } /* restoreObject () */

   /**
    *
    */
   public final void search (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    // a filter buffer.
         int         infoType,
         boolean     allAttrs,
         int         attrNames, // a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         int         objectInfo) // buffer to receive objects
      throws SessionException
   {
      try
      {
         SearchInfo x = remote.search(
            baseObjectName,
            scope,
            searchAliases,
            filter,    // a filter buf
            infoType,
            allAttrs,
            attrNames, // a buffer wit
            iterationHandle,
            countObjectsToSearch,
            objectInfo);
         iterationHandle.setValue(
            x.iterationHandle.getValue());
         countObjectsSearched.setValue(
            x.countObjectsSearched.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* search () */



 public final void auditGetObjectID
 (
      String         objectName,
      NWInteger      conn,
      NWInteger      objectID

)
   throws SessionException
   {
    try
    {
       ResolveNameStruct x = remote.auditGetObjectID(objectName);
       conn.setValue(x.conn);
       objectID.setValue(x.objectID);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   /**
    *
    */
   public final void getEffectiveRights (
         /*in*/   String      subjectName,
         /*in*/   String      objectName,
         /*in*/   String      attrName,
         /*out*/  NWInteger   privileges)
      throws SessionException
   {
      try
      {
         privileges.setValue(
            remote.getEffectiveRights(
               subjectName,
               objectName,
               attrName));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getEffectiveRights () */


   /**
    *
    */
   public void listAttrsEffectiveRights (
         /*in*/      String               objectName,
         /*in*/      String               subjectName,
         /*in*/      boolean              allAttrs,
         /*in*/      int                  attrNames,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  privilegeInfo)
      throws SessionException
   {
      try
      {
         NetIterationHandle x =
            remote.listAttrsEffectiveRights(
               objectName,
               subjectName,
               allAttrs,
               attrNames,
               iterationHandle,
               privilegeInfo);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /*  */

   /**
    *
    */
   public final void computeAttrValSize (
         int buf,
         int syntaxID,
         NWInteger attrValSize)
      throws SessionException
   {
      try
      {
         attrValSize.setValue(
            remote.computeAttrValSize(
               buf,
               syntaxID));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* computeAttrValSize () */


   public final void abbreviateName
   (
         /*in*/   String         inName,
         /*out*/  StringBuffer   abbreviatedName
   )
   throws SessionException
   {
      try
      {
         abbreviatedName.setLength(0);
         abbreviatedName.append(
            remote.abbreviateName(
               inName));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final String removeAllTypes (
         String         name)
      throws SessionException
   {
      try
      {
         return remote.removeAllTypes(
            name);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* removeAllTypes () */


   public final void cIStringsMatch
   (
         /*in*/   String      string1,
         /*in*/   String      string2,
         /*out*/  NWBoolean   matches
   )
   throws SessionException
   {
      try
      {
         matches.setValue(
            remote.cIStringsMatch(
               string1,
               string2));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final void getAttrName (
         int buf,
         StringBuffer attrName,
         NWInteger attrValCount,           // optional
         NWInteger syntaxID)              // optional
      throws SessionException
   {
      try
      {
         AttrName x = remote.getAttrName(
            buf);
         attrName.setLength(0);
         attrName.append(x.attrName);
         if (null != attrValCount)
            attrValCount.setValue(
               x.attrValCount.getValue());
         if (null != syntaxID)
            syntaxID.setValue(
               x.syntaxID.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getAttrName () */

   /**
    *    @deprecated    use getAttributeValue() instead
    */
   public final void getAttrVal (
         int         buf,
         int         syntaxID,
         NetMemory   attrVal)
      throws SessionException
   {
      try
      {
         remote.getAttrVal(
            buf,
            syntaxID);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getAttrVal () */


   /**
    *
    */
   public final byte[] getAttributeValue (
         int         buf,
         int         syntaxID)
      throws SessionException
   {
      try
      {
         return remote.getAttributeValue(
            buf,
            syntaxID);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getAttributeValue () */


 public final void putAttrName
 (
      int         buf,
      String      attrName

)
   throws SessionException
   {
    try
    {
       remote.putAttrName(
          buf,
          attrName);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 /**
  *    @deprecated    use getAttributeValue() instead
  */
 public final void putAttrVal
 (
      int         buf,
      int         syntaxID,
      int         attrVal

)
   throws SessionException
   {
    try
    {
       remote.putAttrVal(
          buf,
          syntaxID,
          attrVal);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 /**
  *
  */
 public final void putAttributeValue (
       int                              buf,
       int                              syntaxID,
       byte[]                           attributeValue)
    throws SessionException
 {
    try
    {
       remote.putAttributeValue(
          buf,
          syntaxID,
          attributeValue);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
 } /* putAttributeValue () */


 public final void getSyntaxID
 (
      String      attrName,
      NWInteger   syntaxID

)
   throws SessionException
   {
    try
    {
       syntaxID.setValue(
          remote.getSyntaxID(
             attrName));
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void replaceAttrNameAbbrev
 (
      String         inStr,
      StringBuffer   outStr

)
   throws SessionException
   {
    try
    {
       outStr.setLength(0);
       outStr.append(
          remote.replaceAttrNameAbbrev(
             inStr));
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   /**
    *
    */
   public final void extSyncList (
         String               objectName,
         String               className,
         String               subordinateName,
         NetIterationHandle   iterationHandle,
         int                  timeStamp,
         boolean              onlyContainers,
         NetListBuffer        subordinates)  //out
      throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         remote.extSyncList(
            objectName,
            className,
            subordinateName,
            iterationHandle,
            timeStamp,
            onlyContainers,
            subordinates);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   } /* extSyncList () */

   /**
    *
    */
   public final void extSyncRead (
         String      objectName,
         int         infoType,
         boolean     allAttrs,
         int         attrNames,        //in, the request buffer
         NetIterationHandle  iterationHandle,   //in-out
         NetBuffer  objectInfo)         //out, the request buffer
      throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         remote.extSyncRead(
            objectName,
            infoType,
            allAttrs,
            attrNames,
            iterationHandle,
            objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   } /* extSyncRead () */

   /**
    *
    */
   public final void extSyncSearch (
         String      baseObjectName,
         int         scope,
         boolean     searchAliases,
         int         filter,    //a filter buffer.
//         NDSTimeStamp timeStamp,
         int         infoType,
         boolean     allAttrs,
         int         attrNames, //a buffer with the session attribute names.
         NetIterationHandle  iterationHandle,
         int         countObjectsToSearch,
         NWInteger   countObjectsSearched,
         NetBuffer   objectInfo)
      throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         remote.extSyncSearch(
            baseObjectName,
            scope,
            searchAliases,
            filter,    //a filter buffe
            infoType,
            allAttrs,
            attrNames, //a buffer with
            iterationHandle,
            countObjectsToSearch,
            countObjectsSearched,
            objectInfo);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   } /* extSyncSearch () */


   /**
    *
    */
   public final void readClassDef (
         int                     infoType,
         boolean                 allClasses,
         int                     classNames,
         NetIterationHandle      iterationHandle,
         NetReadClassDefBuffer   classDefs)
      throws SessionException
   {
      try
      {
         ReadClassDefStruct st = remote.readClassDef(
            infoType,
            allClasses,
            classNames,
            iterationHandle,
            classDefs);
         iterationHandle.setValue(st.handle.getValue());
         classDefs.setBuffer(st.buffer.getBuffer());
         classDefs.setType(st.buffer.getType());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readClassDef () */


   /**
    *
    */
   public final void defineAttr (
         String            attrName,
         NetAttributeInfo  attrDef)
      throws SessionException
   {
      try
      {
         remote.defineAttr(
            attrName,
            attrDef);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* defineAttr () */

   /**
    *
    */
   public final void defineClass (
         String         className,
         NetClassInfo   classInfo,
         int            classItems)
      throws SessionException
   {
      try
      {
         remote.defineClass(
            className,
            classInfo,
            classItems);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* defineClass () */


 public final void removeClassDef
 (
         /*in*/   String         className
   )
   throws SessionException
   {
    try
    {
       remote.removeClassDef(className);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

/* unused
 public final void ListContainableClasses
 (
         /*in* /      int                  hdlContext,
         /*in* /      String               parentObject,
         /*in/out* /  NetIterationHandle   iterationHandle,
         /*out* /     NetBufferHandle      containableClasses
   )
*/

 public final void modifyClassDef
 (
         /*in*/   String         className,
         /*in*/   int            optionalAttrs
   )
   throws SessionException
   {
    try
    {
       remote.modifyClassDef(
          className,
          optionalAttrs);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   /**
    *
    */
   public final void readSyntaxes (
         int infoType,
         boolean allSyntaxes,
         int syntaxNames,
         NetIterationHandle iterationHandle,
         int syntaxDefs)
      throws SessionException
   {
      try
      {
         NetIterationHandle x = remote.readSyntaxes(
            infoType,
            allSyntaxes,
            syntaxNames,
            iterationHandle,
            syntaxDefs);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readSyntaxes () */


 public final void removeAttrDef
 (
         /*in*/   String         attrName
   )
   throws SessionException
   {
    try
    {
       remote.removeAttrDef(attrName);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void putSyntaxName
 (
         /*in*/   int            buf,
         /*in*/   String         syntaxName
   )
   throws SessionException
   {
    try
    {
       remote.putSyntaxName(
          buf,
          syntaxName);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }


 public final void putClassName
 (
         /*in*/   int            buf,
         /*in*/   String         itemName
   )
   throws SessionException
   {
    try
    {
       remote.putClassName(
          buf,
          itemName);
    }
    catch (java.rmi.RemoteException e)
    {
       if (e.detail instanceof NSIException)
          throw (NSIException) e.detail;
       throw new SessionException("Remote exception", e);
    }
   }

   /**
    *
    */
   public final void readSyntaxDef (
         int syntaxID,
         NetSyntaxInfo syntaxDef)
      throws SessionException
   {
      throw new SessionException("NOT IMPLEMENTED");
      /*
      try
      {
         NetSyntaxInfo sd = remote.readSyntaxDef(syntaxID);
         syntaxDef.xxx = sd.xxx;
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
      */
   }

   public final void syncSchema
   (
         /*in*/   String         server,
         /*in*/   int            seconds
   )
   throws SessionException
   {
      try
      {
         remote.syncSchema(
            server,
            seconds);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   // ******************** Partition methods ********************

   public final void abortPartitionOperation
   (
      /*in*/   String         partitionRoot
   )
   throws SessionException
   {
      try
      {
         remote.abortPartitionOperation(
            partitionRoot);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   /**
    *
    */
   public final void addPartition (
         String server,
         String partitionRoot,
         NetIterationHandle iterationHandle,
         boolean more,
         int objectInfo)
      throws SessionException
   {
      try
      {
         NetIterationHandle x = remote.addPartition(
            server,
            partitionRoot,
            iterationHandle,
            more,
            objectInfo);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* addPartition () */



   public final void addReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot,
      /*in*/      int            replicaType
   )
   throws SessionException
   {
      try
      {
         remote.addReplica(
            server,
            partitionRoot,
            replicaType);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void changeReplicaType
   (
      /*in*/      String         replicaName,
      /*in*/      String         server,
      /*in*/      int            newReplicaType
)
   throws SessionException
   {
      try
      {
         remote.changeReplicaType(
            replicaName,
            server,
            newReplicaType);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   /**
    *
    */
   public final void getPartitionExtInfo (
         int infoPtr,
         int limit,
         int infoFlag,
         IntegerBuffer length,   /* this is different than the C API */
         NetPartitionExtInfo data)    /* this is different than the C API */
      throws SessionException
   {
      try
      {
         PartitionExtStruct x = remote.getPartitionExtInfo(
            infoPtr,
            limit,
            infoFlag);
         length.setValue(
            x.length.intValue());
         data.setValue(
            x.data.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getPartitionExtInfo () */

   public final void getPartitionExtInfoPtr
   (
      /*in*/      int            buf,
      /*out*/     IntegerBuffer  infoPtr,       /* this is different than the C API */
      /*out*/     IntegerBuffer  infoPtrEnd
)   /* this is different than the C API */
   throws SessionException
   {
      try
      {
         PartitionExtPtrStruct x = remote.getPartitionExtInfoPtr(
            buf);
         infoPtr.setValue(
            x.infoPtr.intValue());
         infoPtrEnd.setValue(
            x.infoPtrEnd.intValue());

      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   public final void getPartitionInfo
   (
      /*in*/      int            buf,
      /*out*/     StringBuffer   partitionName,
      /*out*/     IntegerBuffer  replicaType
)
   throws SessionException
   {
      try
      {
         StrInt x = remote.getPartitionInfo(
            buf);
         partitionName.setLength(0);
         partitionName.append(
            x.strValue.toString());
         replicaType.setValue(
            x.intValue.intValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void getPartitionRoot
   (
      /*in*/   String         objectName,
      /*out*/  StringBuffer   partitionRoot
)
   throws SessionException
   {
      try
      {
         partitionRoot.setLength(0);
         partitionRoot.append(
            remote.getPartitionRoot(
               objectName));
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void getServerName
   (
      /*in*/      int            buf,
      /*out*/     StringBuffer   serverName,
      /*out*/     IntegerBuffer  partitionCount
)
   throws SessionException
   {
      try
      {
         StrInt x = remote.getServerName(
            buf);
         serverName.setLength(0);
         serverName.append(
            x.strValue.toString());
         partitionCount.setValue(
            x.intValue.intValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void joinPartitions
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException
   {
      try
      {
         remote.joinPartitions(
            subordinatePartition,
            flags);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }


   /**
    *
    */
   public final void listPartitions (
         NetIterationHandle iterationHandle,
         String server,
         int partitions)
      throws SessionException
   {
      try
      {
         NetIterationHandle x = remote.listPartitions(
            iterationHandle,
            server,
            partitions);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* listPartitions () */

   /**
    *
    */
   public final void listPartitionsExtInfo (
         NetIterationHandle iterationHandle,
         String server,
         int DSPFlags,
         int partitions)
      throws SessionException
   {
      try
      {
         NetIterationHandle x = remote.listPartitionsExtInfo(
            iterationHandle,
            server,
            DSPFlags,
            partitions);

         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* listPartitionsExtInfo () */



   public final void partitionReceiveAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException
   {
      try
      {
         remote.partitionReceiveAllUpdates(
            partitionRoot,
            serverName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void partitionSendAllUpdates
   (
      /*in*/      String         partitionRoot,
      /*in*/      String         serverName
)
   throws SessionException
   {
      try
      {
         remote.partitionSendAllUpdates(
            partitionRoot,
            serverName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void removePartition
   (
      /*in*/      String         partitionRoot
)
   throws SessionException
   {
      try
      {
         remote.removePartition(
            partitionRoot);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void removeReplica
   (
      /*in*/      String         server,
      /*in*/      String         partitionRoot
)
   throws SessionException
   {
      try
      {
         remote.removeReplica(
            server,
            partitionRoot);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void splitPartition
   (
      /*in*/   String         subordinatePartition,
      /*in*/   int            flags
)
   throws SessionException
   {
      try
      {
         remote.splitPartition(
            subordinatePartition,
            flags);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void syncPartition
   (
      /*in*/      String         server,
      /*in*/      String         partition,
      /*in*/      int            seconds
)
   throws SessionException
   {
      try
      {
         remote.syncPartition(
            server,
            partition,
            seconds);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }



   public final void syncReplicaToServer
   (
      /*in*/      String         serverName,
      /*in*/      String         partitionRootName,
      /*in*/      String         destServerName,
      /*in*/      int            actionFlags,
      /*in*/      int            delaySeconds
)
   throws SessionException
   {
      try
      {
         remote.syncReplicaToServer(
            serverName,
            partitionRootName,
            destServerName,
            actionFlags,
            delaySeconds);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   public final void reloadDS(String serverName)
   throws SessionException
   {
      try
      {
         remote.reloadDS(serverName);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

    // ******************** Nds server methods ********************

   public final void getServerAddresses
   (
      /*out*/     IntegerBuffer  countNetAddresses,
      /*out*/     int            netAddresses
)
   throws SessionException
   {
      throw new SessionException("Not implemented");
/*
      try
      {
         remote.getServerAddresses(
            countNetAddresses,
            netAddresses);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
*/
   }



   // ******************** Object Info methods ********************

   /**
    *    @deprecated    use readEntry() instead
    */
   public final void readObjectDSIInfo (
         String object,
         NetMemory objectInfo)
      throws SessionException
   {
      try
      {
         remote.readObjectDSIInfo(
            object);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* ReadObjectDSIInfo () */

   /**
    *    @deprecated    use readEntry() instead
    */
   public final void getDSIInfo (
         NetMemory   buf,
         int         infoFlag,
         NetMemory   data)
      throws SessionException
   {
      try
      {
         remote.getDSIInfo(
            buf,
            infoFlag);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getDSIInfo () */

   /**
    *
    */
   public final NetEntryInfo readEntry (
         /*in*/   String                  object,
         /*in*/   int                     bufferSize)
      throws SessionException
   {
      try
      {
         return remote.readEntry(
            object,
            bufferSize);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* readObjectEntry () */



   public final void getNWNetVersion(
      /*out*/  IntegerBuffer   majorVersion,
      /*out*/  IntegerBuffer   minorVersion,
      /*out*/  IntegerBuffer   revisionLevel,
      /*out*/  IntegerBuffer   betaReleaseLevel)
      throws SessionException
   {
      try
      {
         VersionStruct x = remote.getNWNetVersion();
         majorVersion.setValue(
            x.majorVersion.intValue());
         minorVersion.setValue(
            x.minorVersion.intValue());
         revisionLevel.setValue(
            x.revisionLevel.intValue());
         betaReleaseLevel.setValue(
            x.betaReleaseLevel.intValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public final int getFileServerUTCTime ()
      throws SessionException
   {
      try
      {
         return remote.getFileServerUTCTime();
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* getFileServerUTCTime () */


   // ******************** nwitr.h ********************

   /**
    *
    */
   public void itrCreateSearch (
         /*in*/   String   baseObjectName,
         /*in*/   int      scope,
         /*in*/   boolean  searchAliases,
         /*in*/   int      filter,      // a filter buffer
         /*in*/   int      timeFilter,
         /*in*/   int      infoType,
         /*in*/   boolean  allAttrs,
         /*in*/   int      attrNames,   // a buffer with the attribute names
         /*in*/   String   indexSelect,
         /*in*/   String   sortKey,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]    iterator)
      throws SessionException, NSIException
   {
      try
      {
         iterator[0] = remote.itrCreateSearch(
            baseObjectName,
            scope,
            searchAliases,
            filter,
            timeFilter,
            infoType,
            allAttrs,
            attrNames,
            indexSelect,
            sortKey,
            scalability,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrCreateSearch () */

   /**
    *
    */
   public void itrCreateList (
         /*in*/   String   baseObjectName,
         /*in*/   String   className,
         /*in*/   String   subordinateName,
         /*in*/   int      scalability,
         /*in*/   int      timeout,
         /*out*/  int[]    iterator)
      throws SessionException, NSIException
   {
      try
      {
         iterator[0] = remote.itrCreateList(
            baseObjectName,
            className,
            subordinateName,
            scalability,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrCreateList () */

   /**
    *
    */
   public void itrDestroy (
         /*in*/   int iterator)
      throws SessionException, NSIException
   {
      try
      {
         remote.itrDestroy(iterator);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrDestroy () */

   /**
    *
    */
   public void itrClone (
         /*in*/   int      iterator,
         /*out*/  int[]    newIterator)
      throws SessionException, NSIException
   {
      try
      {
         newIterator[0] = remote.itrClone(
            iterator);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrClone () */


   /**
    *
    */
   public boolean itrAtFirst (
         /*in*/   int   iterator)
      throws SessionException
   {
      try
      {
         return remote.itrAtFirst(iterator);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public boolean itrAtEOF (
         /*in*/   int   iterator)
      throws SessionException
   {
      try
      {
         return remote.itrAtEOF(iterator);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   }

   /**
    *
    */
   public void itrGetInfo (
         /*in*/   int   iterator,
         /*out*/  boolean[] isScalable,
         /*out*/  boolean[] isPositionable)
      throws SessionException
   {
      try
      {
         TwoBooleans x = remote.itrGetInfo(
            iterator);
         isScalable[0] = x.one[0];
         isPositionable[0] = x.two[0];
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrGetInfo () */


   /**
    *
    */
   public void itrGetPosition (
         /*in*/   int      iterator,
         /*out*/  int[]    position,
         /*in*/   int      timeout)
      throws SessionException, NSIException
   {
      try
      {
         position[0] = remote.itrGetPosition(
            iterator,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrGetPosition () */

   /**
    *
    */
   public void itrSetPosition (
         /*in*/   int   iterator,
         /*in*/   int   position,
         /*in*/   int   timeout)
      throws SessionException, NSIException
   {
      try
      {
         remote.itrSetPosition(
            iterator,
            position,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrSetPosition () */

   /**
    *
    */
   public void itrSetPositionFromIterator (
         /*in*/   int   iterator,
         /*in*/   int   srcIterator,
         /*in*/   int   timeout)
      throws SessionException, NSIException
   {
      try
      {
         remote.itrSetPositionFromIterator(
            iterator,
            srcIterator,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrSetPositionFromIterator () */

   /**
    *
    */
   public void itrTypeDown (
         /*in*/   int      iterator,
         /*in*/   String   attribute,
         /*in*/   String   value,
         /*in*/   int      timeout)
      throws SessionException, NSIException
   {
      try
      {
         remote.itrTypeDown(
            iterator,
            attribute,
            value,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrTypeDown () */

   /**
    *
    */
   public void itrSkip (
         /*in*/   int      iterator,
         /*in*/   int      numToSkip,
         /*in*/   int      timeout,
         /*out*/  int[]    numSkipped)
      throws SessionException, NSIException
   {
      try
      {
         numSkipped[0] = remote.itrSkip(
            iterator,
            numToSkip,
            timeout);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrSkip () */

   /**
    *
    */
   public void itrGetNext (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, NSIException
   {
      try
      {
         NetIterationHandle x = remote.itrGetNext(
            iterator,
            numEntries,
            timeout,
            iterationHandle,
            data);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /*  */

   /**
    *
    */
   public void itrGetPrev (
         /*in*/      int                  iterator,
         /*in*/      int                  numEntries,
         /*in*/      int                  timeout,
         /*in/out*/  NetIterationHandle   iterationHandle,
         /*out*/     int                  data)
      throws SessionException, NSIException
   {
      try
      {
         NetIterationHandle x = remote.itrGetPrev(
            iterator,
            numEntries,
            timeout,
            iterationHandle,
            data);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrGetPrev () */

   /**
    *
    */
   public void itrGetCurrent (
      /*in*/      int                  iterator,
      /*in/out*/  NetIterationHandle   iterationHandle,
      /*out*/      int                  data)
      throws SessionException, NSIException
   {
      try
      {
         NetIterationHandle x = remote.itrGetCurrent(
            iterator,
            iterationHandle,
            data);
         iterationHandle.setValue(
            x.getValue());
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrGetCurrent () */

   /**
    *
    */
   public void itrCount (
         /*in*/   int         iterator,
         /*in*/   int         timeout,
         /*in*/   int         maxCount,
         /*in*/   boolean     updatePosition,
         /*out*/  int[]       count)
      throws SessionException, NSIException
   {
      try
      {
         count[0] = remote.itrCount(
            iterator,
            timeout,
            maxCount,
            updatePosition);
      }
      catch (java.rmi.RemoteException e)
      {
         if (e.detail instanceof NSIException)
            throw (NSIException) e.detail;
         throw new SessionException("Remote exception", e);
      }
   } /* itrCount () */

} /* BasicNetServiceWrapper */


