
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsStream.java $
  $Revision: 11 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.IOException;


/**
 * Provides access to values of the NdsStream attribute.
 * Streams are files of information used in attributes such as
 * login scripts. The data stored in a stream file has no syntax
 * enforcement of any kind. It is purely arbitrary data, defined
 * by the application that created and uses it. You should be 
 * aware that NdsStream attributes use a non-buffered input stream,
 * thus, you should do your own buffering in order to improve
 * efficiency and reduce network traffic.
 *
 * <p>Any attribute defined with this syntax is single-valued.
 * When you try to read an attribute of this type or search on it,
 * the value behaves like an empty string. That is, when you
 * return from read or search, it returns an empty octet string.
 * When you try to add a value, the request is ignored.
 * 
 * <p>Matching Rules: (none)</p>
 * 
 * @see NdsSyntaxId
 */
public class NdsStream implements NdsAttributeValue, Cloneable, Serializable
{
   private static final int matchingRules = none;

  /**
   * @internal
   */
   protected InputStream streamToWrite;


  /**
   * @internal
   */
   public NdsStream ()
   {

   }

  /**
   * Constructs a Stream object (attribute value) based on the
   * streamToWrite parameter. The stream attribute value is
   * specifically set up for writing the contents of streamToWrite
   * out to the attribute value when the attribute is set.
   *
   * <p>When this stream value is passed to modifyAttributes() an
   * exception can be thrown in the stream transfer process. When
   * an exception is thrown in the middle of the stream transfer,
   * the input stream will be closed without fully reading its
   * contents, and the attribute value will be assigned to the
   * AttributeModificationException's array of uncompleted attribute
   * modification items.
   *
   * @param streamToWrite The file of information that will be written
   *                      to an NDS InputStream object.
   */
   public NdsStream (
         InputStream streamToWrite)
   {
      this.streamToWrite = streamToWrite;
   }

  /**
   * @internal
   */
   protected NdsStream (
         NdsStream aStream)
   {
      this.streamToWrite = aStream.streamToWrite;
   }


   // ******************** SchemaValue Interface ********************

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically.
   *
   * The compareTo method does not apply to the Stream syntax
   * because this syntax does not support the ordering and
   * substrings matching rules.
   */
   public int compareTo (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * The equals method does not apply to the Streams syntax
   * because this syntax does not support the equality
   * matching rule.
   */
   public boolean equals (
         Object anObject)
   {
      return (false);
   }

  /**
   * @internal
   */
   public String getName ()
   {
      return (null);
   }

  /**
   * @internal
   */
   public String getSyntaxId ()
   {
      return (NdsSyntaxId.STREAM);
   }


   // ******************** NdsAttributeValue Interface ********************

  /**
   * Compares two Objects using the approximate matching rule.
   * 
   * The approximate method does not apply to the Stream
   * syntax because this syntax does not support the approximate
   * equals matching rule.
   */
   public boolean approximate (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Returns the int that represents the NDS syntax ID.
   *
   * @return The syntax ID as an int.
   */
   public int getNdsSyntaxId ()
   {
      return (NdsSyntaxId.STREAM_ID);
   }

  /**
   * Checks to see if this object supports the specified
   * matching rules. The Stream syntax supports no matching rules.
   *
   * @param matchingRules The set of matching rules to check.
   *
   * @return A Boolean set to TRUE if the matching rules for this
   *         object are equal to the matchingRules parameter.
   */
   public boolean supportsMatchingRules (
         int matchingRules)
   {
      if ((matchingRules & this.matchingRules) == matchingRules)
      {
         return (true);
      }
      return (false);
   }


   // ******************** Object Class ********************

  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      return (new NdsStream ());
   }


   // ******************** NdsStream Class ********************

  /**
   * Returns the InputStream object stored in the NDS
   * attribute.
   *
   * @return The InputStream object.
   *
   * @exception IOException
   */
   public InputStream getInputStream ()
      throws IOException
   {
      throw new IOException();
   }

} /* NdsStream */


