
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/SchemaSyntax.java $
  $Revision: 10 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import com.novell.service.jncpv2r.net.NetJNI;


/**
* Defines the standard data types for the values within specified
* attribute types stored in the directory.
*
* <p>An attribute type consists of a single data type for which
* syntax matching rules and qualifiers have been specified.
* Matching rules indicate the characteristics that are significant
* when comparing two values of the same syntax. The three primary
* matching rules are: equality, substrings, and ordering. The
* qualifiers or directives that are defined for comparison include
* ignoring case, dashes, and spaces. Other qualifiers allow only 
* digits or only printable characters.
*
*/
public interface SchemaSyntax
{
   /**
    * Integer used to identify each attribute.
    *
    * <p>(ATTR_ID = "ID")
    */
   public static final String ATTR_ID = "ID";

   /**
    * Represents the Flags attribute ID for syntax definitions.
    * This flag attribute constant contains a value that
    * is a combination of the following flags that restrict the
    * attribute value:
    * <ul><li>DS_STRING
    * <li>DS_SINGLE_VALUED
    * <li>DS_SUPPORTS_ORDER
    * <li>DS_SUPPORTS_EQUAL
    * <li>DS_IGNORE_CASE
    * <li>DS_IGNORE_SPACE
    * <li>DS_IGNORE_DASH
    * <li>DS_ONLY_DIGITS
    * <li>DS_ONLY_PRINTABLE
    * <li>DS_SIZEABLE
    * </ul>
    *
    * <p>(ATTR_FLAGS = "Flags")</p>
    */
   public static final String ATTR_FLAGS = "Flags";

   // Values stored in the Flags attribute
  /**
   * Attribute syntax will be of String type.
   * <p>With this value set for an attribute, the DS_STRING
   * value will be stored in the Flags constant.
   *
   * <p>(DS_STRING = NetJNI.DS_STRING)
   */
   public final static int  DS_STRING = NetJNI.DS_STRING;

  /**
   * Attribute syntax will be single valued.
   * <p>With this value set for an attribute, the DS_SINGLE_VALUED
   * value will be stored in the Flags constant.
   *
   * <p>(DS_SINGLE_VALUED = NetJNI.DS_SINGLE_VALUED)
   */
   public final static int  DS_SINGLE_VALUED = NetJNI.DS_SINGLE_VALUED;

  /**
   * Attribute syntax will support ordering.
   * <p>With this value set for an attribute, the DS_SUPPORTS_ORDER
   * value will be stored in the Flags constant.
   *
   * <p>(DS_SUPPORTS_ORDER = NetJNI.DS_SUPPORTS_ORDER)
   */
   public final static int  DS_SUPPORTS_ORDER = NetJNI.DS_SUPPORTS_ORDER;

  /**
   * Attribute syntax will support the Equals matching rule.
   * <p>With this value set for an attribute, the DS_SUPPORTS_EQUAL
   * value will be stored in the Flags constant.
   *
   * <p>(DS_SUPPORTS_EQUAL = NetJNI.DS_SUPPORTS_EQUAL)
   */
   public final static int  DS_SUPPORTS_EQUAL = NetJNI.DS_SUPPORTS_EQUAL;

  /**
   * Attribute syntax will support ignoring case in strings.
   * <p>With this value set for an attribute, the DS_IGNORE_CASE
   * value will be stored in the Flags constant.
   *
   * <p>(DS_IGNORE_CASE = NetJNI.DS_IGNORE_CASE)
   */
   public final static int  DS_IGNORE_CASE = NetJNI.DS_IGNORE_CASE;

  /**
   * Attribute syntax will support ignoring spaces in strings.
   * <p>With this value set for an attribute, the DS_IGNORE_SPACE
   * value will be stored in the Flags constant.
   *
   * <p>(DS_IGNORE_SPACE = NetJNI.DS_IGNORE_SPACE)
   */
   public final static int  DS_IGNORE_SPACE = NetJNI.DS_IGNORE_SPACE;

  /**
   * Attribute syntax will support ignoring dashes in strings.
   * <p>With this value set for an attribute, the DS_IGNORE_DASH
   * value will be stored in the Flags constant.
   *
   * <p>(DS_IGNORE_DASH = NetJNI.DS_IGNORE_DASH) 
   */
   public final static int  DS_IGNORE_DASH = NetJNI.DS_IGNORE_DASH;

  /**
   * Attribute syntax will support only digits.
   * <p>With this value set for an attribute, the DS_ONLY_DIGITS
   * value will be stored in the Flags constant.
   *
   * <p>(DS_ONLY_DIGITS = NetJNI.DS_ONLY_DIGITS) 
   */
   public final static int  DS_ONLY_DIGITS = NetJNI.DS_ONLY_DIGITS;

  /**
   * Attribute syntax will support only printable characters.
   * <p>With this value set for an attribute, the DS_ONLY_PRINTABLE
   * value will be stored in the Flags constant.
   *
   * <p>(DS_ONLY_PRINTABLE = NetJNI.DS_ONLY_PRINTABLE) 
   */
   public final static int  DS_ONLY_PRINTABLE = NetJNI.DS_ONLY_PRINTABLE;

  /**
   * Attribute syntax will support sizeable character strings.
   * <p>With this value set for an attribute, the DS_SIZEABLE
   * value will be stored in the Flags constant.
   *
   * <p>(DS_SIZEABLE = NetJNI.DS_SIZEABLE) 
   */
   public final static int  DS_SIZEABLE = NetJNI.DS_SIZEABLE;

} /* SchemaSyntaxDirContext */


