
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsInitialContextFactory.java $
  $Revision: 9 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

import com.novell.service.nds.naming.NdsEnvironment;

import com.novell.utility.naming.URLParser;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;


/** @internal
 *
 */
public final class NdsInitialContextFactory implements InitialContextFactory
{
   private ContextFactoryBuilder builder;

   /**
    *
    */
   public NdsInitialContextFactory ()
   {

   }

   /**
    *
    */
   public Context getInitialContext (
         Hashtable environment)
      throws NamingException
   {
      String contextName;
      ContextFactory factory;
      URLParser urlParser;
      NdsEnvironment ndsEnvironment;

/*
      if (null == environment)
      {
         environment = System.getProperties ();
      }
*/
      ndsEnvironment = new NdsEnvironment (environment);
      urlParser = new URLParser (ndsEnvironment.getProviderURL ());
      builder = new WrapperContextFactoryBuilder (ndsEnvironment);

      contextName = getCanonicalName (urlParser.getPath ());

		// find the first unescaped federation character '/' in contextName
      int ndsEnd = -1;
		for(int i=0; i<contextName.length(); i++)
		{
			if (i == 0 && contextName.charAt(0) == '/')
			{
				ndsEnd = 0;
				break;
			}

			if (contextName.charAt(i) == '/' && contextName.charAt(i-1) != '\\')
			{
				ndsEnd = i;
				break;
			}
		}

		if (ndsEnd > 0)
		{
         String ndsBase = contextName.substring (0, ndsEnd);
			String nnsPath = contextName.substring (ndsEnd + 1);
			
			// note: contextName parameter not used in createContextFactory...
			factory = builder.createContextFactory (contextName, ndsEnvironment);

			Context ctx = (factory.getContextInstance (ndsBase, ndsEnvironment));

			// federate into the next naming system
			ctx = (Context)ctx.lookup ("/");

			if (nnsPath.length() > 0)
			{
				ctx = (Context)ctx.lookup (nnsPath);
			}

			return ctx;
		}
		else
		{
			factory = builder.createContextFactory (contextName, ndsEnvironment);

			return (factory.getContextInstance (contextName, ndsEnvironment));
		}


   } /* getInitialContext () */

   /**
    *
    */
   private String getCanonicalName (
         String path)
      throws NamingException
   {
      NdsName name;

      name = new NdsName ((path == null) ? "" : path, new NetSyntax ());

      return (name.getCanonicalString ());
   }

} /* NDSInitialContextFactory */


