/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetServerDirContext.java $
  $Revision: 16 $
  $Modtime: 1/05/01 3:59p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;

import java.rmi.RemoteException;
import java.util.*;

import javax.naming.*;
import javax.naming.directory.*;
import javax.naming.spi.*;

import com.novell.service.nds.*;
import com.novell.service.nds.naming.*;

import com.novell.service.jncp.*;
import com.novell.service.jncpv2r.net.*;

import com.novell.java.lang.IntegerBuffer;

import com.novell.service.session.*;

import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ReferenceFactory;


/** @internal
 *
 */
public class NetServerDirContext
   extends NetDirContext
   implements NdsNCPServer
{
   protected Object nnsp;

   /**
    *
    */
   protected NetServerDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment netEnvironment)
      throws NamingException
   {
      super (objectName, objectInfo, netEnvironment);

   }


   // ******************** NdsNCPServer interface ********************

   /**
    *
    */
   public void reloadDS ()
      throws NSIException
   {
      try
      {
         getServerService ().reloadDS (distinguishedName);
      }
      catch (Exception e)
      {
         throw (new NSIException ());
      }

   } /* reloadDS() */

   /**
    *
    */
   public Enumeration listPartitions ()
      throws NSIException
   {
      return (new NetReplicaEnumerator (distinguishedName, environment));
   }

   /**
    *
    */
   public Date getUTCTime ()
      throws NSIException
   {
      try
      {
         int time;
         Date date = new Date ();

         time = getServerService ().getFileServerUTCTime ();
         date.setTime (time * 1000L);
         return (date);
      }
      catch (Exception e)
      {
         throw (new NSIException ());
      }

   } /* getUTCTime () */


   // ******************** NDSComponentDirContext class ********************

   /**
    *
    */
   protected Object getNNSP ()
      throws NamingException
   {
      if (null == nnsp)
      {
         try
         {
            Class cls;
            Hashtable properties;
            ReferenceFactory referenceFactory;
            Reference reference;

            // Guarantee NDS server session
            Session session = getServerSession ();

            cls = Class.forName ("com.novell.service.server.ReferenceFactoryImpl");
            referenceFactory = (ReferenceFactory) cls.newInstance ();

            properties = ((NetEnvironment) environment).getEnvironment ();

            // set PROVIDER_URL to <ServerName>
            properties.put (Context.PROVIDER_URL, getServerName ());

            // set SESSION_OBJECT to NDS Server Session
            properties.put (Environment.SESSION_OBJECT, session);

            reference = referenceFactory.createReference (properties);

            nnsp = NamingManager.getObjectInstance (reference, null, null, properties);
         }
         catch (Exception e)
         {
            // nnsp remains null
         }
      }
      return (nnsp);

   } /* getNNSP () */


   // ******************** NetServerDirContext class ********************

   /**
    *
    */
   private String getServerName ()
      throws NamingException
   {
      NdsName serverName;

      serverName = (NdsName) nameParser.parse (distinguishedName);
      return (serverName.getTypelessName ().get (serverName.size () - 1));

   } /* getServerName () */

   /**
    *
    */
   private NetService getServerService ()
      throws NamingException, SessionException, RemoteException
   {
      Session session;

      session = getServerSession ();
      return ((NetService) session.getService (BasicNetService.KEY));
   }

   /**
    *
    */
   private Session getServerSession ()
      throws NamingException, SessionException, RemoteException
   {
      SessionManager manager = environment.getSessionManager ();
      Session session = manager.findSession (getTreeName ());

      return (session.getSession (distinguishedName));
   }

} /* NetNCPServerDirContext */


// ******************** NetReplicaEnumerator ********************

/**
 *
 */
class NetReplicaEnumerator implements Enumeration
{
   private String server;
   private NetService service;

   private NetIterationHandle iterationHandle;
   private NetBuffer partitions;
   private int entriesLeft;

   /**
    *
    */
   public NetReplicaEnumerator (
         String server,
         NetEnvironment netEnvironment)
      throws NSIException
   {
      try
      {
         this.server = server;
         this.service = netEnvironment.getService ();

         iterationHandle = new NetIterationHandle (
                                    service,
                                    NetService.DSV_LIST_PARTITIONS);
         partitions = new NetBuffer (
                              service,
                              netEnvironment.getBatchSize ());
         listPartitions ();
      }
      catch (NamingException e)
      {
         throw (new NSIException ());
      }

   } /* NdsNameClassEnumerator () */

   /**
    *
    */
   public boolean hasMoreElements ()
   {
      if ((0 == entriesLeft) && (!iterationHandle.moreIterations ()))
      {
         return (false);
      }
      return (true);
   }

   /**
    *
    */
   private void listPartitions ()
      throws NSIException
   {
      try
      {
         String serverName;
         IntegerBuffer partitionCount = new IntegerBuffer ();

         service.listPartitions (
                        iterationHandle,
                        server,
                        partitions.getHandle ());

         serverName = partitions.getServerName (partitionCount);
         entriesLeft = partitionCount.intValue ();
      }
      catch (SessionException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
      catch (RemoteException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }

   } /* listPartitions () */

   /**
    *
    */
   public Object nextElement ()
   {
      if (!this.hasMoreElements ())
      {
         throw (new NoSuchElementException ());
      }
      try
      {
         StringBuffer partitionName = new StringBuffer ();
         IntegerBuffer replicaType = new IntegerBuffer ();

         if (0 == entriesLeft)
         {
            listPartitions ();
         }

         partitions.getPartitionInfo (partitionName, replicaType);
         entriesLeft--;

         return (new String (partitionName));
      }
      catch (NSIException e)
      {
         throw (new NoSuchElementException ());
      }

   } /* nextElement () */

} /* NetReplicaEnumerator */


