/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/security/XplatIdentity.java $
  $Revision: 4 $
  $Modtime: 1/14/99 11:25a $

  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.security;

import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

import com.novell.java.security.Identity;
import com.novell.java.security.IdentityScope;
import com.novell.java.security.KeyManagementException;
import com.novell.java.security.PublicKey;
import com.novell.service.session.util.Debug;
import com.novell.service.session.Session;
import com.novell.service.session.SessionManager;

/**
 * Represents an authenticatable entity in Xplat, such as a user, an
 * administrator, and so forth. This class is not intended to be instantiated
 * as is, but rather extended by NDS and Bindery identities. This class
 * contains the common functionality of session management for these classes.
 *
 * <code>
 * <pre>
 * IdentityScope administrativeDomain  = new XplatIdentityScope();
 * IdentityScope tree                  = new XplatIdentityScope("KARAH_CORP",administrativeDomain);
 * IdentityScope context               = new XplatIdentityScope("Engineering",tree);
 * IdentityScope subcontext            = new XplatIdentityScope("Java",context);
 * Identity      user                  = new XplatIdentity("Karah",subcontext);
 * </pre>
 * </code>
 *
 * @see XplatIdentityScope
 * @see BinderyIdentity
 * @see NdsIdentity
 */
public abstract class XplatIdentity
   extends Identity
{
   /**
    * The session manager object for this identity.
    */
   private SessionManager sessionManager = null;
   /**
    * The session object for this identity.
    */
   private Session session = null;

   /**
	 * Construct an identity with the specified user name and no scope.
	 *
	 * @param name                The user name of the identity.
	 */
   public XplatIdentity (
         String name)
   {
      super(name);
   } // XplatIdentity ()

   /**
	 * Construct an identity with the specified user name as a String and scope
    * as an IdentityScope.
	 *
	 * @param name                The user name of the identity.
	 * @param scope               The scope of the identity (the domain).
    * @exception KeyManagementException When an error occurs.
    */
   public XplatIdentity (
         String name,
         IdentityScope scope)
      throws KeyManagementException
   {
      super (name, scope);
   } // XplatIdentity ()

   /**
    * Construct an identity from an identity.
    *
    * <p>The name and parent scope are copied from the existing identity.
    * If the identity is an XplatIdentity, the session and session manager are
    * also copied.
    *
	 * @param identity            The identity to copy.
    * @exception KeyManagementException When an error occurs.
    */
   public XplatIdentity (
         Identity identity)
      throws KeyManagementException
   {
      super (identity.getName(), identity.getScope ());
      if (identity instanceof XplatIdentity)
      {
         setSessionManager (((XplatIdentity) identity).getSessionManager ());
         setSession (((XplatIdentity) identity).getSession ());
      }
   }

   /**
    * Set the session manager for the identity.
    *
    * @param sessionManager      The SessionManager to use for this identity.
    */
   public void setSessionManager(SessionManager sessionManager)
   {
      this.sessionManager = sessionManager;
   }

   /**
    * Get the session manager for the identity.
    *
    * @return context handle for the identity
    */
   public SessionManager getSessionManager()
   {
      return sessionManager;
   }

   /**
    * Set the session for the identity.
    *
    * @param context context handle for the identity
    */
   public void setSession(Session session)
   {
      this.session = session;
   }

   /**
    * Get the session manager for the identity.
    *
    * @return context handle for the identity
    */
   public Session getSession()
   {
      return session;
   }

   // XplatIdentity abstract methods =========================================
   /**
	 * Get the administrative domain string.
	 *
	 * @return                    The administrative domain identifier.
	 */
   public abstract String getAdministrativeDomain ();

   /**
	 * Return the user name.
	 *
	 * @return                    The String name of the user domain.
	 */
   public abstract String getUsername ();

   /**
	 * Returns the user domain as a String.
	 *
	 * @return                    The String containing the user domain.
	 */
   public abstract String getUserDomain ();
   
} // class XplatIdentity
