/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/server/ServerVersions.java $
  $Revision: 9 $
  $Modtime: 1/28/00 12:46p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.server;

import com.novell.service.jncp.NSIException;

/**
 * Provides a specific attribute of a ServerDirContext. The ID of the
 * attribute is equal to ATTR_ID, and the attribute value is an object
 * that implements this interface.
 *
 * <p>This attribute supports expanded search capabilities. Use the
 * setSearchFields() and getSearchFields() methods to control which
 * fields are used when performing a search. If the searchFields are
 * not explicitly set, then all fields are used by default.
 */
public interface ServerVersions
{
  /**
   *  The attribute ID of this attribute.
   *
   *  (ATTR_ID =  "ServerVersions")
   */
   public final static String ATTR_ID = "ServerVersions";

   /**
   *  @deprecated
   *  This member will be removed. Use ATTR_ID instead.
   */
   public final static String attrID = ATTR_ID;

  /**
   * The Major Version constant for use in the search field.
   *
   * <p>(MAJOR_VERSION = 0x0001)
   */
   public final static int MAJOR_VERSION = 0x0001;
   
  /**
   * The Minor Version constant for use in the search field.
   *
   * <p>(MINOR_VERSION = 0x0002)
   */
   public final static int MINOR_VERSION = 0x0002;
   
  /**
   * The Revision constant for use in the search field.
   *
   * <p>(REVISION = 0x0004)
   */
   public final static int REVISION = 0x0004;
   
  /**
   * The Account Version constant for use in the search field.
   *
   * <p>(ACCOUNT_VERSION = 0x0008)
   */
   public final static int ACCOUNT_VERSION = 0x0008;
   
  /**
   * The Queue Version constant for use in the search field.
   *
   * <p>(QUEUE_VERSION = 0x0010)
   */
   public final static int QUEUE_VERSION = 0x0010;
   
  /**
   * The Print Version constant for use in the search field.
   *
   * <p>(PRINT_VERSION = 0x0020)
   */
   public final static int PRINT_VERSION = 0x0020;
   
  /**
   * The Virtual Console Version constant for use in the search field.
   *
   * <p>(VIRTUAL_CONSOLE_VERSION = 0x0040)
   */
   public final static int VIRTUAL_CONSOLE_VERSION = 0x0040;
   
  /**
   * The Security Version constant for use in the search field.
   *
   * <p>(SECURITY_VERSION = 0x0080)
   */
   public final static int SECURITY_VERSION = 0x0080;
   
  /**
   * The Internet Bridge Version constant for use in the search field.
   *
   * <p>(INTERNET_BRIDGE_VERSION = 0x0100)
   */
   public final static int INTERNET_BRIDGE_VERSION = 0x0100;

  /**
   * Sets the fields to be used when performing a search. Use the
   * constants defined in this interface as the value of the fields
   * parameter. Multiple fields can be bitwise OR'ed together to
   * search on multiple fields.
   *
   * @param fields The fields to be used in the search.
   */
   public void setSearchFields(
         int fields);

  /**
   * Returns the fields currently set to be used when performing
   * a search.
   *
   * @return The search fields currently set.
   */
   public int getSearchFields();

  /**
   * Returns the major version of the server.
   *
   * @return The major version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getMajorVersion() throws NSIException;

  /**
   * Returns the minor version of the server.
   *
   * @return The minor version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getMinorVersion() throws NSIException;

  /**
   * Returns the revision number of the server.
   *
   * @return The revision number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getRevision() throws NSIException;

  /**
   * Returns the account version of the server.
   *
   * @return The account version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getAccountVersion() throws NSIException;

  /**
   * Returns the queue version number of the server.
   *
   * @return  The queue version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getQueueVersion() throws NSIException;

  /**
   * Returns the print version number of the server.
   *
   * @return The print version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getPrintVersion() throws NSIException;

  /**
   * Returns the virtual console version number of the server.
   *
   * @return  The virtual console version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getVirtualConsoleVersion() throws NSIException;

  /**
   * Returns the security version number of the server.
   *
   * @return  The security version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getSecurityVersion() throws NSIException;

  /**
   * Returns the Internet bridge version number of the server.
   *
   * @return  The Internet bridge version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public byte getInternetBridgeVersion() throws NSIException;

  /**
   * Sets the major version number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The major version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMajorVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the minor version number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The minor version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setMinorVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the revision number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The revision number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setRevision(
         byte value)
      throws NSIException;
      
  /**
   * Sets the account version number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The account version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setAccountVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the minor queue version number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The queue version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setQueueVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the print version number of the server as the search value.
   * This is used to search for all servers matching the value parameter.
   *
   * @param value The print version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setPrintVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the virtual console version number of the server as the search
   * value. This is used to search for all servers matching the value
   * parameter.
   *
   * @param value The virtual console version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setVirtualConsoleVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the security version number of the server as the search
   * value. This is used to search for all servers matching the value
   * parameter.
   *
   * @param value The security version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setSecurityVersion(
         byte value)
      throws NSIException;
      
  /**
   * Sets the Internet bridge version number of the server as the search
   * value. This is used to search for all servers matching the value
   * parameter.
   *
   * @param value The Internet bridge version number.
   *
   * @exception NSIException Standard NJCL exception for working on
   *                         top of Xplat libraries.
   */
   public void setInternetBridgeVersion(
         byte value)
      throws NSIException;
}
