/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/util/DebugListen.java $
  $Revision: 3 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
import java.io.*;
import java.net.*;
import com.novell.service.session.util.Debug;

/** @internal
 */
public final class DebugListen
{
   static int SOCKET_PORT = 2000;

   public static void main(String[] args)
   {
      String hostname;

      if (args.length == 0)
      {
         System.out.println("USAGE: java DebugListen <address>");
         System.out.println("  ...listening for localhostname session");
         hostname = "localhost";
      }
      else
      {
         hostname = args[0];
      }
      System.out.print("Attaching...");
      for (;;)
      {
         System.out.print(".");
         try
         {
            listen(hostname);
         }
         catch (Throwable e)
         {
            e.printStackTrace();
            // Keep trying
            pause(1000);
         }
      }
   }

   private static void pause(long millis)
   {
      long end = System.currentTimeMillis() + millis;
      while (System.currentTimeMillis() < end);
   }

  /**
   * The run method used in servicing requests to view debug output via sockets.
   */
   private static void listen(String hostname)
   {
      Socket socket = null;
      
      try
      {
         socket = new Socket(hostname, SOCKET_PORT );
      }
      catch (ConnectException e)
      {
         // Ignore
         return;
      }
      catch (Exception e)
      {
         System.out.println("Error listening on port.");
         e.printStackTrace();
         return;
      }
      
      try
      {
         System.out.println("");
         System.out.println("Connected to: " + hostname);
         InputStreamReader isr = new InputStreamReader(socket.getInputStream());
         BufferedReader br = new BufferedReader(isr);
         String line = br.readLine();;

         while(null != line)
         {
            try
            {
               System.out.println(line);
               line = br.readLine();
            }
            catch (Exception e)
            {
               line = null;
               e.printStackTrace();
            }
         }
         System.out.print("Lost connection...");
      }
      catch (Exception e)
      {
         e.printStackTrace();
      }
   }
}


