/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/DomainNameMismatchException.java $
  $Revision: 6 $
  $Modtime: 11/15/00 3:43p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import com.novell.service.session.SessionException;

/**
 * Thrown when a server name does not match the name in the connection.
 */
public class DomainNameMismatchException extends SessionException
{
   /**
    * Constructs a DomainNameMismatchException with the requested server
    * and connection server.
    *
    * @param requestedServer  The specific server requested.
    * @param connectionServer The specific connection server.
    */
   public DomainNameMismatchException
   (
      String requestedServer,
      String connectionServer
   )
   {
      super(requestedServer + " != " + connectionServer);
   }

   /**
    * Constructs a DomainNameMismatchException with the requested server,
    * connection server and address.
    *
    * @param requestedServer  The specific server requested.
    * @param connectionServer The specific connection server.
    * @param addr The specified address.
    */
   public DomainNameMismatchException
   (
      String requestedServer,
      String connectionServer,
      Address addr
   )
   {
      super(requestedServer + " != " + connectionServer + " @ " +addr);
   }
}

