/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/NCPServiceWrapper.java $
  $Revision: 2 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.RemoteException;
import com.novell.service.session.*;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2r.clx.ClxJNI;
import com.novell.service.session.xplat.NCPServiceRemote.*;

/** @internal
 * Object returned by Session.getService()
 */
public class NCPServiceWrapper implements NCPService, java.io.Serializable
{
   NCPServiceRemote remote;

   public NCPServiceWrapper(NCPServiceRemote rem)
   throws SessionException, RemoteException
   {
      remote = rem;
   }
   
   public int fragmentRequest
   (
      int function,
      int verb,
      int reserved,
      byte[][] reqFrags,
      /*inout*/ byte[][] replyFrags
   )
   throws NSIException, SessionException, RemoteException
   {
      FragReqStruct reply = remote.fragmentRequest(
         function, verb, reserved, reqFrags, replyFrags);
      for(int x=0; x < replyFrags.length; x++)
         System.arraycopy(reply.replyFrags[x], 0, replyFrags[x], 0, replyFrags[x].length);
      return reply.numOfBytes;
   }
}
