
/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/utility/naming/directory/SearchEnumerator.java $
  $Revision: 3 $
  $Modtime: 8/10/99 5:57p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.utility.naming.directory;


import java.util.*;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;


/** @internal
 * The NamingEnumeration that is returned from all searches
 *
 * <p>The various search methods will use this class to instantiate and set
 * up the NamingEnumeration results that will be returned to the caller.
 * </p>
 */
public class SearchEnumerator implements NamingEnumeration
{
   private Enumeration enum;

   public SearchEnumerator ()
   {
      this (new Vector ());
   }

   public SearchEnumerator (Vector v)
   {
      enum = v.elements ();
   }

   public boolean hasMoreElements ()
   {
      return enum.hasMoreElements ();
   }

   public boolean hasMore()
   {
      return enum.hasMoreElements();
   }

   public Object nextElement ()
   {
      return enum.nextElement ();
   }

   public Object next ()
   {
      return enum.nextElement ();
   }

   public void close ()
      throws NamingException
   {
   }

}


