/* **************************************************************************

  $Archive: /njcl/src/com/novell/java/lang/BooleanBuffer.java $
  $Revision: 4 $
  $Modtime: 11/25/98 1:52p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.java.lang;

/** @internal
 * This class is used only for communication with the native libraries.
 */

public final
class BooleanBuffer {
    /**
     * The value of the Boolean buffer.
     */
    private boolean value;

    /**
     * Constructs a Boolean buffer object initialized to the specified boolean 
     * value.
     * @param value the value of the boolean
     */
    public BooleanBuffer(boolean value) {
	this.value = value;
    }

    /**
     * Constructs a Boolean buffer object initialized to the value specified by the
     * String parameter. 
     * @param s		the String to be converted to a Boolean buffer
     */
    public BooleanBuffer(String s) {
	this(toBoolean(s));
    }

    /**
     * Constructs a Boolean buffer with the specified initial value.
     * @param val	the initial value of the buffer
     */
    public BooleanBuffer(Boolean val) {
	this(val.booleanValue());
    }

    /**
     * Returns the value of this Boolean buffer object as a boolean.
     */
    public boolean booleanValue() {
	return value;
    }

    /**
     * Assigns the value of this Boolean buffer with an int.
     * @param value	the new value of the buffer.
     */
    public void setValue (int value)
    {
	this.value = (value==0 ? false : true);
    }

    /**
     * Assigns the value of this Boolean buffer with a boolean.
     * @param value	the new value of the buffer.
     */
    public void setValue (boolean value)
    {
	this.value = value;
    }

    /**
     * Assigns the value of this Boolean buffer with a Boolean.
     * @param value	the new value of the buffer.
     */
    public void setValue (Boolean val)
    {
	this.value = val.booleanValue();
    }

    /**
     * Returns a String object representing this Boolean buffer's value.
     */
    public String toString() {
	return value ? "true" : "false";
    }

    /**
     * Returns a hashcode for this Boolean buffer.
     */
    public int hashCode() {
	return value ? 1231 : 1237;
    }

    /**
     * Compares this object against the specified object.
     * @param obj		the object to compare with
     * @return 		true if the objects are the same; false otherwise.
     */
    public boolean equals(Object obj) {
	if ((obj != null) && (obj instanceof BooleanBuffer)) {
	    return value == ((BooleanBuffer)obj).booleanValue();
	} 
	return false;
    }

    private static boolean toBoolean(String name) { 
	return ((name != null) && name.toLowerCase().equals("true"));
    }
}







