/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/bindery/BinderyObjectFactory.java $
  $Revision: 6 $
  $Modtime: 2/16/99 9:03a $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.bindery;

import java.util.*;

import javax.naming.*;
import javax.naming.spi.*;

import com.novell.service.session.*;
import com.novell.utility.naming.Environment;


/** @internal
 * This class creates objects for the JNDI Bindery name space.
 */

public class BinderyObjectFactory
   implements ObjectFactory
{
   /**
    * Creates an object using the location or reference information
    * specified.  Special requirements of this object are supplied
    * using 'environment'.
    *
    * @param obj          The object containing location or reference info
    *                        that can be used in creating an object.
    * @param environment  Environment properties that are used in
    *                        creating the object and passed to it.
    * @return             The object created.
    */
   public Object getObjectInstance (
         Object obj,
         Name name,        //NOTE: name needs to be implemented
         Context nameCtx,  //NOTE: name needs to be implemented
         Hashtable hash)
      throws Exception
   {
      Object            ret = null;

      if (!(obj instanceof Reference))      // Make sure it's a reference
      {
         return ret;
      }

      BinderyDirContext bdc = null;
      StringRefAddr     refAddr;
      SessionEnv        env;
      SessionManager    sm;
      Session           session;
      Reference         ref = (Reference) obj;
      
      BinderyEnvironment environment = new BinderyEnvironment (hash);

      /* Regardless of the type of object being created, we need a bdc.
       * If that is the desired object, return it.  If not, use it to
       * create the desired object.
       */

      String host = ReferenceFactoryImpl.SERVICE_HOST;
      if ((refAddr = (StringRefAddr)ref.get(host)) != null)
      {
         sm = (SessionManager) environment.getSessionManager ();
         if (sm == null)
         {
            env = new SessionEnv ();
            env.put(SessionEnv.INITIAL_SESSION_FACTORY,
               "com.novell.service.session.nds.NDSInitialSessionFactory:" +
               "com.novell.service.session.bindery.BinderyInitialSessionFactory");
            sm = SessionManagerFactory.getSessionManager(env);
            environment.addToEnvironment (Environment.SESSION_MANAGER_OBJECT, sm);
         }

         session = sm.getSessionTop ((String)refAddr.getContent ());
         environment.addToEnvironment (Environment.SESSION_OBJECT, session);

         bdc = new BinderyDirContext (environment);
      }
      else
         return ret;


      if (ref.getClassName ().equals (ClassNames.BINDERY))
      {
         ret = bdc;
      }
      else
      {
         // Create the object by looking up its mangled name with the bdc's
         //   lookup method.   MUST have the obj type on the object name.

         refAddr = (StringRefAddr) ref.get (
                           ReferenceFactoryImpl.OBJECT_NAME);
         if (refAddr != null)
         {
            BinderyObjectDirContext bodc = (BinderyObjectDirContext)
               bdc.lookup ((String) refAddr.getContent ());

            ret = bodc;
         }
      }  // end else creating a bindery subClass

      return ret;
   } // getObjectInstance ()
   
} // class BinderyObjectFactory

