
/****************************************************************************

  $Workfile: $
  $Revision: $
  $Modtime:: $
  $Copyright:

  Copyright (c) 1989-1995 Novell, Inc.  All Rights Reserved.                      

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE 
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.$

 ***************************************************************************/


#include <sys_api.h>

#include <StubPreamble.h>
#include <javaString.h>
#include <jni.h>

#include <ntypes.h>

/*
 * Class:     com_novell_service_jncpv2r_net_NetMemory
 * Method:    allocMemory
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetMemory_allocMemory
(
   JNIEnv   *env, 
   jobject  this, 
   jint     size
)
{
   jint ret;

   /* create Java Char[] */
   ret = (jint) sysMalloc (size);

   if (0 == ret)
   {

   }
   return (ret);

} /* ByteAlloc */


/*
 * Class:     com_novell_service_jncpv2r_net_NetMemory
 * Method:    allocByteArray
 * Signature: ([B)I
 */
JNIEXPORT jint JNICALL 
Java_com_novell_service_jncpv2r_net_NetMemory_allocByteArray
(
   JNIEnv *env,
   jobject this,
   jbyteArray byteArray
)
{
   jint ret;
   int size = (*env)->GetArrayLength (env, byteArray);
   jbyte *pByte = (*env)->GetByteArrayElements (env, byteArray, 0);

   ret = (jint) sysMalloc (size);

   memcpy ((char *)ret, pByte, size);

   (*env)->ReleaseByteArrayElements (env, byteArray, pByte, JNI_ABORT);   

   if (0 == ret)
   {

   }
   return (ret);

} /* allocByteArray () */


/*
 * Class:     com_novell_service_jncpv2r_net_NetMemory
 * Method:    freeMemory
 * Signature: (I)V
 */
JNIEXPORT void JNICALL 
Java_com_novell_service_jncpv2r_net_NetMemory_freeMemory
(
   JNIEnv   *ShesaNoUsa, 
   jobject  InoUsaDisOne, 
   jint     handle
)
{
   sysFree ((void *) handle);
}   


/*
 * Class:     com_novell_service_jncpv2r_net_NetMemory
 * Method:    getByteArray
 * Signature: ()[B
 */
JNIEXPORT jbyteArray JNICALL 
Java_com_novell_service_jncpv2r_net_NetMemory_getByteArray
(
   JNIEnv *env,
   jobject this
)
{
   jclass classID;
   jmethodID methodID;
   jfieldID fieldID;
   long length;
   nuint8 *cByteArray;
   jbyteArray byteArray;

   classID = (*env)->GetObjectClass (env, this);
   methodID = (*env)->GetMethodID (env, classID, "getHandle", "()I"); 
   cByteArray = (nuint8 *)(*env)->CallIntMethod (env, this, methodID);

   methodID = (*env)->GetMethodID(env, classID, "getSize", "()I"); 
   length = (*env)->CallIntMethod(env, this, methodID);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, length);

   (*env)->SetByteArrayRegion(env, byteArray, 0, (jsize) length,
         (jbyte *) cByteArray);

   // set validHandle to false so that we don't try to free it in finalize()
   fieldID = (*env)->GetFieldID (env, classID, "validHandle", "Z");
   (*env)->SetIntField (env, this, fieldID, JNI_FALSE);

   // free the handle
   sysFree(cByteArray); 

   return (byteArray);

}


