/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "unicode.h"

#include "jncpWire.h"

#include "NetEMailAddressJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetEMailAddress
 *    extends NdsEMailAddress
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetEMailAddress)
NetEMailAddressCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetEMailAddress;
   jclass clsNetEMailAddressLR;
   //NJCL variables
   pNetEMailAddress sNetEMailAddress;

   clsNetEMailAddressLR = (*env)->FindClass (env, NETSYNTAXPKG "NetEMailAddress");
   clsNetEMailAddress = (*env)->NewGlobalRef (env, clsNetEMailAddressLR);
   (*env)->DeleteLocalRef (env, clsNetEMailAddressLR);

   sNetEMailAddress = (pNetEMailAddress) sysMalloc (sizeof (NetEMailAddress));

   if (NULL != sNetEMailAddress)
   {
      // assign jclass variables
      sNetEMailAddress->cls = clsNetEMailAddress;

      // assign jfieldID variables
      sNetEMailAddress->ID.type = (*env)->GetFieldID (env, clsNetEMailAddress, "type", "I");
      sNetEMailAddress->ID.address = (*env)->GetFieldID (env, clsNetEMailAddress, "address", "Ljava/lang/String;");
   }
   return (sNetEMailAddress);

} /* NetEMailAddressCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetEMailAddressCreate
(
   JNIEnv *env,
   pNetEMailAddress sNetEMailAddress,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netEMailAddress = (*env)->AllocObject (env, sNetEMailAddress->cls);

   {
      nuint32 length;

      NAlign32 (curPos);
      length = jncpGetInt32 (env, curPos, limit);
   }

   {
      (*env)->SetIntField (
                              env,
                              netEMailAddress,
                              sNetEMailAddress->ID.type,
                       (jint) jncpGetInt32 (env, curPos, limit));
   }

   {
      jstring address;

      (*env)->SetObjectField (
                                 env,
                                 netEMailAddress,
                                 sNetEMailAddress->ID.address,
                        (jobject)(address = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, address);
   }

   return (netEMailAddress);

} /* NetEMailAddressCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/* typedef struct
 * {
 *    nuint32  type;
 *    pnstr8   address;
 * }EMail_Address_T;
 *
 * CStruct:
 *  | TYPE | AddressPointer | address
 *
 * java array:
 *  | TYPE | ADDRESS |
 */
 
N_GLOBAL_FUNC_C (jbyteArray)
NetEMailAddress_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pEMail_Address_T eMailAddress;
   nuint8 *eMailAddressPtr, *ptr;

   // NdsMemory.handle - EMailAddress C struct
   eMailAddress = (pEMail_Address_T) cValue;

   // malloc temporary buffer
   eMailAddressPtr = (nuint8 *) sysMalloc (cLength);
   ptr = eMailAddressPtr;

   // build the temporary buffer
   *(pnuint32) ptr = eMailAddress->type;
   ptr += sizeof (pnuint32);

   unicpy((unicode *) ptr, (unicode *) eMailAddress->address);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) eMailAddressPtr);

   // free temporary buffer
   sysFree (eMailAddressPtr);

   return (byteArray);

}  /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetEMailAddress_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pEMail_Address_T eMailAddress;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(EMail_Address_T);

   // malloc NetMemory buffer
   eMailAddress = (pEMail_Address_T) sysMalloc (length);
   dataPtr = (nuint8 *)(eMailAddress) + sizeof(EMail_Address_T);

   // build the buffer
   eMailAddress->type = *(nuint32 *) ptr;
   ptr += sizeof(nuint32);

   eMailAddress->address = (pnchar) dataPtr;
   unicpy((unicode *) eMailAddress->address, (unicode *) ptr);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) eMailAddress);

} /* toCStruct () */


#ifdef __cplusplus
}
#endif


