/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/


#include <sys_api.h>

#include <nwalias.h>

#include "jncpWire.h"

#include "NetOctetStringJNI.h"


/* public final class NetOctetString
 *    extends NdsOctetString
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected byte[][] value;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetOctetString)
NetOctetStringCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetOctetString;
   jclass clsNetOctetStringLR;
   //NJCL variables
   pNetOctetString sNetOctetString;

   clsNetOctetStringLR = (*env)->FindClass (env, NETSYNTAXPKG "NetOctetString");
   clsNetOctetString = (*env)->NewGlobalRef (env, clsNetOctetStringLR);
   (*env)->DeleteLocalRef (env, clsNetOctetStringLR);

   sNetOctetString = (pNetOctetString) sysMalloc (sizeof (NetOctetString));

   if (NULL != sNetOctetString)
   {
      // assign jclass variables
      sNetOctetString->cls = clsNetOctetString;

      // assign jfieldID variables
      sNetOctetString->ID.value = (*env)->GetFieldID (env, clsNetOctetString, "value", "[B");
   }
   return (sNetOctetString);

} /* NetOctetStringCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetOctetStringCreate
(
   JNIEnv *env,
   pNetOctetString sNetOctetString,
   pBuf_T buf
)
{
   // JNI variables
   // NWNet variables
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netOctetString = (*env)->AllocObject (env, sNetOctetString->cls);

   {
      jbyteArray value;
      // NWNet variables
      pnstr8 cValue;
      nuint32 length;

      NAlign32 (curPos);

      cValue = jncpGetData (env, curPos, limit, &length);
      value = (*env)->NewByteArray (env, length); 
      (*env)->SetByteArrayRegion (env, value, 0, length, (jbyte *) cValue); 

      (*env)->SetObjectField (
                                 env,
                                 netOctetString,
                                 sNetOctetString->ID.value,
                       (jobject) value);

      (*env)->DeleteLocalRef (env, value);
   }

   return (netOctetString);

} /* NetOctetStringCreate () */


/***** NetAttrRecordJNI.h *************************************************/

/*
 * typedef struct
 * {
 *    NWLEN    length;
 *    pnuint8  data;
 * } Octet_String_T;
 *
 * java array:
 *  | length | data
 */

/*
 *
 */
N_GLOBAL_FUNC_C (jbyteArray)
NetOctetString_toByteArray
(
   JNIEnv *env,
   nptr cValue,
   nuint32 cLength
)
{
   // JNI variables
   jbyteArray byteArray;
   // NWNet variables
   pOctet_String_T octetString;
   nuint8 *octetStringPtr, *ptr;

   // NdsMemory.handle - OctetString C struct
   octetString = (pOctet_String_T) cValue;

   // malloc temporary buffer
   octetStringPtr = (pnuint8) sysMalloc (cLength);
   ptr = octetStringPtr;

   // build the temporary buffer
   *(NWLEN *) ptr = octetString->length;
   ptr += sizeof(NWLEN);

   memcpy (ptr, octetString->data, octetString->length);

   // allocate return byte[]
   byteArray = (*env)->NewByteArray (env, cLength);

   // copy temporary buffer to byte[]
   (*env)->SetByteArrayRegion (env, byteArray, 0, cLength, (jbyte *) octetStringPtr);

   // free temporary buffer
   sysFree (octetStringPtr);

   return (byteArray);

} /* toByteArray () */


/*
 *
 */
N_GLOBAL_FUNC_C (nptr) 
NetOctetString_toCStruct
(
   JNIEnv      *env, 
   jbyteArray  values
)
{
   // JNI variables
   jbyte *byteArray, *ptr;
   jsize length;
   // NWNet variables
   pOctet_String_T octetString;
   nuint8 *dataPtr;

   // get byte[]
   byteArray = (*env)->GetByteArrayElements (env, values, 0);
   ptr = byteArray;

   // calculate NetMemory size
   length = (*env)->GetArrayLength (env, values) + sizeof(Octet_String_T);

   // malloc NetMemory buffer
   octetString = (pOctet_String_T) sysMalloc (length);
   dataPtr = (nuint8 *)(octetString) + sizeof(Octet_String_T);

   // build the buffer
   octetString->length = *(NWLEN *) ptr;
   ptr += sizeof(NWLEN);

   octetString->data = (pnuint8) dataPtr;
   memcpy (octetString->data, ptr, octetString->length);

   // release byte[]
   (*env)->ReleaseByteArrayElements (env, values, byteArray, JNI_ABORT);

   // return buffer
   return ((nptr) octetString);

} /* toCStruct () */

