/* **************************************************************************

  $Archive:  $
  $Revision:  $
  $Modtime:  $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

#include <sys_api.h>

#include "jncpWire.h"

#include "NetPrintableStringJNI.h"


#ifdef __cplusplus
extern "C" {
#endif


/* public final class NetPrintableString
 *    extends NdsPrintableString
 *    implements NetAttributeValue, Serializable
 * {
 *    //
 *    protected int remoteId;
 *    protected String name;
 * }
 */

/***** NetAttrRecordJNI.h *************************************************/

N_GLOBAL_FUNC_C (pNetPrintableString)
NetPrintableStringCreateStruct
(
   JNIEnv *env
)
{
   //JNI variables
   jclass clsNetPrintableString;
   jclass clsNetPrintableStringLR;
   //NJCL variables
   pNetPrintableString sNetPrintableString;

   clsNetPrintableStringLR = (*env)->FindClass (env, NETSYNTAXPKG "NetPrintableString");
   clsNetPrintableString = (*env)->NewGlobalRef (env, clsNetPrintableStringLR);
   (*env)->DeleteLocalRef (env, clsNetPrintableStringLR);

   sNetPrintableString = (pNetPrintableString) sysMalloc (sizeof (NetPrintableString));

   if (NULL != sNetPrintableString)
   {
      // assign jclass variables
      sNetPrintableString->cls = clsNetPrintableString;

      // assign jfieldID variables
      sNetPrintableString->ID.value = (*env)->GetFieldID (env, clsNetPrintableString, "value", "Ljava/lang/String;");
   }
   return (sNetPrintableString);

} /* NetPrintableStringCreateStruct () */


N_GLOBAL_FUNC_C (jobject)
NetPrintableStringCreate
(
   JNIEnv *env,
   pNetPrintableString sNetPrintableString,
   pBuf_T buf
)
{
   ppnstr8 curPos = (ppnstr8) &buf->curPos;
   pnstr8 limit = (pnstr8) buf->data + (nuint) buf->curLen;

   jobject netPrintableString = (*env)->AllocObject (env, sNetPrintableString->cls);

   {
      jstring value;

      NAlign32 (curPos);
      (*env)->SetObjectField (
                                 env,
                                 netPrintableString,
                                 sNetPrintableString->ID.value,
                        (jobject)(value = jncpGetString (env, curPos, limit)));
      (*env)->DeleteLocalRef (env, value);
   }

   return (netPrintableString);

} /* NetPrintableStringCreate () */


#ifdef __cplusplus
}
#endif


