
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsAttributeValue.java $
  $Revision: 9 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import com.novell.service.schema.SchemaValue;


/**
 * Provides a common way of manipulating object values.
 *
 * <p>The NdsAttributeValue interface allows manipulation of all syntax
 * objects, and defines a common way of passing any syntax to an
 * interface that accepts NDS attribute values.
 */
public interface NdsAttributeValue extends SchemaValue
{
  /**
   * No syntax matching rules.
   *
   * <p>(none = 0)
   */
   public static final int none = 0;

  /**
   * Syntax matching rule for equality.
   *
   * <p>The equality matching rule requires two values to be
   * identical, to use the same attribute syntax, and to conform
   * to the data type of the attribute syntax.
   *
   * <p>(equality = 1)
   */
   public static final int equality = 1;

  /**
   * Approximate matching rule for comparing strings and
   * distinguished names.
   *
   * <p>The approximate comparison rule can be used in searches
   * and comparisons on syntaxes with lists of strings and syntaxes
   * with distinguished names.
   *
   * <p>(approximate = 2)
   */
   public static final int approximate = 2;

  /**
   * Syntax matching rule for ordering values.
   *
   * <p>The ordering matching rule requiring a syntax to be
   * open to comparisons of "less than," "equal to," and "greater
   * than."
   *
   * <p>(ordering = 4)
   */
   public static final int ordering = 4;

  /**
   * Syntax matching rule for substrings comparison.
   *
   * <p>The substrings matching rule requiring a syntax to be
   * open to search and comparison on patterns that include
   * the asterisk (*) wildcard.
   *
   * <p>(substrings = 8)
   */
   public static final int substrings = 8;

  /**
   *@internal 
   *
   *Converts 32-bit integer values to 64-bit integer values and
   * inhibits sign extend.
   * 
   * <p>(INT_MASK = 0xFFFFFFFFL)
   */
   public static final long INT_MASK = 0xFFFFFFFFL;

  /**
   * Compares two Objects for approximate equality.
   *
   * <p>Two values are approximately equal if and only if the
   * argument is not NULL and is a NdsAttributeValue object
   * that represents approximately the same attribute value
   * as this object.
   * 
   * @param anObject The object with which to compare.
   * @return Boolean set to TRUE if this object is approximately the
   *         same as the object argument; otherwise FALSE is returned.
   *
   * @exception NsiException Standard NJCL exception for working on
   *                         top of XPlat libraries.
   */
   public boolean approximate (
         Object anObject)
      throws Exception;

  /**
   * Returns the integer that represents the syntax ID.
   *
   * @return Int representing the Syntax ID.
   */
   public int getNdsSyntaxId ();

  /**
   * Returns a Boolean indicating whether the matching rules 
   * passed in are supported.
   *
   * @param matchingRules Syntax matching rules to be used.
   *
   * @return Boolean set to TRUE if the matching rules are
   *         supported, otherwise set to FALSE.
   */
   public boolean supportsMatchingRules (int matchingRules);

} /*  */


