
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsClassName.java $
  $Revision: 10 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


import java.io.Serializable;


/**
 * Provides access to attribute values of the Class Name syntax. 
 * It is used for attributes whose values are NDS object class names.
 *
 * <p>Two Class Names match for equality when their lengths and
 * corresponding characters are identical in all respcts except
 * for case and spaces. In matching attributes that conform to
 * this syntax, NDS omits those spaces that are not significant
 * (leading spaces, trailing spaces, and multiple consecutive
 * internal spaces). The Directory stores insignificant spaces
 * with the attribute value.
 *
 * <p>Matching Rules: Equality</p>
 *
 * @see NdsSyntaxId
 */
public class NdsClassName
   extends NdsString
   implements NdsAttributeValue, Cloneable, Serializable
{

   private static final int matchingRules = equality;

   /**
   * Constructs a NdsClassName object based on the specified
   * value parameter.
   * 
   * @param value The class name to be stored as a String value.
   */
   public NdsClassName (
         String value)
   {
      this.value = value;
   }

  /**
   * @internal
   */
   protected NdsClassName ()
   {

   }

   /*
    * Private constructor; not documented!
    */
   private NdsClassName (
         String name,
         String value)
   {
      super (name, value);
   }

  /**
   * @internal
   */
   protected NdsClassName (
         NdsClassName aClassName)
   {
      this.name = aClassName.name;
      this.value = aClassName.value;
   }


   // ******************** SchemaValue Interface ********************

  /**
   * Compares two objects for ordering, or compares two strings
   * lexicographically.
   *
   * The compareTo method does not apply to the NdsClassName syntax
   * because this syntax does not support the ordering and substrings
   * matching rules.
   */
   public int compareTo (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Compares two Objects for equality. The equals method compares
   * this object value with the value of the reference object in
   * the anObject parameter.
   *
   * <p>The equals method implements the most discriminating possible
   * equivalence relation on objects; that is, for any reference values
   * X and Y, this method returns TRUE if and only if X and Y refer to
   * the same object (X==Y has the value TRUE).</p>
   * 
   * @param anObject The reference object with which to compare.
   *
   * @return A boolean set to TRUE if and only if the argument is not
   *         NULL and is an NDS integer object that contains the
   *         same value as this object, otherwise set to FALSE.
   */
   public boolean equals (
         Object anObject)
   {
      if ((anObject != null) && (anObject instanceof NdsClassName))
      {
         NdsClassName anotherString = (NdsClassName) anObject;

         if (false == value.equals (anotherString.value))
         {
            return (false);
         }
         return (true);
      }
      return (false);
   }

  /**
   * @internal
   */
   public String getSyntaxId ()
   {
      return (NdsSyntaxId.CLASS_NAME);
   }


   // ******************** NdsAttributeValue Interface ********************

  /**
   * Compares two Objects using the approximate matching rule.
   * 
   * The approximate method does not apply to the NdsClassName
   * syntax because this syntax does not support the approximate
   * equals matching rule.
   */
   public boolean approximate (
         Object anObject)
      throws Exception
   {
      throw (new Exception ());
   }

  /**
   * Returns the int that represents the NDS syntax ID.
   *
   * @return The syntax ID as an int.
   */
   public int getNdsSyntaxId ()
   {
      return (NdsSyntaxId.CLASS_NAME_ID);
   }

  /**
   * Checks to see if this object supports the specified
   * matching rules.
   *
   * <p>The NdsClassName syntax supports only the equality
   * matching rule.
   *
   * @param matchingRules The set of matching rules to check.
   *
   * @return A Boolean set to TRUE if the matching rules for this
   *         object are equal to the matchingRules parameter.
   */
   public boolean supportsMatchingRules (
         int matchingRules)
   {
      if ((matchingRules & this.matchingRules) == matchingRules)
      {
         return (true);
      }
      return (false);
   }


   // ******************** Object Class ********************

  /**
   * Creates a new object of the same class as this object. It
   * then initializes each of the new object's fields by assigning
   * them the same value as the corresponding fields in this object.
   * No constructor is called.
   *
   * @return A clone of this object instance containing the cloned
   *         syntax.
   */
   public Object clone ()
   {
      NdsClassName string = (NdsClassName) super.clone ();

      return (string);

   } /* clone () */


   // ******************** NdsClassName Class ********************

  /**
   * Returns the String value stored in the object data member.
   * 
   * @return The stored String value.
   */
   public String getClassName ()
   {
      return (value);
   }

} /* NdsClassName */
