
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/NdsObjectRights.java $
  $Revision: 11 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds;


/**
 * Provides definitions of the effective rights for objects,
 * and methods for checking effective rights for an object.
 *
 * @see NdsRights
 */
public final class NdsObjectRights extends NdsRights
{
  /**
   * Allows a trustee to discover and view objects and their
   * subordinates in the NDS tree.
   *
   * <p>(DS_ENTRY_BROWSE = 0x1)
   */
   public static final int DS_ENTRY_BROWSE      = 0x1;

  /**
   * Allows a trustee to create new child objects subordinate
   * to an object in the tree.
   *
   * <p>This right is available only for objects that can
   * have subordinates, such as containers and volumes.
   *
   * <p>(DS_ENTRY_ADD         = 0x2)
   */
   public static final int DS_ENTRY_ADD         = 0x2;

  /**
   * Allows a trustee to delete an object.
   *
   * <p>Container objects that have subordinates cannot be
   * deleted until the subordinates are deleted. No property
   * right for the object can block this right.
   *
   * <p>(DS_ENTRY_DELETE      = 0x4)
   */
   public static final int DS_ENTRY_DELETE      = 0x4;

  /**
   * Allows a trustee to change the name of an object.
   *
   * <p>The value of the Name property is changed; however,
   * only the last part of the complete name can be changed
   * with this right. Changing other parts of the name implies
   * a move operation.
   *
   * <p>(DS_ENTRY_RENAME      = 0x8)
   */
   public static final int DS_ENTRY_RENAME       = 0x8;

  /**
   * Grants a trustee all rights to an object and its
   * attributes.
   *
   * <p>All rights include object, property, file or 
   * directory rights. In the case of a directory, the right
   * applies to all subordinate directories and files. The
   * trustee can grant any right to another user and modify
   * the Inherited Rights Filter. The Supervisor right cannot
   * be filtered on a file or directory, but it can be 
   * filtered on an object or property.
   *
   * <p>(DS_ENTRY_SUPERVISOR  = 0x10)
   */
   public static final int DS_ENTRY_SUPERVISOR  = 0x10;

  /**
   * Allows a trustee to inherit the rights granted in the
   * ACL, and exercise these rights on subordinate objects.
   *
   * <p>(DS_ENTRY_INHERIT_CTL = 0x40)
   */
   public static final int DS_ENTRY_INHERIT_CTL = 0x40;

  /**
   * Constructs an NdsObjectRights object and sets the 
   * object effective rights.
   *
   * @param rights The object effective rights as
   *               defined by the above variables.
   */
   public NdsObjectRights(int rights)
   {
		this.rights = rights;
   }

  /**
   * Checks to see if an object has browse rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the browse rights status.
   *
   * @return A Boolean set to TRUE if the object has browse
   *         rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasBrowse()
   {
      return ((getRights() & DS_ENTRY_BROWSE) != 0);
   }

  /**
   * Checks to see if an object has add rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the add rights status.
   *
   * @return A Boolean set to TRUE if the object has add
   *         rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasAdd()
   {
      return ((getRights() & DS_ENTRY_ADD) != 0);
   }

  /**
   * Checks to see if an object has delete rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the delete rights status.
   *
   * @return A Boolean set to TRUE if the object has delete
   *         rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasDelete()
   {
      return ((getRights() & DS_ENTRY_DELETE) != 0);
   }

  /**
   * Checks to see if an object has rename rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the rename rights status.
   *
   * @return A Boolean set to TRUE if the object has rename
   *         rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasRename()
   {
      return ((getRights() & DS_ENTRY_RENAME) != 0);
   }

  /**
   * Checks to see if an object has supervisor rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the supervisor rights status.
   *
   * @return A Boolean set to TRUE if the object has supervisor
   *         rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasSupervisor()
   {
      return ((getRights() & DS_ENTRY_SUPERVISOR) != 0);
   }

  /**
   * Checks to see if an object has inherit CTL rights.
   *
   * <p>Calls getRights() for the current object and then
   * checks the inherit CTL rights status.
   *
   * @return A Boolean set to TRUE if the object has inherit
   *         CTL rights, otherwise set to FALSE.
   *
   * @see NdsRights#getRights()
   */
   public boolean hasInheritCtl()
   {
      return ((getRights() & DS_ENTRY_INHERIT_CTL) != 0);
   }

} /* NdsObjectRights */




