/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/ldap/LdapTime.java $
  $Revision: 4 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.nds.ldap;

import com.novell.service.nds.*;

/**
@internal
LdapTime is an Adapter for NdsTime.
*/
public final class LdapTime
   extends NdsTime
   implements LdapAttributeValue
{

   /**
   * Constructs an LdapTime adapter for an NdsTime.
   *
   * @param   value     Ldap string representation of Time.
   */
   protected LdapTime (
         String value)
      throws Exception
   {
      this.value = Integer.parseInt(value);
   }

   /**
   * Constructs an LdapTime adapter for an NdsTime.
   *
   * @param   value     an NdsTime object.
   */
   protected LdapTime (NdsTime value)
   {
      super (value);
   }

   /**
   * Returns an Ldap string representation of Time.
   *
   * @return   String containing Ldap string representation of Time.
   */
   public String String ()
   {
      return String.valueOf(this.value);
   }
}

