
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/NdsName.java $
  $Revision: 14 $
  $Modtime: 11/12/03 4:37p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming;


import java.util.*;

import javax.naming.*;

import com.novell.service.jncpv2r.net.NetService;

import com.novell.utility.naming.Syntax;


/** @internal
 *
 */
public class NdsName extends CompoundName
{
   private Syntax syntax;

   /**
    *
    */
   protected NdsName (Enumeration comps, Syntax syntax)
   {
      super (comps, syntax.getProperties ());

      this.syntax = syntax;
   }

   /**
    *
    */
   public NdsName (String name, Syntax syntax)
      throws InvalidNameException
   {
      super ("", syntax.getProperties ());

      int i = 0;
      int length = name.length ();
      Vector components = new Vector ();
      NdsNameUtility utility = new NdsNameUtility (syntax);

      while (i < length)
      {
         i = utility.stringToComponent (name, i, length, components);
      }

      addAll (new NdsName (components.elements (), syntax));

      this.syntax = syntax;

   } /*  */


   /**
    *
    */
   public void setSyntax (Syntax syntax)
      throws NamingException
   {
      this.syntax = syntax;
   }

   /**
    *
    */
   public NdsName getTypelessName ()
      throws NamingException
   {
      NdsName ndsName = new NdsName ("", syntax);
      Enumeration enum = getAll ();
      String element, typeSep;
      char escapeChar = 0;
      int index;

      if ((typeSep = syntax.getTypevalSeparator ()) == null)
      {
         throw (new InvalidNameException ());
      }

      String escapeStr = syntax.getEscape ();

      if (escapeStr != null)
      {
         escapeChar = escapeStr.charAt (0);
      }

      while (enum.hasMoreElements ())
      {
         element = (String) enum.nextElement ();

         // remove type (if one exists)
         if ((index = element.indexOf (typeSep)) != -1)
         {
            // make sure it's not escaped
            if (index > 0 && element.charAt (index - 1) != escapeChar)
            {
               element = element.substring (index + 1);
            }
         }
         ndsName.add (element);
      }
      return (ndsName);

   } /* getTypelessName () */

   /**
    *
    */
   public String getCanonicalString ()
      throws NamingException
   {
      if (this.isEmpty ())
      {
         return ("[Root]");
      }

      int i = 0;
      int size = this.size ();
      String separator = syntax.getSeparator ();
      StringBuffer answer = new StringBuffer (NetService.MAX_DN_CHARS);

      do
      {
         answer = answer.append (this.get (size - 1 - i++));

      } while (i < size && answer.append (separator) != null);

      return (new String (answer));

   } /* getCanonicalString () */


   // ******************** Name Interface ********************

   /**
    *
    */
   public int compareTo (
         Object object)
   {
      if (!(object instanceof NdsName))
      {
         throw (new ClassCastException ("!(object instanceof NdsName)"));
      }
      return (super.compareTo (object));

   } /* compareTo () */

   /**
    *
    */
   public Name getPrefix (
         int posn)
   {
      return (new NdsName (super.getPrefix (posn).getAll (), syntax));
   }

   /**
    *
    */
   public Name getSuffix (
         int posn)
   {
      return (new NdsName (super.getSuffix (posn).getAll (), syntax));
   }

   /**
    *
    */
   public boolean startsWith (
         Name name)
   {
      if (name instanceof NdsName)
      {
         return (super.startsWith (name));
      }
      else
      {
         return (false);
      }

   } /* startsWith () */

   /**
    *
    */
   public boolean endsWith (
         Name name)
   {
      if (name instanceof NdsName)
      {
         return (super.endsWith (name));
      }
      else
      {
         return (false);
      }

   } /* endsWith () */

   /**
    *
    */
   public Name addAll (
         Name suffix)
      throws InvalidNameException
   {
      if (suffix instanceof NdsName)
      {
         return (super.addAll (suffix));
      }
      else
      {
         throw new InvalidNameException (suffix.toString ());
      }

   } /* addAll () */

   /**
    *
    */
   public Name addAll (
         int position,
         Name name)
      throws InvalidNameException
   {
      if (name instanceof NdsName)
      {
         return (super.addAll (position, name));
      }
      else
      {
         throw (new InvalidNameException (name.toString ()));
      }

   } /* addAll () */

   // ******************** Object Class ********************

   /**
    *
    */
   public Object clone ()
   {
      return (new NdsName (getAll (), syntax));
   }

   /**
    *
    */
   public boolean equals (
         Object object)
   {
//NOTE: check syntax
      return (object != null &&
         object instanceof NdsName &&
         super.equals (object));
    }

    // NOTE: this method overwrites its superclass' toString() method. It
    // will not make quotations around the name components that have dot(s)
    // in it. See DEFECT000331738

    public String toString() {
        
        int       size = size();
        String    s  = new String("");
        
        if (size != 0) {        
            for(int i = size-1; i >= 0; i--) {
                if(i != 0) {
                    s += get(i) + ".";
                }
                else {
                    s += get(i);
                }
            }
        }

        return s;
    }

} /* NdsName */
