
/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/nds/naming/net/NetAliasDirContext.java $
  $Revision: 9 $
  $Modtime: 1/05/01 3:59p $

  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.naming.net;


import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

import com.sun.jndi.toolkit.ctx.Continuation;

import com.novell.service.nds.NdsObjectInfo;
import com.novell.service.nds.naming.NdsName;

import com.novell.service.jncpv2r.net.BasicNetService;
import com.novell.service.jncpv2r.net.AliasNetService;
import com.novell.service.jncpv2r.net.NetObjectInfo;


/**@internal
 *
 */
public class NetAliasDirContext extends NetDirContext
{
   /**
    *
    */
   protected NetAliasDirContext (
         String objectName,
         NdsObjectInfo objectInfo,
         NetEnvironment environment)
      throws NamingException
   {
      super (objectName, objectInfo, environment);

      this.environment.setServiceKey (AliasNetService.KEY);
   }


   // ******************** ComponentContext Interface ********************

   /**
    * Retrieves the named object.
    */
   protected Object c_lookup (
         Name name,
         Continuation cont)
      throws NamingException
   {
      try
      {
         Context context;
         NetEnvironment environment;

         environment = (NetEnvironment) this.environment.clone ();
         environment.setServiceKey (BasicNetService.KEY);

         if (name.isEmpty ())
         {
            context = factory.getContextInstance (
                                 getNameInstance ().getCanonicalString (),
                                 environment);
         }
         else
         {
            NdsName target;

            target = (NdsName) name.clone ();
            target.addAll (0, getNameInstance ());

            context = factory.getContextInstance (
                                 target.getCanonicalString (),
                                 environment);
         }
/*
         if (object != null && object instanceof LinkRef)
         {
            cont.setContinue (object, this);
            return (null);
         }
*/
         cont.setSuccess ();
         return (context);
      }
      catch (NamingException e)
      {
         cont.setError (this, name.toString ());
         throw (cont.fillInException (e));
      }

   } /* c_lookup () */

   /**
    *
    */
   protected Object c_lookupLink (
         Name name,
         Continuation cont)
      throws NamingException
   {
      try
      {
         Context context;

         if (name.isEmpty ())
         {
            context = factory.getContextInstance (
                                 getNameInstance ().getCanonicalString (),
                                 objectInfo,
                                 environment);
         }
         else
         {
            NdsName target;
            NetEnvironment environment;

            environment = (NetEnvironment) this.environment.clone ();
            environment.setServiceKey (BasicNetService.KEY);

            target = (NdsName) name.clone ();
            target.addAll (0, getNameInstance ());

            context = factory.getContextInstance (
                                 target.getCanonicalString (),
                                 environment);
         }
/*
         if (context != null && context instanceof LinkRef)
         {
            cont.setContinue (context, this);
            return (null);
         }
*/
         cont.setSuccess ();
         return (context);
      }
      catch (NamingException e)
      {
         cont.setError (this, name.toString ());
         throw (cont.fillInException (e));
      }

   } /* c_lookupLink () */

} /* NetAliasDirContext */


