
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetNumericString.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsNumericString;


/** @internal
 * NetNumericString is an Adapter for NdsNumericString.
 *
 * This class converts to/from the NWNet NU_String_T.
 *
 * API Data Structure:
 *    typedef pnchar NU_String_T;
 */
public final class NetNumericString
   extends NdsNumericString implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Numeric String from the "API Data Structure".
    *
    * @param   value   byte[] containing a NU_String_T
    */
   protected NetNumericString (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetNumericString adapter for an NdsNumericString.
    *
    * @param   value   an NdsNumericString object.
    */
   protected NetNumericString (
         NdsNumericString value)
   {
      super (value);
   }

   /**
    * Returns a Numeric String "API Data Structure".
    *
    * @return   byte[] containing NU_String_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetNumericString */


