
/* **************************************************************************
  $Archive: /njcl_v2rmi/src/com/novell/service/nds/net/NetPrintableString.java $
  $Revision: 8 $
  $Modtime: 11/15/00 3:43p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nds.net;


import java.io.*;

import com.novell.java.io.EndianInputStream;
import com.novell.java.io.EndianOutputStream;

import com.novell.service.jncp.NSIException;

import com.novell.service.nds.NdsPrintableString;


/** @internal
 * NetPrintableString is an Adapter for NdsPrintableString.
 *
 * This class converts to/from the NWNet PR_String_T.
 * 
 * API Data Structure:
 *    typedef pnchar PR_String_T;
 */
public final class NetPrintableString
   extends NdsPrintableString implements NetAttributeValue, Serializable
{
   /**
    * Constructs a Printable String from the "API Data Structure".
    * 
    * @param   value   byte[] containing a PR_String_T
    */
   protected NetPrintableString (
         byte[] value)
      throws NSIException
   {
      try
      {
         EndianInputStream edis = new EndianInputStream (value);

         this.value = edis.readLoHiChars ();
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

   /**
    * Constructs a NetPrintableString adapter for an NdsPrintableString.
    * 
    * @param   value   an NdsPrintableString object.
    */
   protected NetPrintableString (
         NdsPrintableString value)
   {
      super (value);
   }

   /**
    * Returns a Printable String "API Data Structure".
    * 
    * @return   byte[] containing PR_String_T.
    */
   public byte[] toByte ()
      throws NSIException
   {
      try
      {
         ByteArrayOutputStream baos = new ByteArrayOutputStream ();
         EndianOutputStream eos = new EndianOutputStream (baos);

         eos.writeLoHiChars (this.value);
         return (baos.toByteArray ());
      }
      catch (IOException e)
      {
         NSIException ne = new NSIException ();

         ne.setRootCause (e);
         throw (ne);
      }
   }

} /* NetPrintableString */


