/* **************************************************************************

  $Archive: /njcl_v2/src/com/novell/service/nw/NetWareStrings.java $
  $Revision: 5 $
  $Modtime: 10/19/99 4:34p $
 
  Copyright (c) 1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/

package com.novell.service.nw;

/** @internal
*  Repository for common strings
*/
public interface NetWareStrings
{
   /**
   * ROOT = "root"
   */
   public final static String ROOT = "[Root]";

   /**
   * Binding name. TREES = "Trees"
   */
   public final static String TREES = "Trees";

   /**
   * Binding name. SERVERS = "Servers"
   */
   public final static String SERVERS = "Servers";

   public final static String NDS_SCHEME = "NDS";
   public final static String SERVER_SCHEME = "Server";

   /**
   * Syntax direction for NetWare name space. NETWARE_SYNTAX_DIRECTION = 
   * "left_to_right"
   */
   public final static String NETWARE_SYNTAX_DIRECTION = "left_to_right";

   /**
   * Separator character for NetWare name space. NETWARE_SYNTAX_SEPARATOR = /
   */
   public final static String NETWARE_SYNTAX_SEPARATOR = "/";

   /**
   * Escape character for NetWare name space. NETWARE_SYNTAX_ESCAPE = \
   */
   public final static String NETWARE_SYNTAX_ESCAPE = "\\";

   /**
   * Begin quote character for NetWare name space. NETWARE_SYNTAX_BEGIN_QUOTE
   *  = "
   */
   public final static String NETWARE_SYNTAX_BEGIN_QUOTE = "\"";

   /**
   * Begin quote 2 character for NetWare name space. 
   * NETWARE_SYNTAX_BEGIN_QUOTE2 = '
   */
   public final static String NETWARE_SYNTAX_BEGIN_QUOTE2 = "'";
}