/* **************************************************************************

  $Archive: /njcl/src/com/novell/service/schema/SchemaNumber.java $
  $Revision: 3 $
  $Modtime: 4/08/98 2:03p $
 
  Copyright (c) 1997-1998 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

*****************************************************************************/

package com.novell.service.schema;

//##begin module.additionalImports preserve=no
//##end module.additionalImports

//##begin module.imports preserve=yes
//##end module.imports



// ==================================================================

//##begin module.declarations preserve=no
//##end module.declarations

//##begin module.additionalDeclarations preserve=yes
//##end module.additionalDeclarations

/** @internal
The SchemaNumber syntax is used for attributes whose values represent
an int, a long, a float, a double, a byte, or a short.
*/
public interface SchemaNumber extends SchemaValue {
    //##begin SchemaNumber.initialDeclarations preserve=yes
    //##end SchemaNumber.initialDeclarations


    /**
    Returns the value of this SchemaNumber object as an int.
    
    @return  int value of this object.
    */
    public int intValue();

    /**
    Returns the value of this SchemaNumber object as a long.

    @return  long value of this object.
    */
    public long longValue();

    /**
    Returns the value of this SchemaNumber object as a float.

    @return  float value of this object.
    */
    public float floatValue();

    /**
    Returns the value of this SchemaNumber object as a double.

    @return  double value of this object.
    */
    public double doubleValue();

    /**
    Returns the value of this SchemaNumber object as a byte.
    
    @return  byte value of this object.
    */
    public byte byteValue();

    /**
    Returns the value of this SchemaNumber object as a short.
    
    @return  short value of this object.
    */
    public short shortValue();

    //##begin SchemaNumber.additionalDeclarations preserve=yes
    //##end SchemaNumber.additionalDeclarations

}

