/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/bindery/BinderyShibboleth.java $
  $Revision: 23 $
  $Modtime: 5/15/03 4:48p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.bindery;

import java.rmi.RemoteException;
import com.novell.service.session.xplat.ShibbolethRemote.NMASAndFDN;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.SessionException;
import com.novell.service.session.spi.*;
import com.novell.service.session.xplat.Connection;
import com.novell.service.session.xplat.ShibbolethImpl;
import com.novell.service.session.xplat.Natives;
import com.novell.service.session.xplat.XplatUtil;
import com.novell.service.session.util.Debug;

/** @internal
 * @deprecated Use com.novell.service.security and related packages.
 */
public class BinderyShibboleth extends ShibbolethImpl
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;
   final static private boolean I_DEBUG = false; // Ignore exception
   final static private boolean LOGOUT_DEBUG = false;
   final static private boolean S_DEBUG = false; // May have side effects

   protected static final String KEY = ShibbolethImpl.KEY;

   SessionImpl session;

   BinderyShibboleth(SessionImpl sess, RMISocketFactories x)
   throws SessionException, RemoteException
   {
      super(x);
      this.session = sess;
   }

   BinderyShibboleth(SessionImpl sess)
   throws SessionException, RemoteException
   {
      this.session = sess;
   }

   public void changePassword
   (
      String userName,
      String oldPassword,
      String newPassword,
      boolean unusedFlag
   )
   throws SessionException, RemoteException
   {
      if(unusedFlag)
         throw new SessionException(com.novell.java.security.I2L.getString(
            com.novell.java.security.XMsg.CONFIGURATION));
      getConnection().
         changePassword(userName, oldPassword, newPassword);
   }

   public void setPassword
   (
      String objName,
      String password,
      boolean unusedFlag
   )
   throws SessionException, RemoteException
   {
      if(unusedFlag)
         throw new SessionException(com.novell.java.security.I2L.getString(
            com.novell.java.security.XMsg.CONFIGURATION));
      getConnection().
         setPassword(objName, Natives.OT_USER, password);
   }

   public void verifyPassword
   (
      String objName,
      String password,
      boolean unusedFlag
   )
   throws SessionException, RemoteException
   {
      if(unusedFlag)
         throw new SessionException(com.novell.java.security.I2L.getString(
            com.novell.java.security.XMsg.CONFIGURATION));
      getConnection().
         verifyPassword(objName, Natives.OT_USER, password);
   }

   public void authenticate
   (
      String userName,
      String password,
      boolean unusedFlag
   )
   throws SessionException, RemoteException
   {
      if(unusedFlag)
         throw new SessionException(com.novell.java.security.I2L.getString(
            com.novell.java.security.XMsg.CONFIGURATION));
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("BS.authenticate()");
      }
      getConnection().
         login(userName, password);
   }

   public NMASAndFDN authenticateNAS
   (
      String userName,
      String password,
      boolean unusedFlag
   )
   throws SessionException, RemoteException
   {
      throw new SessionException(com.novell.java.security.I2L.getString(
         com.novell.java.security.XMsg.INVALID_AUTHENTICATOR_PROTOCOL));
   }

   public void authenticateService
   (
      String serviceName
   )
   throws SessionException
   {
      throw new SessionException(com.novell.java.security.I2L.getString(
         com.novell.java.security.XMsg.INVALID_AUTHENTICATOR_PROTOCOL));
   }

   public void unauthenticate
   (
   )
   throws SessionException, RemoteException
   {
      if (DEBUG || LOGOUT_DEBUG)
      {
         Debug.println("BS.unauthenticate()");
      }
      getConnection().
         logout();
   }

   public void unauthenticateNAS
   (
      int nmasID
   )
   throws SessionException, RemoteException
   {
      throw new SessionException(com.novell.java.security.I2L.getString(
         com.novell.java.security.XMsg.INVALID_AUTHENTICATOR_PROTOCOL));
   }

   private Connection getConnection
   (
   )
   throws SessionException, RemoteException
   {
      BinderyServerSessionState state = (BinderyServerSessionState)session.getState();
      return state.connection;
   }
}
