/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/spi/Children.java $
  $Revision: 9 $
  $Modtime: 11/16/00 2:32p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import java.rmi.RemoteException;
import java.util.Vector;
import java.util.Enumeration;
import java.io.*;
import com.novell.service.session.SessionException;

/** @internal
 */
public class Children
{
   // if true, go to the trouble of verifying that both vector's are
   // in synch when it matters
   final static private boolean ROBUST = true;

   Vector children;
   Vector childrenNames;

   public Children(int initialCapacity,
                  int capacityIncrement)
   {
      children       = new Vector(initialCapacity, capacityIncrement);
      childrenNames  = new Vector(initialCapacity, capacityIncrement);
   }

   public Children(int initialCapacity)
   {
      this(initialCapacity, 1);
   }

   public Children()
   {
      this(0, 1);
   }

//   public final synchronized void addChild(
   public final void addChild(SessionImpl session)
   throws SessionException, RemoteException
   {
      addChild(session, session.getDomainName());
   }

//   public final synchronized void addChild(
   public final void addChild(SessionImpl session, String name)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.addElement(session);
      childrenNames.addElement(name);
   }

//   synchronized public boolean contains(SessionImpl session)
   public boolean contains(SessionImpl session)
   throws SessionException
   {
      return children.contains(session);
   }

//   synchronized public boolean contains(String name)
   public boolean contains(String name)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return childrenNames.contains(name);
   }

   public final void copySessionsInto(Object[] objArray)
   {
      children.copyInto(objArray);
   }

   public final void copyNamesInto(Object[] objArray)
   {
      childrenNames.copyInto(objArray);
   }

//   public final synchronized SessionImpl sessionAt(int index)
   public final SessionImpl sessionAt(int index)
   throws SessionException
   {
      return (SessionImpl)children.elementAt(index);
   }

//   public final synchronized String nameAt(int index)
   public final String nameAt(int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return (String)childrenNames.elementAt(index);
   }

//   public final synchronized Enumeration sessions()
   public final Enumeration sessions()
   throws SessionException
   {
      return new com.novell.java.util.VectorEnumerator(children);
      //return children.elements(); this is not serializable
   }

//   public final synchronized Enumeration names()
   public final Enumeration names()
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return childrenNames.elements();
   }

//   public final synchronized void ensureCapacity(int minCapacity)
   public final void ensureCapacity(int minCapacity)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.ensureCapacity(minCapacity);
      childrenNames.ensureCapacity(minCapacity);
   }

//   public final synchronized SessionImpl firstSession()
   public final SessionImpl firstSession()
   throws SessionException
   {
      return (SessionImpl)children.firstElement();
   }

//   public final synchronized String firstName()
   public final String firstName()
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return (String)childrenNames.firstElement();
   }

   public final int indexOf(SessionImpl session)
   throws SessionException
   {
      return children.indexOf(session);
   }

   public final int indexOf(String name)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return childrenNames.indexOf(name);
   }

//   public final synchronized int indexOf(SessionImpl session, int index)
   public final int indexOf(SessionImpl session, int index)
   throws SessionException
   {
      return children.indexOf(session, index);
   }

//   public final synchronized int indexOf(String name, int index)
   public final int indexOf(String name, int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return childrenNames.indexOf(name, index);
   }

//   public final synchronized void insertSessionAt(SessionImpl session, String name, int index)
   public final void insertSessionAt(SessionImpl session, String name, int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.insertElementAt(session, index);
      childrenNames.insertElementAt(name, index);
   }

//   public final synchronized boolean isEmpty()
   public final boolean isEmpty()
   {
      return children.isEmpty();
   }

//   public final synchronized SessionImpl lastSession()
   public final SessionImpl lastSession()
   throws SessionException
   {
      return (SessionImpl)children.lastElement();
   }

//   public final synchronized String lastName()
   public final String lastName()
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return (String)childrenNames.lastElement();
   }

//   public final synchronized int lastIndexOf(SessionImpl session, int index)
   public final int lastIndexOf(SessionImpl session, int index)
   {
      return children.lastIndexOf(session, index);
   }

//   public final synchronized int lastIndexOf(String name, int index)
   public final int lastIndexOf(String name, int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      return childrenNames.lastIndexOf(name, index);
   }

//   public final synchronized void removeAllChildren()
   public final void removeAllChildren()
   throws SessionException
   {
      children.removeAllElements();
      childrenNames.removeAllElements();
   }

//   public final synchronized boolean removeChild(SessionImpl session)
   public final boolean removeChild(SessionImpl session)
   throws SessionException, RemoteException
   {
      int index = indexOf(session);
      if (-1 == index)
         return false;
      removeChildAt(index);
      return true;
   }

//   public final synchronized boolean removeChild(String name)
   public final boolean removeChild(String name)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      int index = indexOf(name);
      if (-1 == index)
         return false;
      removeChildAt(index);
      return true;
   }

//   public final synchronized void removeChildAt(int index)
   public final void removeChildAt(int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.removeElementAt(index);
      childrenNames.removeElementAt(index);
   }

//   public final synchronized void setChildAt(SessionImpl session, int index)
   public final void setChildAt(SessionImpl session, int index)
   {
      children.setElementAt(session, index);
   }

//   public final synchronized void setChildAt(String name, int index)
   public final void setChildAt(String name, int index)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      childrenNames.setElementAt(name, index);
   }

//   public final synchronized void setSize(int newSize)
   public final void setSize(int newSize)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.setSize(newSize);
      childrenNames.setSize(newSize);
   }

//   public final synchronized String toString()
   public final String toString()
   {
      return children.toString() + " : " + childrenNames.toString();
   }

//   public final synchronized void trimToSize()
   public final void trimToSize()
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      children.trimToSize();
      childrenNames.trimToSize();
   }

//   public final synchronized int size()
   public final int size()
   throws SessionException
   {
      return children.size();
   }

//   public final synchronized void checkIntegrity()
   public final void checkIntegrity()
   throws SessionException, RemoteException
   {
      // Check for problems...
      if (children.size() != childrenNames.size())
      {
         rebuild();
         // Check for problems...
         if (children.size() != childrenNames.size())
            throw new SessionException("Children elements mismatched");
      }
   }

//   public final synchronized void rebuild()
   public final void rebuild()
   throws SessionException, RemoteException
   {
      childrenNames.removeAllElements();
      Enumeration enum = children.elements();
      while (enum.hasMoreElements())
      {
         SessionImpl session = (SessionImpl)enum.nextElement();
         childrenNames.addElement(session.getDomainName());
      }
   }

//   public final synchronized SessionImpl get(String name)
   public final SessionImpl get(String name)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      SessionImpl session = null;
      int index = indexOf(name);
      if (-1 != index)
         session = sessionAt(index);
      return session;
   }

//   public final synchronized String get(SessionImpl session)
   public final String get(SessionImpl session)
   throws SessionException, RemoteException
   {
      // Check that we're still in synch
      if (ROBUST)
         checkIntegrity();

      String name = null;
      int index = indexOf(session);
      if (-1 != index)
         name = nameAt(index);
      return name;
   }
}


