/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/spi/RMISocketFactories.java $
  $Revision: 3 $
  $Modtime: 1/12/01 5:07p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import java.rmi.server.*;

/**
* This class allows the user to specify the custom sockets they want a
* particular SessionManager (and all objects returned by it) to use.
* Use the SessionEnv.RMI_SOCKET_FACTORIES_OBJECT key and this object
* in the SessionEnv you pass in when you create your SessionManager.
*/
public class RMISocketFactories
{
   private int port;
   private RMIClientSocketFactory clientSocketFactory;
   private RMIServerSocketFactory serverSocketFactory;

   public RMISocketFactories
   (
      int port,
      RMIClientSocketFactory clientSocketFactory,
      RMIServerSocketFactory serverSocketFactory
   )
   {
      this.port = port;
      this.clientSocketFactory = clientSocketFactory;
      this.serverSocketFactory = serverSocketFactory;
   }
   
   public int getPort()
   {
      return port;
   }
   
   public RMIClientSocketFactory getClientSocketFactory()
   {
      return clientSocketFactory;
   }
   
   public RMIServerSocketFactory getServerSocketFactory()
   {
      return serverSocketFactory;
   }
}
