/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/spi/SessionManagerServiceDaemon.java $
  $Revision: 14 $
  $Modtime: 1/05/01 4:03p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.spi;

import com.novell.service.jncpv2r.clx.*;
import com.novell.service.session.*;
import com.novell.service.session.spi.*;
import com.novell.service.session.util.Debug;

/** @internal
 * Implements SessionManager
 */
public class SessionManagerServiceDaemon
implements Runnable
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
	final static private boolean DEBUG = false;
	final static private boolean S_DEBUG = false; // May have side effects

   SessionManager sessionManager;
   public SessionManagerServiceDaemon
   (
      SessionManager sessionManager
   )
   {
      this.sessionManager = sessionManager;
   }

   public void run()
   {
      while (true)
      {
         try
         {
            if (DEBUG)
            {
	            Debug.println("SMSDaemon.run(): validate links begin");
            }
            sessionManager.validateLinks();
            if (DEBUG)
            {
	            Debug.println("SMSDaemon.run(): validate links end");
            }
            Thread.sleep(5000);
         }
         catch (SessionException e)
         {
            throw new SessionRuntimeException(
               "SMSDaemon.run(): update thread session exception", e);
         }
         catch (InterruptedException e)
         {
            throw new SessionRuntimeException(
               "SMSDaemon.run(): update thread interrupted", e);
         }
         catch (Exception e)
         {
            throw new SessionRuntimeException(
               "SMSDaemon.run(): update thread unexpected exception", e);
         }
      }
   }
}

