/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/DomainName.java $
  $Revision: 10 $
  $Modtime: 8/17/01 12:58p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

/** @internal
 * DomainName.
 */

/*
 * Public Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * xxx   xxx - xxx.
 *
 * Protected Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * xxx   xxx - xxx.
 *
 * Private Method List (in order of their apperance in the file).
 *
 * CTD   Method name - Description
 * ---   --------------------------------------------------------------------
 * xxx   xxx - xxx.
 */

public class DomainName
{
   // Always access debug via final static...hopefully a final static of
   // false will be optimized out by the compiler
   final static private boolean DEBUG = false;

   public final static int  MAX_DOMAIN_NAME_CHARS           =  32;

   //************************************************************************
   // Class Methods
   //************************************************************************

   /**
    * Appends trailing underscores.
    *
    * @param   <i>domainName</i>   (in) xxx.
    *
    * @return                    xxx.
    */
    /*
   public static String pad
   (
      String domainName
   )
   {
      StringBuffer domainNameBuffer = new StringBuffer (domainName);
      int length = domainNameBuffer.length ();

      // convert spaces to underscores in domainName 
      for (int i = 0; i < length; i++)
      {
         if (' ' == domainNameBuffer.charAt (i))
         {
            domainNameBuffer.setCharAt (i, '_');
         }
      }
      // append underscores to domainName 
      for (int i = length; i < (MAX_DOMAIN_NAME_CHARS); i++)
      {
         domainNameBuffer.append ("_");
      }
      return (domainNameBuffer.toString ());

   } // pad () 
   */

   /**
    * Removes trailing underscores and cuts off munged garbage over 32
    * chacters (remnents from the SAP world) from tree names.
    * DO NOT CALL THIS ON A SERVER NAME. THEY CAN BE LONGER THAN 32 chars.
    *
    * @param   <i>domainName</i>   (in) xxx.
    *
    * @return                    xxx.
    */
   public static String strip
   (
      String domainName
   )
   {
      if (null != domainName)
      {
         int i;
         StringBuffer domainNameBuffer = new StringBuffer (domainName);

         if(domainNameBuffer.length() > MAX_DOMAIN_NAME_CHARS)
         {
            domainNameBuffer.setLength(MAX_DOMAIN_NAME_CHARS);
         }
         /* remove trailing underscores */
         i = domainNameBuffer.length ();
         while (i > 0 && '_' == domainNameBuffer.charAt (i - 1))
         {
            i--;
         }
         domainNameBuffer.setLength (i);
         return (domainNameBuffer.toString ());
      }
      return null;

   } /* strip () */

   /**
    * Removes trailing underscores only
    * @param   <i>domainName</i>   (in) xxx.
    * @return                    xxx.
    */
   public static String stripUnderscores
   (
      String domainName
   )
   {
      if (null != domainName)
      {
         StringBuffer domainNameBuffer = new StringBuffer (domainName);
         int i = domainNameBuffer.length ();
         while (i > 0 && '_' == domainNameBuffer.charAt (i - 1))
         {
            i--;
         }
         domainNameBuffer.setLength (i);
         return (domainNameBuffer.toString ());
      }
      return null;

   }

   /**
    * Removes NDS qualifiers.
    *
    * @param   <i>domainName</i>   (in) xxx.
    *
    * @return                    xxx.
    */
   public static String stripQualifiers
   (
      String domainName
   )
   {
      if (null != domainName)
      {
         int start, index;

         if (DEBUG)
            com.novell.service.session.util.Debug.println("FROM: " + domainName);

         start = 0;
         // ignore leading dots
         while (domainName.charAt(start) == '.')
            start++;

         // remove trailing qualifiers (everything right of first dot
         index = domainName.indexOf('.', start);
         if (-1 != index)
            domainName = domainName.substring(start, index);
         else
            domainName = domainName.substring(start);

         // remove leading qualifiers (ex: CN=)
         start = 0;
         index = domainName.indexOf('=');
         if (index != -1) start = index+1;

         if (DEBUG)
            com.novell.service.session.util.Debug.println("TO: " + domainName.substring(start));

         return (domainName.substring(start));
      }
      return null;

   } /* stripQualifiers () */

   /**
    * Removes NDS types.
    *
    * @param   <i>domainName</i>   (in) xxx.
    *
    * @return                    xxx.
    */
   public static String stripTypes
   (
      String domainName
   )
   {
      if (null != domainName)
      {
         int start, index;

         if (DEBUG)
            com.novell.service.session.util.Debug.println("FROM: " + domainName);

         start = 0;
         // ignore leading dots
         while (domainName.charAt(start) == '.')
            start++;

         index = start;
         StringBuffer newName = new StringBuffer();
         do
         {
            // Copy up to .
            if (domainName.charAt(index) == '.')
            {
               newName.append(domainName.substring(start, index));
               start = index++;
            }
            // Copy starting after =
            else if (domainName.charAt(index) == '=')
            {
               start = ++index;
            }
            // All others, keep moving through string
            else
               index++;
         } while(index < domainName.length());
         // Get leftover string
         if (index >= start)
            newName.append(domainName.substring(start, index));

         return (newName.toString());
      }
      return null;

   } /* stripTypes () */
} /* DomainName */