/* **************************************************************************

  $Archive: /njcl_v2rmi/src/com/novell/service/session/xplat/ShibbolethImpl.java $
  $Revision: 13 $
  $Modtime: 5/15/03 5:54p $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
  TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
  COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
  EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
  OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
  CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.service.session.xplat;

import java.rmi.*;
import java.math.*;
import java.security.*;
import javax.crypto.*;
import javax.crypto.spec.*;
import java.rmi.server.UnicastRemoteObject;
import com.novell.service.session.xplat.ShibbolethRemote.NMASAndFDN;
import com.novell.service.security.NdsIdentity;
import com.novell.service.session.SessionException;
import com.novell.service.session.spi.RMISocketFactories;

/**@internal
 * @deprecated Use com.novell.service.security and related packages.
 */
public abstract class ShibbolethImpl extends UnicastRemoteObject
implements ShibbolethRemote
{
   /*
    * The key used to generate an object of this type via the
    * Session.getService() interface.
    */
   public static final String KEY =
      "com.novell.service.session.xplat.Shibboleth.534154414E";

   Cipher remoteCipher;
   SecretKey remotesecretKey;

   public ShibbolethImpl() throws RemoteException
   {
   }

   public ShibbolethImpl(RMISocketFactories x) throws RemoteException
   {
      super(x.getPort(), x.getClientSocketFactory(), x.getServerSocketFactory());
   }

   public byte[] swapEncodedPublicKeys(byte[] localPublicKeyEncoded)
   throws GeneralSecurityException, RemoteException
   {
      JCEHelper.loadProvider(); //This must be called first before any JCE calls
      PublicKey localPubKey = JCEHelper.unencodePublicKey(localPublicKeyEncoded);
      KeyPair remoteKeyPair = JCEHelper.genDHKeyPair();
      KeyAgreement remoteKeyAgree = KeyAgreement.getInstance("DiffieHellman");
      remoteKeyAgree.init(remoteKeyPair.getPrivate());
      remoteKeyAgree.doPhase(localPubKey, true);
      remotesecretKey = remoteKeyAgree.generateSecret("DESede");
      remoteCipher = Cipher.getInstance(JCEHelper.transformationType);
      return remoteKeyPair.getPublic().getEncoded();
   }

   public void sendIV(byte[] initVect)
   throws GeneralSecurityException, RemoteException
   {
      IvParameterSpec spec = new IvParameterSpec(initVect);
      remoteCipher.init(Cipher.DECRYPT_MODE, remotesecretKey, spec);
   }

   public byte[] decrypt(byte[] ciphertext) throws SessionException
   {
      try
      {
         return remoteCipher.doFinal(ciphertext);
      }
      catch(GeneralSecurityException e)
      {
         throw new SessionException("Check root cause", e);
      }
   }
   
   public void changePassword
   (
      String userName,
      byte[] oldPassword,
      byte[] newPassword,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      changePassword(userName, new String(decrypt(oldPassword)),
         new String(decrypt(newPassword)), extendedCharPasswordFlag);
   }

   public void setPassword
   (
      String objName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      setPassword(objName, new String(decrypt(password)), extendedCharPasswordFlag);
   }

   public void verifyPassword
   (
      String objName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      verifyPassword(objName, new String(decrypt(password)), extendedCharPasswordFlag);
   }

   public void authenticate
   (
      String userName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      authenticate(userName, new String(decrypt(password)), extendedCharPasswordFlag);
   }

   public NMASAndFDN authenticateNAS
   (
      String userName,
      byte[] password,
      boolean extendedCharPasswordFlag
   )
   throws SessionException, RemoteException
   {
      return authenticateNAS(userName, new String(decrypt(password)), extendedCharPasswordFlag);
   }
}
