/*
 * @(#)ClassType.java        1.14 98/09/21
 *
 * Copyright 1994-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

package com.novell.utility.java;

/**
 * This class represents an Java class type.
 * It overrides the relevant methods in class Type.
 *
 * @author         Arthur van Hoff
 * @version         1.14, 09/21/98
 */
public final
class ClassType extends Type {
    /**
     * The fully qualified class name.
     */
    Identifier className;

    /**
     * Construct a class type. Use Type.tClass to create
     * a new class type.
     */
    ClassType(String typeSig, Identifier className) {
        super(TC_CLASS, typeSig);
        this.className = className;
    }

    public Identifier getClassName() {
        return className;
    }
    
    public String typeString(String id, boolean abbrev, boolean ret) {
        String s = (abbrev ? getClassName().getFlatName() :
                                Identifier.lookup(getClassName().getQualifier(),
                                                                  getClassName().getFlatName())).toString();
        return (id.length() > 0) ? s + " " + id : s;
    }
}
